/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.IOException;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBuildCacheDecorator
implements BuildCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingBuildCacheDecorator.class);
    private final BuildCache delegate;

    public LoggingBuildCacheDecorator(BuildCache delegate) {
        this.delegate = delegate;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        try {
            LOGGER.debug("loading cache key {}", (Object)key);
            return this.delegate.load(key, reader);
        }
        catch (BuildCacheException e) {
            LOGGER.warn("Could not load cache entry for cache key {}", (Object)key, (Object)e);
            throw e;
        }
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        try {
            LOGGER.debug("storing cache key {}", (Object)key);
            this.delegate.store(key, writer);
        }
        catch (BuildCacheException e) {
            LOGGER.warn("Could not store cache entry for cache key {}", (Object)key, (Object)e);
            throw e;
        }
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public void close() throws IOException {
        LOGGER.debug("closing cache {}", (Object)this.getDescription());
        this.delegate.close();
    }
}

