/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.invocation.BuildController;

public class GradleBuildController
implements BuildController {
    private State state = State.Created;
    private boolean hasResult;
    private Object result;
    private final GradleLauncher gradleLauncher;

    public GradleBuildController(GradleLauncher gradleLauncher) {
        this.gradleLauncher = gradleLauncher;
    }

    public GradleLauncher getLauncher() {
        if (this.state == State.Completed) {
            throw new IllegalStateException("Cannot use launcher after build has completed.");
        }
        return this.gradleLauncher;
    }

    public void addNestedListener(Object listener) {
        this.gradleLauncher.addNestedListener(listener);
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public Object getResult() {
        if (!this.hasResult) {
            throw new IllegalStateException("No result has been provided for this build action.");
        }
        return this.result;
    }

    public void setResult(Object result) {
        this.hasResult = true;
        this.result = result;
    }

    public GradleInternal getGradle() {
        return this.getLauncher().getGradle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleInternal run() {
        try {
            GradleInternal gradleInternal = (GradleInternal)this.getLauncher().run().getGradle();
            return gradleInternal;
        }
        finally {
            this.state = State.Completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleInternal configure() {
        try {
            GradleInternal gradleInternal = (GradleInternal)this.getLauncher().getBuildAnalysis().getGradle();
            return gradleInternal;
        }
        finally {
            this.state = State.Completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Created,
        Completed;

    }
}

