/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;

public class JsCatchScope
extends JsScope {
    private final JsName name;

    public JsCatchScope(JsScope parent2, @NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsCatchScope", "<init>"));
        }
        super(parent2, "Catch scope", null);
        this.name = new JsName(this, ident);
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsCatchScope", "declareName"));
        }
        JsName jsName = this.getParent().declareName(identifier);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsCatchScope", "declareName"));
        }
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsCatchScope", "hasOwnName"));
        }
        return this.findOwnName(name2) != null;
    }

    @NotNull
    public JsCatchScope copy() {
        JsCatchScope jsCatchScope = new JsCatchScope(this.getParent(), this.name.getIdent());
        if (jsCatchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsCatchScope", "copy"));
        }
        return jsCatchScope;
    }

    @Override
    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsCatchScope", "findOwnName"));
        }
        return this.name.getIdent().equals(ident) ? this.name : null;
    }
}

