/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSubstitutorImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiAnnotatedJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;

    public ClsJavaCodeReferenceElementImpl(PsiElement parent2, @NotNull String canonicalText) {
        String canonical;
        if (canonicalText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canonicalText", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "<init>"));
        }
        this.myParent = parent2;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText(canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2) {
        String text2 = this.getCanonicalText();
        if (!annotated || annotations2 == null) {
            String string = text2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getCanonicalText"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = ClsJavaCodeReferenceElementImpl.getOuterClassRef(text2);
        int tailStart = 0;
        if (!StringUtil.isEmpty(prefix)) {
            sb.append(prefix).append('.');
            tailStart = prefix.length() + 1;
        }
        PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations2), true);
        sb.append(text2, tailStart, text2.length());
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    private JavaResolveResult advancedResolveImpl(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolveImpl"));
        }
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve2 = this.resolveElement(containingFile);
        if (resolve2 == null) {
            return null;
        }
        if (resolve2 instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index2 = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiClass)resolve2)) {
                if (index2 >= typeElements.length) {
                    PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
                    if (parameterOwner == resolve2) {
                        substitutionMap.put(parameter, null);
                    } else if (parameterOwner instanceof PsiClass) {
                        PsiElement containingClass = this.myParent;
                        while ((containingClass = PsiTreeUtil.getParentOfType(containingClass, PsiClass.class, true)) != null) {
                            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)parameterOwner, (PsiClass)containingClass, PsiSubstitutor.EMPTY);
                            if (superClassSubstitutor == null) continue;
                            substitutionMap.put(parameter, superClassSubstitutor.substitute(parameter));
                            break;
                        }
                    }
                } else {
                    substitutionMap.put(parameter, typeElements[index2].getType());
                }
                ++index2;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve2, this.myCanonicalText, substitutionMap);
            return new CandidateInfo(resolve2, PsiSubstitutorImpl.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve2, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(@NotNull PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "collectOuterClassTypeArgs"));
        }
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null) {
            String outerClassRef = ClsJavaCodeReferenceElementImpl.getOuterClassRef(canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText(outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters).getTypeArguments();
            PsiTypeParameter[] typeParameters2 = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters2.length; ++i) {
                if (args == null || i >= args.length) continue;
                substitutionMap.put(typeParameters2[i], args[i]);
            }
            if (!containingClass.hasModifierProperty("static")) {
                this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
            }
        }
    }

    @NotNull
    @Contract(pure=true)
    private static String getOuterClassRef(String ref) {
        int stack = 0;
        block5: for (int i = ref.length() - 1; i >= 0; --i) {
            char c = ref.charAt(i);
            switch (c) {
                case '<': {
                    --stack;
                    continue block5;
                }
                case '>': {
                    ++stack;
                    continue block5;
                }
                case '.': {
                    if (stack != 0) continue block5;
                    String string = ref.substring(0, i);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getOuterClassRef"));
                    }
                    return string;
                }
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getOuterClassRef"));
        }
        return "";
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolve"));
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file2);
        if (results.length == 0) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "resolveElement"));
        }
        for (PsiElement element = this.getParent(); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (element instanceof PsiMethod) {
                for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable((PsiMethod)element)) {
                    if (!this.myQualifiedName.equals(psiTypeParameter.getName())) continue;
                    return psiTypeParameter;
                }
                continue;
            }
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (this.myQualifiedName.equals(psiClass.getQualifiedName())) {
                return element;
            }
            for (PsiTypeParameter parameter3 : PsiUtil.typeParametersIterable(psiClass)) {
                if (!this.myQualifiedName.equals(parameter3.getName())) continue;
                return parameter3;
            }
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                if (!this.myQualifiedName.equals(innerClass.getQualifiedName())) continue;
                return innerClass;
            }
        }
        Project project = containingFile.getProject();
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance(project).getResolveScope(this);
        return JavaPsiFacade.getInstance(project).findClass(this.myQualifiedName, globalSearchScope);
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return PsiNameHelper.getShortClassName(this.myCanonicalText);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "bindToElement"));
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass2 = (PsiClass)element;
        return this.myCanonicalText.equals(aClass2.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "appendMirrorText"));
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray = this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getTypeParameters"));
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantContextResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @NotNull
        public JavaResolveResult[] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            JavaResolveResult resolveResult = ref.advancedResolveImpl(containingFile);
            if (resolveResult == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            return javaResolveResultArray;
        }
    }
}

