/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.OriginInfoAwareElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightMethodBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightPsiClassBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightReferenceListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class LightPsiClassBuilder
extends LightPsiClassBase
implements OriginInfoAwareElement {
    private final LightModifierList myModifierList;
    private final LightReferenceListBuilder myImplementsList;
    private final LightReferenceListBuilder myExtendsList;
    private final LightTypeParameterListBuilder myTypeParametersList;
    private final Collection<PsiMethod> myMethods;
    private PsiElement myScope;
    private PsiClass myContainingClass;
    private String myOriginInfo;

    public LightPsiClassBuilder(@NotNull PsiElement context, @NotNull String name2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "<init>"));
        }
        super(context, name2);
        this.myModifierList = new LightModifierList(this.getManager());
        this.myImplementsList = new LightReferenceListBuilder(this.getManager(), PsiReferenceList.Role.IMPLEMENTS_LIST);
        this.myExtendsList = new LightReferenceListBuilder(this.getManager(), PsiReferenceList.Role.EXTENDS_LIST);
        this.myTypeParametersList = new LightTypeParameterListBuilder(this.getManager(), this.getLanguage());
        this.myMethods = ContainerUtil.newArrayList();
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    @Override
    @NotNull
    public LightModifierList getModifierList() {
        LightModifierList lightModifierList = this.myModifierList;
        if (lightModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getModifierList"));
        }
        return lightModifierList;
    }

    @Override
    @NotNull
    public LightReferenceListBuilder getExtendsList() {
        LightReferenceListBuilder lightReferenceListBuilder = this.myExtendsList;
        if (lightReferenceListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getExtendsList"));
        }
        return lightReferenceListBuilder;
    }

    @Override
    @NotNull
    public LightReferenceListBuilder getImplementsList() {
        LightReferenceListBuilder lightReferenceListBuilder = this.myImplementsList;
        if (lightReferenceListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getImplementsList"));
        }
        return lightReferenceListBuilder;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getFields"));
        }
        return PsiField.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myMethods.toArray(new PsiMethod[this.myMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getInnerClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getInitializers"));
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getScope() {
        return this.myScope;
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @Override
    @NotNull
    public LightTypeParameterListBuilder getTypeParameterList() {
        LightTypeParameterListBuilder lightTypeParameterListBuilder = this.myTypeParametersList;
        if (lightTypeParameterListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPsiClassBuilder", "getTypeParameterList"));
        }
        return lightTypeParameterListBuilder;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    public LightPsiClassBuilder setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
        return this;
    }

    public LightPsiClassBuilder setScope(PsiElement scope) {
        this.myScope = scope;
        return this;
    }

    public LightPsiClassBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightPsiClassBuilder addMethod(PsiMethod method) {
        if (method instanceof LightMethodBuilder) {
            ((LightMethodBuilder)method).setContainingClass(this);
        }
        this.myMethods.add(method);
        return this;
    }
}

