/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class MavenVersionSelectorScheme
implements VersionSelectorScheme {
    public static final String LATEST = "LATEST";
    public static final String RELEASE = "RELEASE";
    private static final String LATEST_INTEGRATION = "latest.integration";
    private static final String LATEST_RELEASE = "latest.release";
    private final VersionSelectorScheme defaultVersionSelectorScheme;

    public MavenVersionSelectorScheme(VersionSelectorScheme defaultVersionSelectorScheme) {
        this.defaultVersionSelectorScheme = defaultVersionSelectorScheme;
    }

    @Override
    public VersionSelector parseSelector(String selectorString) {
        if (selectorString.equals(RELEASE)) {
            return new LatestVersionSelector(LATEST_RELEASE);
        }
        if (selectorString.equals(LATEST)) {
            return new LatestVersionSelector(LATEST_INTEGRATION);
        }
        return this.defaultVersionSelectorScheme.parseSelector(selectorString);
    }

    @Override
    public String renderSelector(VersionSelector selector) {
        return this.toMavenSyntax(this.defaultVersionSelectorScheme.renderSelector(selector));
    }

    private String toMavenSyntax(String version) {
        if (version.equals(LATEST_INTEGRATION)) {
            return LATEST;
        }
        if (version.equals(LATEST_RELEASE)) {
            return RELEASE;
        }
        if (version.startsWith("]")) {
            version = '(' + version.substring(1);
        }
        if (version.endsWith("[")) {
            version = version.substring(0, version.length() - 1) + ')';
        }
        return version;
    }
}

