/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.tasks.TaskDependency;

public class CompositeArtifactSet
implements ResolvedArtifactSet {
    private final List<ResolvedArtifactSet> sets;

    private CompositeArtifactSet(List<ResolvedArtifactSet> sets) {
        this.sets = sets;
    }

    public static ResolvedArtifactSet of(Collection<? extends ResolvedArtifactSet> sets) {
        ArrayList<ResolvedArtifactSet> filtered = new ArrayList<ResolvedArtifactSet>(sets.size());
        for (ResolvedArtifactSet resolvedArtifactSet : sets) {
            if (resolvedArtifactSet == ResolvedArtifactSet.EMPTY) continue;
            filtered.add(resolvedArtifactSet);
        }
        if (filtered.isEmpty()) {
            return EMPTY;
        }
        if (filtered.size() == 1) {
            return (ResolvedArtifactSet)filtered.get(0);
        }
        return new CompositeArtifactSet(filtered);
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts() {
        LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>();
        for (ResolvedArtifactSet set : this.sets) {
            allArtifacts.addAll(set.getArtifacts());
        }
        return allArtifacts;
    }

    @Override
    public void collectBuildDependencies(Collection<? super TaskDependency> dest) {
        for (ResolvedArtifactSet set : this.sets) {
            set.collectBuildDependencies(dest);
        }
    }

    @Override
    public void visit(ArtifactVisitor visitor) {
        for (ResolvedArtifactSet set : this.sets) {
            set.visit(visitor);
        }
    }
}

