/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;

class CompositeConflictResolver
implements ModuleConflictResolver {
    private final List<ModuleConflictResolver> resolvers = new LinkedList<ModuleConflictResolver>();

    CompositeConflictResolver() {
    }

    @Override
    public <T extends ComponentResolutionState> T select(Collection<? extends T> candidates) {
        for (ModuleConflictResolver r : this.resolvers) {
            T selection = r.select(candidates);
            if (selection == null) continue;
            return selection;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " was unable to select a candidate using resolvers: " + this.resolvers + ". Candidates: " + candidates);
    }

    void addFirst(ModuleConflictResolver conflictResolver) {
        this.resolvers.add(0, conflictResolver);
    }
}

