/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.pgp;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.bc.BcPGPSecretKeyRingCollection;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.internal.Cast;
import org.gradle.internal.IoActions;
import org.gradle.plugins.signing.signatory.pgp.PgpKeyId;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;

public class PgpSignatoryFactory {
    private static final String[] PROPERTIES = new String[]{"keyId", "secretKeyRingFile", "password"};

    public PgpSignatory createSignatory(Project project, boolean required) {
        return this.readProperties(project, null, "default", required);
    }

    public PgpSignatory createSignatory(Project project) {
        return this.createSignatory(project, false);
    }

    public PgpSignatory createSignatory(Project project, String propertyPrefix, boolean required) {
        return this.readProperties(project, propertyPrefix, propertyPrefix, required);
    }

    public PgpSignatory createSignatory(Project project, String propertyPrefix) {
        return this.createSignatory(project, propertyPrefix, false);
    }

    public PgpSignatory createSignatory(Project project, String propertyPrefix, String name, boolean required) {
        return this.readProperties(project, propertyPrefix, name, required);
    }

    public PgpSignatory createSignatory(Project project, String propertyPrefix, String name) {
        return this.createSignatory(project, propertyPrefix, name, false);
    }

    public PgpSignatory createSignatory(String name, String keyId, File keyRing, String password) {
        return this.createSignatory(name, this.readSecretKey(keyId, keyRing), password);
    }

    public PgpSignatory createSignatory(String name, PGPSecretKey secretKey, String password) {
        return new PgpSignatory(name, secretKey, password);
    }

    protected PgpSignatory readProperties(Project project, String prefix, String name) {
        return this.readProperties(project, prefix, name, false);
    }

    protected PgpSignatory readProperties(Project project, String prefix, String name, boolean required) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String property : PROPERTIES) {
            String qualifiedProperty = (String)this.getQualifiedPropertyName(prefix, property);
            if (!project.hasProperty(qualifiedProperty)) {
                if (required) {
                    throw new InvalidUserDataException("property '" + qualifiedProperty + "' could not be found on project and is needed for signing");
                }
                return null;
            }
            values.add(project.property(qualifiedProperty));
        }
        String keyId = values.get(0).toString();
        File keyRing = project.file((Object)values.get(1).toString());
        String password = values.get(2).toString();
        return this.createSignatory(name, keyId, keyRing, password);
    }

    protected Object getQualifiedPropertyName(String propertyPrefix, String name) {
        return "signing." + (propertyPrefix != null ? propertyPrefix + "." : "") + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGPSecretKey readSecretKey(String keyId, File file) {
        InputStream inputStream = this.openSecretKeyFile(file);
        try {
            PGPSecretKey pGPSecretKey = this.readSecretKey(inputStream, keyId, "file: " + file.getAbsolutePath());
            return pGPSecretKey;
        }
        finally {
            IoActions.uncheckedClose((Closeable)inputStream);
        }
    }

    private InputStream openSecretKeyFile(File file) {
        try {
            return ResourceGroovyMethods.newInputStream((File)file);
        }
        catch (FileNotFoundException e) {
            throw new InvalidUserDataException("Unable to retrieve secret key from key ring file '" + String.valueOf(file) + "' as it does not exist");
        }
    }

    protected PGPSecretKey readSecretKey(InputStream input, String keyId, String sourceDescription) {
        BcPGPSecretKeyRingCollection keyRingCollection;
        try {
            keyRingCollection = new BcPGPSecretKeyRingCollection(input);
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Unable to read secret key from " + sourceDescription + " (it may not be a PGP secret key ring)", (Throwable)e);
        }
        return this.readSecretKey((PGPSecretKeyRingCollection)keyRingCollection, this.normalizeKeyId(keyId), sourceDescription);
    }

    protected PGPSecretKey readSecretKey(PGPSecretKeyRingCollection keyRings, PgpKeyId keyId, String sourceDescription) {
        PGPSecretKey key = this.findSecretKey(keyRings, keyId);
        if (key == null) {
            throw new InvalidUserDataException("did not find secret key for id '" + String.valueOf(keyId) + "' in key source '" + sourceDescription + "'");
        }
        return key;
    }

    @Nullable
    private PGPSecretKey findSecretKey(PGPSecretKeyRingCollection keyRings, PgpKeyId keyId) {
        Iterator keyRingIterator = (Iterator)Cast.uncheckedCast((Object)keyRings.getKeyRings());
        while (keyRingIterator.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIterator.next();
            Iterator secretKeyIterator = (Iterator)Cast.uncheckedCast((Object)keyRing.getSecretKeys());
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                if (!this.hasId(keyId, secretKey)) continue;
                return secretKey;
            }
        }
        return null;
    }

    private boolean hasId(PgpKeyId keyId, PGPSecretKey secretKey) {
        return new PgpKeyId(secretKey.getKeyID()).equals(keyId);
    }

    protected PgpKeyId normalizeKeyId(String keyId) {
        try {
            return new PgpKeyId(keyId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserDataException(e.getMessage());
        }
    }
}

