/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.AntBuilder;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.cache.CompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.LocalClassSetAnalysisStore;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarClasspathSnapshotStore;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.cache.CacheRepository;
import org.gradle.internal.Factory;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.platform.base.Platform;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.SingleMessageLogger;

@ParallelizableTask
@CacheableTask
public class JavaCompile
extends AbstractCompile {
    private File dependencyCacheDir;
    private final CompileOptions compileOptions = new CompileOptions();

    public JavaCompile() {
        this.getOutputs().doNotCacheIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return (Boolean)DeprecationLogger.whileDisabled((Factory)new Factory<Boolean>(){

                    public Boolean create() {
                        return JavaCompile.this.compileOptions.isUseDepend();
                    }
                });
            }
        });
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Incubating
    @Inject
    public JavaToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        if (!this.compileOptions.isIncremental()) {
            this.compile();
            return;
        }
        SingleMessageLogger.incubatingFeatureUsed((String)"Incremental java compilation");
        DefaultJavaCompileSpec spec = this.createSpec();
        final CacheRepository cacheRepository = this.getCacheRepository();
        final GeneralCompileCaches generalCompileCaches = this.getGeneralCompileCaches();
        CompileCaches compileCaches = new CompileCaches(){
            private final CacheRepository repository;
            private final JavaCompile javaCompile;
            private final GeneralCompileCaches generalCaches;
            {
                this.repository = cacheRepository;
                this.javaCompile = JavaCompile.this;
                this.generalCaches = generalCompileCaches;
            }

            @Override
            public ClassAnalysisCache getClassAnalysisCache() {
                return this.generalCaches.getClassAnalysisCache();
            }

            @Override
            public JarSnapshotCache getJarSnapshotCache() {
                return this.generalCaches.getJarSnapshotCache();
            }

            @Override
            public LocalJarClasspathSnapshotStore getLocalJarClasspathSnapshotStore() {
                return new LocalJarClasspathSnapshotStore(this.repository, (Object)this.javaCompile);
            }

            @Override
            public LocalClassSetAnalysisStore getLocalClassSetAnalysisStore() {
                return new LocalClassSetAnalysisStore(this.repository, (Object)this.javaCompile);
            }
        };
        IncrementalCompilerFactory factory = new IncrementalCompilerFactory(this.getFileOperations(), (FileHasher)this.getCachingFileHasher(), this.getPath(), this.createCompiler(spec), this.source, compileCaches, (IncrementalTaskInputsInternal)inputs);
        Compiler<JavaCompileSpec> compiler = factory.createCompiler();
        this.performCompilation(spec, compiler);
    }

    @Inject
    protected CachingFileHasher getCachingFileHasher() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected GeneralCompileCaches getGeneralCompileCaches() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CacheRepository getCacheRepository() {
        throw new UnsupportedOperationException();
    }

    protected void compile() {
        DefaultJavaCompileSpec spec = this.createSpec();
        this.performCompilation(spec, this.createCompiler(spec));
    }

    @Inject
    protected Factory<AntBuilder> getAntBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    private CleaningJavaCompiler createCompiler(JavaCompileSpec spec) {
        Compiler javaCompiler = CompilerUtil.castCompiler((Compiler)((JavaToolChainInternal)this.getToolChain()).select((Platform)this.getPlatform()).newCompiler(spec.getClass()));
        return new CleaningJavaCompiler((Compiler<JavaCompileSpec>)javaCompiler, this.getAntBuilderFactory(), this.getOutputs());
    }

    @Nested
    protected JavaPlatform getPlatform() {
        return DefaultJavaPlatform.current();
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = compiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private DefaultJavaCompileSpec createSpec() {
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions).create();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setClasspath((Iterable)this.getClasspath());
        File dependencyCacheDir = (File)DeprecationLogger.whileDisabled((Factory)new Factory<File>(){

            public File create() {
                return JavaCompile.this.getDependencyCacheDir();
            }
        });
        spec.setDependencyCacheDir(dependencyCacheDir);
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setCompileOptions(this.compileOptions);
        return spec;
    }

    @Internal
    @Deprecated
    public File getDependencyCacheDir() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"JavaCompile.getDependencyCacheDir()");
        return this.dependencyCacheDir;
    }

    @Deprecated
    public void setDependencyCacheDir(File dependencyCacheDir) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"JavaCompile.setDependencyCacheDir()");
        this.dependencyCacheDir = dependencyCacheDir;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }
}

