/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.JDKVersion;
import me.qmx.jitescript.JiteClass;
import org.jruby.Ruby;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.collections.NonBlockingHashMapLong;

public class DynamicScopeGenerator {
    private static final NonBlockingHashMapLong<MethodHandle> specializedFactories = new NonBlockingHashMapLong();
    private static ClassDefiningClassLoader CDCL = new OneShotClassLoader(Ruby.getClassLoader());
    public static final List<String> SPECIALIZED_GETS = Collections.unmodifiableList(Arrays.asList("getValueZeroDepthZero", "getValueOneDepthZero", "getValueTwoDepthZero", "getValueThreeDepthZero", "getValueFourDepthZero", "getValueFiveDepthZero", "getValueSixDepthZero", "getValueSevenDepthZero", "getValueEightDepthZero", "getValueNineDepthZero"));
    public static final List<String> SPECIALIZED_GETS_OR_NIL = Collections.unmodifiableList(Arrays.asList("getValueZeroDepthZeroOrNil", "getValueOneDepthZeroOrNil", "getValueTwoDepthZeroOrNil", "getValueThreeDepthZeroOrNil", "getValueFourDepthZeroOrNil", "getValueFiveDepthZeroOrNil", "getValueSixDepthZeroOrNil", "getValueSevenDepthZeroOrNil", "getValueEightDepthZeroOrNil", "getValueNineDepthZeroOrNil"));
    public static final List<String> SPECIALIZED_SETS = Collections.unmodifiableList(Arrays.asList("setValueZeroDepthZeroVoid", "setValueOneDepthZeroVoid", "setValueTwoDepthZeroVoid", "setValueThreeDepthZeroVoid", "setValueFourDepthZeroVoid", "setValueFiveDepthZeroVoid", "setValueSixDepthZeroVoid", "setValueSevenDepthZeroVoid", "setValueEightDepthZeroVoid", "setValueNineDepthZeroVoid"));

    public static MethodHandle generate(final int size2) {
        MethodHandle h = DynamicScopeGenerator.getClassFromSize(size2);
        if (h != null) {
            return h;
        }
        final String clsPath = "org/jruby/runtime/scopes/DynamicScope" + size2;
        final String clsName = clsPath.replaceAll("/", ".");
        try {
            final String[] newFields = DynamicScopeGenerator.varList(size2);
            final String baseName = CodegenUtils.p(DynamicScope.class);
            JiteClass jiteClass = new JiteClass(clsPath, baseName, new String[0]){
                {
                    int offset2;
                    super(x0, x1, x2);
                    this.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, StaticScope.class, DynamicScope.class), new CodeBlock(){
                        {
                            this.aload(0);
                            this.aload(1);
                            this.aload(2);
                            this.invokespecial(baseName, "<init>", CodegenUtils.sig(Void.TYPE, StaticScope.class, DynamicScope.class));
                            this.voidreturn();
                        }
                    });
                    this.defineMethod("getValue", 1, CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE), new CodeBlock(){
                        {
                            LabelNode parentCall = new LabelNode(new Label());
                            this.line(0);
                            this.iload(2);
                            this.ifne(parentCall);
                            if (size2 > 0) {
                                DynamicScopeGenerator.genGetSwitch(clsPath, newFields, this, 1);
                            }
                            this.line(1);
                            this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                            this.athrow();
                            this.label(parentCall);
                            this.line(2);
                            this.aload(0);
                            this.getfield(baseName, "parent", CodegenUtils.ci(DynamicScope.class));
                            this.iload(1);
                            this.iload(2);
                            this.pushInt(1);
                            this.isub();
                            this.invokevirtual(baseName, "getValue", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE));
                            this.areturn();
                        }
                    });
                    this.defineMethod("setValueVoid", 1, CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE, Integer.TYPE), new CodeBlock(){
                        {
                            LabelNode parentCall = new LabelNode(new Label());
                            this.line(3);
                            this.iload(3);
                            this.ifne(parentCall);
                            if (size2 > 0) {
                                DynamicScopeGenerator.genPutSwitch(clsPath, newFields, this, 2);
                            }
                            this.line(4);
                            this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                            this.athrow();
                            this.label(parentCall);
                            this.line(5);
                            this.aload(0);
                            this.getfield(baseName, "parent", CodegenUtils.ci(DynamicScope.class));
                            this.aload(1);
                            this.iload(2);
                            this.iload(3);
                            this.pushInt(1);
                            this.isub();
                            this.invokevirtual(baseName, "setValueVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE, Integer.TYPE));
                            this.voidreturn();
                        }
                    });
                    this.defineMethod("getValueDepthZero", 1, CodegenUtils.sig(IRubyObject.class, Integer.TYPE), new CodeBlock(){
                        {
                            this.line(6);
                            if (size2 > 0) {
                                DynamicScopeGenerator.genGetSwitch(clsPath, newFields, this, 1);
                            }
                            this.line(1);
                            this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                            this.athrow();
                        }
                    });
                    this.defineMethod("setValueDepthZeroVoid", 1, CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE), new CodeBlock(){
                        {
                            this.line(6);
                            if (size2 > 0) {
                                DynamicScopeGenerator.genPutSwitch(clsPath, newFields, this, 2);
                            }
                            this.line(1);
                            this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                            this.athrow();
                        }
                    });
                    int i2 = 0;
                    while (i2 < SPECIALIZED_GETS.size()) {
                        offset2 = i2++;
                        this.defineMethod(SPECIALIZED_GETS.get(offset2), 1, CodegenUtils.sig(IRubyObject.class, new Class[0]), new CodeBlock(){
                            {
                                this.line(6);
                                if (size2 <= offset2) {
                                    this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                                    this.athrow();
                                } else {
                                    this.aload(0);
                                    this.getfield(clsPath, newFields[offset2], CodegenUtils.ci(IRubyObject.class));
                                    this.areturn();
                                }
                            }
                        });
                    }
                    i2 = 0;
                    while (i2 < SPECIALIZED_GETS_OR_NIL.size()) {
                        offset2 = i2++;
                        this.defineMethod(SPECIALIZED_GETS_OR_NIL.get(offset2), 1, CodegenUtils.sig(IRubyObject.class, IRubyObject.class), new CodeBlock(){
                            {
                                this.line(6);
                                if (size2 <= offset2) {
                                    this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                                    this.athrow();
                                } else {
                                    this.aload(0);
                                    this.getfield(clsPath, newFields[offset2], CodegenUtils.ci(IRubyObject.class));
                                    this.dup();
                                    LabelNode ok = new LabelNode(new Label());
                                    this.ifnonnull(ok);
                                    this.pop();
                                    this.aload(0);
                                    this.aload(1);
                                    this.putfield(clsPath, newFields[offset2], CodegenUtils.ci(IRubyObject.class));
                                    this.aload(1);
                                    this.label(ok);
                                    this.areturn();
                                }
                            }
                        });
                    }
                    i2 = 0;
                    while (i2 < SPECIALIZED_SETS.size()) {
                        offset2 = i2++;
                        this.defineMethod(SPECIALIZED_SETS.get(offset2), 1, CodegenUtils.sig(Void.TYPE, IRubyObject.class), new CodeBlock(){
                            {
                                this.line(6);
                                if (size2 <= offset2) {
                                    this.invokestatic(clsPath, "sizeError", CodegenUtils.sig(RuntimeException.class, new Class[0]));
                                    this.athrow();
                                } else {
                                    this.aload(0);
                                    this.aload(1);
                                    this.putfield(clsPath, newFields[offset2], CodegenUtils.ci(IRubyObject.class));
                                    this.voidreturn();
                                }
                            }
                        });
                    }
                    for (String prop : newFields) {
                        this.defineField(prop, 1, CodegenUtils.ci(IRubyObject.class), null);
                    }
                    this.defineMethod("sizeError", 10, CodegenUtils.sig(RuntimeException.class, new Class[0]), new CodeBlock(){
                        {
                            this.newobj(CodegenUtils.p(RuntimeException.class));
                            this.dup();
                            this.ldc(clsName + " only supports scopes with " + size2 + " variables");
                            this.invokespecial(CodegenUtils.p(RuntimeException.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
                            this.areturn();
                        }
                    });
                }
            };
            Class p2 = DynamicScopeGenerator.defineClass(jiteClass);
            MethodHandle mh = MethodHandles.lookup().findConstructor(p2, MethodType.methodType(Void.TYPE, StaticScope.class, DynamicScope.class));
            mh = mh.asType(MethodType.methodType(DynamicScope.class, StaticScope.class, DynamicScope.class));
            MethodHandle previousMH = specializedFactories.putIfAbsent(size2, mh);
            if (previousMH != null) {
                mh = previousMH;
            }
            return mh;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void genGetSwitch(String clsPath, String[] newFields, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        int size2 = newFields.length;
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.getfield(clsPath, newFields[i2], CodegenUtils.ci(IRubyObject.class));
            block.areturn();
        }
        block.label(defaultError);
    }

    private static void genPutSwitch(String clsPath, String[] newFields, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        int size2 = newFields.length;
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.aload(1);
            block.putfield(clsPath, newFields[i2], CodegenUtils.ci(IRubyObject.class));
            block.voidreturn();
        }
        block.label(defaultError);
    }

    private static MethodHandle getClassFromSize(int size2) {
        return specializedFactories.get(size2);
    }

    private static Class defineClass(JiteClass jiteClass) {
        return CDCL.defineClass(jiteClass.getClassName().replaceAll("/", "."), jiteClass.toBytes(JDKVersion.V1_7));
    }

    private static String[] varList(int size2) {
        String[] vars = new String[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            vars[i2] = "var" + i2;
        }
        return vars;
    }
}

