/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.cast.ToFNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToFNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toFNode;
    private final BranchProfile errorProfile = BranchProfile.create();

    public static ToFNode create() {
        return ToFNodeGen.create(null);
    }

    public double doDouble(VirtualFrame frame, Object value) {
        Object doubleObject = this.executeDouble(frame, value);
        if (doubleObject instanceof Double) {
            return (Double)doubleObject;
        }
        this.errorProfile.enter();
        throw new UnsupportedOperationException("executeDouble must return a double, instead it returned a " + doubleObject.getClass().getName());
    }

    public abstract Object executeDouble(VirtualFrame var1, Object var2);

    @Specialization
    public double coerceInt(int value) {
        return value;
    }

    @Specialization
    public double coerceLong(long value) {
        return value;
    }

    @Specialization
    public double coerceDouble(double value) {
        return value;
    }

    @Specialization
    public double coerceBoolean(VirtualFrame frame, boolean value, @Cached(value="create()") BranchProfile errorProfile) {
        return this.coerceObject(frame, value, errorProfile);
    }

    @Specialization
    public double coerceDynamicObject(VirtualFrame frame, DynamicObject object, @Cached(value="create()") BranchProfile errorProfile) {
        return this.coerceObject(frame, object, errorProfile);
    }

    private double coerceObject(VirtualFrame frame, Object object, BranchProfile errorProfile) {
        Object coerced;
        if (this.toFNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toFNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        try {
            coerced = this.toFNode.call(frame, object, "to_f", new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "Float", this));
            }
            throw e;
        }
        if (this.coreLibrary().getLogicalClass(coerced) == this.coreLibrary().getFloatClass()) {
            return (Double)coerced;
        }
        errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "Float", "to_f", coerced, this));
    }
}

