/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ReportElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormattedTextReadHandler
extends ElementReadHandler {
    private final FormattedTextElement element = new FormattedTextElement();

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String formula = attrs.getValue("http://openoffice.org/2005/report", "formula");
        if (formula != null) {
            FormulaExpression valueExpression = new FormulaExpression();
            valueExpression.setFormula(formula);
            this.element.setValueExpression(valueExpression);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://openoffice.org/2005/report".equals(uri)) {
            if ("report-control".equals(tagName)) {
                return new IgnoreAnyChildReadHandler();
            }
            if ("report-element".equals(tagName)) {
                return new ReportElementReadHandler(this.element);
            }
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }
}

