/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class CleanPaginatedBoxesStep
extends IterateVisualProcessStep {
    private long pageOffset;

    public void compute(LogicalPageBox logicalPageBox) {
        this.pageOffset = logicalPageBox.getPageOffset();
        if (this.startBlockLevelBox(logicalPageBox)) {
            this.processBoxChilds(logicalPageBox);
        }
        this.finishBlockLevelBox(logicalPageBox);
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
    }

    protected boolean startBlockLevelBox(RenderBox renderBox) {
        RenderNode renderNode;
        if (renderBox instanceof ParagraphRenderBox) {
            return false;
        }
        if (renderBox instanceof TableSectionRenderBox) {
            return true;
        }
        if (renderBox instanceof TableRowRenderBox) {
            return this.startTableRow((TableRowRenderBox)renderBox);
        }
        RenderNode renderNode2 = renderBox.getVisibleFirst();
        if (renderNode2 == null) {
            return false;
        }
        if (renderNode2.isOpen()) {
            return true;
        }
        long l = renderNode2.getY();
        if (l + renderNode2.getHeight() > this.pageOffset) {
            return l <= this.pageOffset;
        }
        RenderNode renderNode3 = renderNode2;
        while ((renderNode = renderNode3.getVisibleNext()) != null && !renderNode.isOpen() && renderNode.getY() + renderNode.getHeight() <= this.pageOffset) {
            renderNode3 = renderNode;
        }
        long l2 = renderBox.getContentAreaX2() - renderBox.getContentAreaX1();
        long l3 = renderNode3.getY() + renderNode3.getHeight() - l;
        long l4 = renderNode2.getEffectiveMarginTop();
        long l5 = renderNode3.getEffectiveMarginBottom();
        FinishedRenderNode finishedRenderNode = new FinishedRenderNode(l2, l3, l4, l5);
        RenderNode renderNode4 = renderNode2;
        while (renderNode4 != renderNode3) {
            RenderNode renderNode5 = renderNode4.getNext();
            if (renderNode4.isOpen()) {
                throw new IllegalStateException();
            }
            renderBox.remove(renderNode4);
            renderNode4 = renderNode5;
        }
        if (renderNode3.isOpen()) {
            throw new IllegalStateException();
        }
        renderBox.replaceChild(renderNode3, finishedRenderNode);
        if (finishedRenderNode.getParent() != renderBox) {
            throw new IllegalStateException();
        }
        return renderBox.getLastChild() != finishedRenderNode;
    }

    private boolean startTableRow(TableRowRenderBox tableRowRenderBox) {
        return true;
    }
}

