/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public final class ManualMethodSelect
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "ManualMethodSelect.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ManualMethodSelect.HelpCtx");
    private static ManualMethodSelect mms;
    private static JButton okButton;
    private HTMLTextArea hintArea;
    private JTextField className;
    private JTextField methodName;
    private JTextField methodSignature;
    private MethodSelectDocumentListener documentListener = new MethodSelectDocumentListener();

    private ManualMethodSelect() {
        JLabel jLabel = new JLabel();
        this.className = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.methodName = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.methodSignature = new JTextField();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jLabel.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.ManualMethodSelect_ClassNameLabelText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.className.getAccessibleContext().setAccessibleName(Bundle.ManualMethodSelect_ClassNameAccessName());
        this.className.setPreferredSize(new Dimension(290, this.className.getPreferredSize().height));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        this.add((Component)this.className, gridBagConstraints2);
        jLabel2.setLabelFor(this.methodName);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)Bundle.ManualMethodSelect_MethodNameLabelText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        this.methodName.getAccessibleContext().setAccessibleName(Bundle.ManualMethodSelect_MethodNameAccessName());
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        this.add((Component)this.methodName, gridBagConstraints2);
        jLabel3.setLabelFor(this.methodSignature);
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)Bundle.ManualMethodSelect_MethodSignatureLabelText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel3, gridBagConstraints);
        this.methodSignature.getAccessibleContext().setAccessibleName(Bundle.ManualMethodSelect_MethodSignatureAccessName());
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        this.add((Component)this.methodSignature, gridBagConstraints2);
        Color color = UIManager.getColor("Panel.background");
        Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints3);
        this.hintArea.setText(Bundle.ManualMethodSelect_HintMsg());
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(color2);
        this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, color2));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = new Insets(18, 0, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 1;
        this.add((Component)this.hintArea, gridBagConstraints3);
        this.setBorder(new EmptyBorder(12, 12, 0, 12));
        this.className.getDocument().addDocumentListener(this.documentListener);
        this.methodName.getDocument().addDocumentListener(this.documentListener);
        this.methodSignature.getDocument().addDocumentListener(this.documentListener);
        this.updateEnabledState();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static ClientUtils.SourceCodeSelection selectMethod() {
        return ManualMethodSelect.selectMethod(null);
    }

    public static ClientUtils.SourceCodeSelection selectMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        if (mms == null) {
            mms = new ManualMethodSelect();
        }
        if (sourceCodeSelection != null) {
            mms.setClassName(sourceCodeSelection.getClassName());
            mms.setMethodName(sourceCodeSelection.getMethodName());
            mms.setMethodSignature(sourceCodeSelection.getMethodSignature());
        } else {
            mms.setClassName("");
            mms.setMethodName("");
            mms.setMethodSignature("");
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mms, sourceCodeSelection == null ? Bundle.ManualMethodSelect_SelectMethodsDialogCaption() : Bundle.ManualMethodSelect_EditMethodDialogCaption(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == okButton) {
            return mms.getSelectedMethod();
        }
        return null;
    }

    private void setClassName(String string) {
        this.className.setText(ClientUtils.formatClassName((String)string.trim()));
    }

    private String getClassName() {
        return ClientUtils.parseClassName((String)this.className.getText().trim(), (boolean)true);
    }

    private void setMethodName(String string) {
        this.methodName.setText(string.trim());
    }

    private String getMethodName() {
        String string = this.methodName.getText().trim();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    private void setMethodSignature(String string) {
        this.methodSignature.setText(string.trim());
    }

    private String getMethodSignature() {
        String string = this.methodSignature.getText().trim();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    private ClientUtils.SourceCodeSelection getSelectedMethod() {
        return new ClientUtils.SourceCodeSelection(this.getClassName(), this.getMethodName(), this.getMethodSignature());
    }

    private void updateEnabledState() {
        String string;
        boolean bl = true;
        String string2 = this.className.getText().trim();
        String string3 = this.methodName.getText().trim();
        String string4 = this.methodName.getText().trim();
        if (string2.isEmpty()) {
            bl = false;
        }
        if (string3.isEmpty() != string4.isEmpty()) {
            bl = false;
        }
        if ((string = ClientUtils.parseClassName((String)string2, (string3.isEmpty() && string4.isEmpty() ? 1 : 0) != 0)) == null) {
            bl = false;
            this.className.setForeground(Color.red);
        } else {
            this.className.setForeground(UIManager.getColor("Label.foreground"));
        }
        okButton.setEnabled(bl);
    }

    static {
        okButton = new JButton(Bundle.ManualMethodSelect_OKButtonText());
    }

    private final class MethodSelectDocumentListener
    implements DocumentListener {
        private MethodSelectDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ManualMethodSelect.this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ManualMethodSelect.this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ManualMethodSelect.this.updateEnabledState();
        }
    }
}

