/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.applet;

import info.dolezel.fatrat.applet.IconLoader;
import info.dolezel.fatrat.applet.MyAppletStub;
import info.dolezel.fatrat.applet.TransferPopupMenu;
import info.dolezel.fatrat.applet.components.SpeedGraph;
import info.dolezel.fatrat.applet.data.TransferClass;
import info.dolezel.fatrat.applet.dialogs.NewTransfer;
import info.dolezel.fatrat.applet.models.QueueModel;
import info.dolezel.fatrat.applet.models.TransferModel;
import info.dolezel.fatrat.applet.models.data.NameAndState;
import info.dolezel.fatrat.applet.models.renderers.NameAndStateRenderer;
import info.dolezel.fatrat.applet.models.renderers.ProgressRenderer;
import info.dolezel.fatrat.applet.models.renderers.SpeedIconRenderer;
import info.dolezel.fatrat.applet.settings.AppletSettings;
import info.dolezel.fatrat.applet.util.TrustAllCertificates;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class FatRatApplet
extends JApplet
implements IconLoader {
    public static final int[] refreshIntervals = new int[]{2, 5, 15, 30};
    boolean runAsStandalone = false;
    URL standaloneVirtualURL;
    int lastTabIndex = 0;
    XmlRpcClient client;
    Timer timer;
    QueueModel queueModel;
    TransferModel transferModel;
    String baseURL;
    TransferClass[] transferClasses;
    SpeedGraph graphTransfer;
    SpeedGraph graphQueue;
    String lastGlobalLog;
    String lastTransferLog;
    AppletSettings settings;
    TransferPopupMenu transferPopupMenu;
    public Action actionResume;
    public Action actionForceResume;
    public Action actionPause;
    public Action actionMoveToTop;
    public Action actionMoveUp;
    public Action actionMoveDown;
    public Action actionMoveToBottom;
    public Action actionRemove;
    public Action actionRemoveWithData;
    private JButton actionAdd;
    private JButton buttonDelete;
    private JButton buttonDeleteWithData;
    private JButton buttonForceResume;
    private JButton buttonMoveDown;
    private JButton buttonMoveToBottom;
    private JButton buttonMoveToTop;
    private JButton buttonMoveUp;
    private JButton buttonPause;
    private JButton buttonRemoveCompleted;
    private JButton buttonResume;
    private Box.Filler filler1;
    private JTextArea globalLog;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTabbedPane mainTab;
    private JList queues;
    private JComboBox refreshInterval;
    private JToolBar toolbar;
    private JTextArea transferLog;
    private JTable transfers;

    @Override
    public void init() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            TrustAllCertificates.setup();
            this.settings = new AppletSettings(this.getAppletContext());
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FatRatApplet.this.initComponents();
                    this.setupToolbarIcons();
                    this.setupStateIcons();
                    FatRatApplet.this.queueModel = new QueueModel();
                    FatRatApplet.this.queues.setModel(FatRatApplet.this.queueModel);
                    FatRatApplet.this.transferModel = new TransferModel();
                    FatRatApplet.this.transfers.setModel(FatRatApplet.this.transferModel);
                    TableColumnModel m = FatRatApplet.this.transfers.getColumnModel();
                    m.getColumn(1).setCellRenderer(new ProgressRenderer());
                    m.getColumn(0).setCellRenderer(new NameAndStateRenderer());
                    TableColumn col = m.getColumn(0);
                    col.setPreferredWidth(250);
                    col = m.getColumn(3);
                    col.setHeaderRenderer(new SpeedIconRenderer(FatRatApplet.this.loadIcon("/css/icons/download.png")));
                    col = m.getColumn(4);
                    col.setHeaderRenderer(new SpeedIconRenderer(FatRatApplet.this.loadIcon("/css/icons/upload.png")));
                    FatRatApplet.this.graphTransfer = new SpeedGraph();
                    FatRatApplet.this.graphQueue = new SpeedGraph();
                    FatRatApplet.this.graphTransfer.setName("Transfer Speed Graph");
                    FatRatApplet.this.graphQueue.setName("Queue Speed Graph");
                    FatRatApplet.this.mainTab.add((Component)FatRatApplet.this.graphTransfer, 2);
                    FatRatApplet.this.mainTab.add((Component)FatRatApplet.this.graphQueue, 3);
                    FatRatApplet.this.transfers.getSelectionModel().addListSelectionListener(new TransferSelectionListener());
                }

                private void setupToolbarIcons() {
                    FatRatApplet.this.actionAdd.setIcon(FatRatApplet.this.loadIcon("/css/icons/add.png"));
                    FatRatApplet.this.buttonDelete.setIcon(FatRatApplet.this.loadIcon("/css/icons/delete.png"));
                    FatRatApplet.this.buttonDeleteWithData.setIcon(FatRatApplet.this.loadIcon("/css/icons/delete_with_data.png"));
                    FatRatApplet.this.buttonRemoveCompleted.setIcon(FatRatApplet.this.loadIcon("/css/icons/states/completed.png"));
                    FatRatApplet.this.actionResume = new StateAction("Resume", FatRatApplet.this.loadIcon("/css/icons/states/active.png"));
                    FatRatApplet.this.actionPause = new StateAction("Pause", FatRatApplet.this.loadIcon("/css/icons/states/paused.png"));
                    FatRatApplet.this.actionForceResume = new StateAction("Force resume", FatRatApplet.this.loadIcon("/css/icons/states/forcedactive.png"));
                    FatRatApplet.this.buttonResume.setAction(FatRatApplet.this.actionResume);
                    FatRatApplet.this.buttonResume.setActionCommand("Active");
                    FatRatApplet.this.buttonForceResume.setActionCommand("ForcedActive");
                    FatRatApplet.this.buttonForceResume.setAction(FatRatApplet.this.actionForceResume);
                    FatRatApplet.this.buttonPause.setActionCommand("Pause");
                    FatRatApplet.this.buttonPause.setAction(FatRatApplet.this.actionPause);
                    FatRatApplet.this.actionMoveToTop = new MoveAction("Move to top", FatRatApplet.this.loadIcon("/css/icons/move/top.png"));
                    FatRatApplet.this.actionMoveUp = new MoveAction("Move up", FatRatApplet.this.loadIcon("/css/icons/move/up.png"));
                    FatRatApplet.this.actionMoveDown = new MoveAction("Move down", FatRatApplet.this.loadIcon("/css/icons/move/down.png"));
                    FatRatApplet.this.actionMoveToBottom = new MoveAction("Move to bottom", FatRatApplet.this.loadIcon("/css/icons/move/bottom.png"));
                    FatRatApplet.this.buttonMoveToTop.setAction(FatRatApplet.this.actionMoveToTop);
                    FatRatApplet.this.buttonMoveToTop.setActionCommand("top");
                    FatRatApplet.this.buttonMoveUp.setAction(FatRatApplet.this.actionMoveUp);
                    FatRatApplet.this.buttonMoveUp.setActionCommand("up");
                    FatRatApplet.this.buttonMoveDown.setAction(FatRatApplet.this.actionMoveDown);
                    FatRatApplet.this.buttonMoveDown.setActionCommand("down");
                    FatRatApplet.this.buttonMoveToBottom.setAction(FatRatApplet.this.actionMoveToBottom);
                    FatRatApplet.this.buttonMoveToBottom.setActionCommand("bottom");
                    FatRatApplet.this.actionRemove = FatRatApplet.this.actionRemoveWithData = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FatRatApplet.this.removeTransfers("data".equals(e.getActionCommand()));
                        }
                    };
                    FatRatApplet.this.buttonDeleteWithData.setActionCommand("data");
                    FatRatApplet.this.transferPopupMenu = new TransferPopupMenu(FatRatApplet.this);
                }

                private void setupStateIcons() {
                    NameAndState.addIcon("Active", FatRatApplet.this.loadIcon("/css/icons/states/active.png"));
                    NameAndState.addIcon("Active_upload", FatRatApplet.this.loadIcon("/css/icons/states/active_upload.png"));
                    NameAndState.addIcon("Completed", FatRatApplet.this.loadIcon("/css/icons/states/completed.png"));
                    NameAndState.addIcon("Completed_upload", FatRatApplet.this.loadIcon("/css/icons/states/completed_upload.png"));
                    NameAndState.addIcon("Failed", FatRatApplet.this.loadIcon("/css/icons/states/failed_upload.png"));
                    NameAndState.addIcon("Failed_upload", FatRatApplet.this.loadIcon("/css/icons/states/failed_upload.png"));
                    NameAndState.addIcon("ForcedActive", FatRatApplet.this.loadIcon("/css/icons/states/forcedactive.png"));
                    NameAndState.addIcon("ForcedActive_upload", FatRatApplet.this.loadIcon("/css/icons/states/forcedactive_upload.png"));
                    NameAndState.addIcon("Paused", FatRatApplet.this.loadIcon("/css/icons/states/paused.png"));
                    NameAndState.addIcon("Paused_upload", FatRatApplet.this.loadIcon("/css/icons/states/paused_upload.png"));
                    NameAndState.addIcon("Waiting", FatRatApplet.this.loadIcon("/css/icons/states/waiting.png"));
                    NameAndState.addIcon("Waiting_upload", FatRatApplet.this.loadIcon("/css/icons/states/waiting_upload.png"));
                }
            });
            this.setupXmlRpc();
            this.loadTransferClasses();
            RegularUpdateListener timerListener = new RegularUpdateListener();
            int ix = this.settings.getValue("refreshInterval", 1);
            int secs = refreshIntervals[ix];
            this.timer = new Timer(secs * 1000, timerListener);
            this.timer.setInitialDelay(0);
            this.timer.start();
            this.refreshInterval.setSelectedIndex(ix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setupXmlRpc() throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        URL base = this.getDocumentBase();
        String userInfo = base.getUserInfo();
        StringBuilder sb = new StringBuilder();
        sb.append(base.getProtocol()).append("://");
        if (userInfo != null) {
            sb.append(userInfo).append('@');
        }
        sb.append(base.getHost()).append(":").append(base.getPort());
        this.baseURL = sb.toString();
        sb.append("/xmlrpc");
        URL url = new URL(sb.toString());
        System.out.println("XML-RPC URL is: " + url);
        config.setServerURL(url);
        config.setEnabledForExtensions(true);
        if (userInfo != null) {
            System.out.println(userInfo);
            String[] p = userInfo.split(":", 2);
            config.setBasicUserName(p[0]);
            config.setBasicPassword(p[1]);
        }
        this.client = new XmlRpcClient();
        this.client.setConfig(config);
    }

    private void loadTransferClasses() {
        try {
            Object[] list = (Object[])this.client.execute("getTransferClasses", new Object[0]);
            this.transferClasses = new TransferClass[list.length];
            for (int i = 0; i < list.length; ++i) {
                Map props = (Map)list[i];
                this.transferClasses[i] = new TransferClass();
                this.transferClasses[i].setMode((String)props.get("mode"));
                this.transferClasses[i].setShortName((String)props.get("shortName"));
                this.transferClasses[i].setLongName((String)props.get("longName"));
            }
        }
        catch (XmlRpcException ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
        }
    }

    @Override
    public Icon loadIcon(String path) {
        if (this.runAsStandalone) {
            return new ImageIcon(".." + path);
        }
        return new ImageIcon(this.getImage(this.getDocumentBase(), path));
    }

    private void reload() {
        this.queueModel.refresh();
        this.transferModel.refresh();
        if (this.queues.getSelectedIndex() == -1 && this.queueModel.getSize() > 0) {
            this.queues.setSelectedIndex(0);
        }
        this.updateUi();
        int curTab = this.mainTab.getSelectedIndex();
        if (curTab == 2 || curTab == 3) {
            this.updateGraph();
        }
    }

    private void updateUi() {
        boolean qempty = this.queueModel.getSize() == 0;
        int tsel = this.transfers.getSelectedRowCount();
        String state = "";
        if (tsel == 1) {
            state = this.transferModel.getData(this.transfers.getSelectedRow()).get("state").toString();
        }
        this.mainTab.setEnabledAt(1, tsel == 1);
        this.mainTab.setEnabledAt(2, tsel == 1);
        this.mainTab.setEnabledAt(3, !qempty);
        this.actionResume.setEnabled(tsel > 1 || !state.equals("Active") && !state.equals("Waiting"));
        this.actionForceResume.setEnabled(tsel > 1 || !state.equals("ForcedActive"));
        this.actionPause.setEnabled(tsel > 1 || !state.equals("Paused"));
        this.actionMoveToTop.setEnabled(tsel > 0);
        this.actionMoveUp.setEnabled(tsel > 0);
        this.actionMoveDown.setEnabled(tsel > 0);
        this.actionMoveToBottom.setEnabled(tsel > 0);
        this.actionRemove.setEnabled(tsel > 0);
        this.actionRemoveWithData.setEnabled(tsel > 0);
        if (!this.mainTab.isEnabledAt(this.mainTab.getSelectedIndex())) {
            this.mainTab.setSelectedIndex(0);
        }
        this.transferLog.setEnabled(tsel == 1);
    }

    public static void main(String[] argv) {
        try {
            final FatRatApplet applet = new FatRatApplet();
            System.runFinalizersOnExit((boolean)true);
            Frame frame = new Frame("FatRat Remote Control");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    applet.stop();
                    applet.destroy();
                    System.exit(0);
                }
            });
            frame.add("Center", applet);
            applet.setStub(new MyAppletStub(argv, applet));
            frame.show();
            applet.standaloneVirtualURL = new URL(argv[0]);
            applet.runAsStandalone = true;
            applet.init();
            applet.start();
            frame.pack();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    private void reloadData() {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    System.out.println("Loading");
                    Object data = FatRatApplet.this.client.execute("getQueues", Collections.EMPTY_LIST);
                    FatRatApplet.this.queueModel.setData((Object[])data);
                    int sel = FatRatApplet.this.queues.getSelectedIndex();
                    System.out.println("Selected queue: " + sel);
                    if (sel != -1) {
                        data = FatRatApplet.this.client.execute("Queue.getTransfers", new String[]{FatRatApplet.this.queueModel.getData(sel).get("uuid").toString()});
                        FatRatApplet.this.transferModel.setData((Object[])data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                return null;
            }

            @Override
            protected void done() {
                FatRatApplet.this.reload();
            }
        };
        worker.run();
    }

    private void updateGraph() {
        final boolean updateq = this.mainTab.getSelectedIndex() == 3;
        final boolean updatet = this.mainTab.getSelectedIndex() == 2;
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                if (updateq) {
                    int selq = FatRatApplet.this.queues.getSelectedIndex();
                    String quuid = FatRatApplet.this.queueModel.getData(selq).get("uuid").toString();
                    return FatRatApplet.this.client.execute("Queue.getSpeedData", new String[]{quuid}).toString();
                }
                if (updatet) {
                    int selt = FatRatApplet.this.transfers.getSelectedRow();
                    String tuuid = FatRatApplet.this.transferModel.getData(selt).get("uuid").toString();
                    return FatRatApplet.this.client.execute("Transfer.getSpeedData", new String[]{tuuid}).toString();
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    String data = (String)this.get();
                    String[] pairs = data.split(";");
                    SpeedGraph.DataSample[] samples = new SpeedGraph.DataSample[pairs.length];
                    if (data.equals(";")) {
                        samples = null;
                    }
                    for (int i = 0; i < pairs.length; ++i) {
                        String[] v = pairs[i].split(",");
                        if (v == null || v.length != 2) continue;
                        samples[i] = new SpeedGraph.DataSample();
                        samples[i].down = Integer.parseInt(v[0]);
                        samples[i].up = Integer.parseInt(v[1]);
                    }
                    if (updateq) {
                        FatRatApplet.this.graphQueue.setData(samples);
                    } else if (updatet) {
                        FatRatApplet.this.graphTransfer.setData(samples);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(FatRatApplet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        worker.execute();
    }

    private void updateLogs() {
        final int t = this.transfers.getSelectedRow();
        SwingWorker<String[], Void> worker = new SwingWorker<String[], Void>(){

            @Override
            protected String[] doInBackground() throws Exception {
                String[] rv = new String[2];
                URL src = new URL(FatRatApplet.this.baseURL + "/log");
                URLConnection conn = src.openConnection();
                FatRatApplet.setAuthFromURL(conn, src);
                InputStream is = conn.getInputStream();
                rv[0] = new String(IOUtils.toCharArray((InputStream)is, (String)"UTF-8"));
                is.close();
                if (t != -1) {
                    src = new URL(FatRatApplet.this.baseURL + "/log/" + FatRatApplet.this.transferModel.getData(t).get("uuid"));
                    conn = src.openConnection();
                    FatRatApplet.setAuthFromURL(conn, src);
                    is = conn.getInputStream();
                    rv[1] = new String(IOUtils.toCharArray((InputStream)is, (String)"UTF-8"));
                    is.close();
                }
                return rv;
            }

            @Override
            protected void done() {
                try {
                    String[] data = (String[])this.get();
                    String orig = FatRatApplet.this.lastGlobalLog;
                    if (orig != null && data[0].startsWith(orig)) {
                        if (data[0].length() > orig.length()) {
                            FatRatApplet.this.globalLog.append(data[0].substring(orig.length()));
                        }
                    } else {
                        FatRatApplet.this.globalLog.setText(data[0]);
                    }
                    FatRatApplet.this.lastGlobalLog = data[0];
                    orig = FatRatApplet.this.lastTransferLog;
                    if (data[1] == null) {
                        FatRatApplet.this.transferLog.setText(null);
                        FatRatApplet.this.transferLog.setEnabled(false);
                        FatRatApplet.this.lastTransferLog = null;
                    } else if (orig != null && data[1].startsWith(orig)) {
                        if (data[1].length() > orig.length()) {
                            FatRatApplet.this.transferLog.setEnabled(true);
                            FatRatApplet.this.transferLog.append(data[1].substring(orig.length()));
                            FatRatApplet.this.lastTransferLog = data[1];
                        }
                    } else {
                        FatRatApplet.this.transferLog.setEnabled(true);
                        FatRatApplet.this.transferLog.setText(data[1]);
                        FatRatApplet.this.lastTransferLog = data[1];
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(FatRatApplet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        worker.execute();
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.actionAdd = new JButton();
        this.buttonDelete = new JButton();
        this.buttonDeleteWithData = new JButton();
        this.buttonRemoveCompleted = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonResume = new JButton();
        this.buttonForceResume = new JButton();
        this.buttonPause = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonMoveToTop = new JButton();
        this.buttonMoveUp = new JButton();
        this.buttonMoveDown = new JButton();
        this.buttonMoveToBottom = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jLabel2 = new JLabel();
        this.refreshInterval = new JComboBox();
        this.mainTab = new JTabbedPane();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.queues = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.transfers = new JTable();
        this.jPanel1 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane4 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.transferLog = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.globalLog = new JTextArea();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.actionAdd.setToolTipText("Add");
        this.actionAdd.setFocusable(false);
        this.actionAdd.setHorizontalTextPosition(0);
        this.actionAdd.setMargin(new Insets(2, 2, 2, 2));
        this.actionAdd.setMaximumSize(new Dimension(24, 24));
        this.actionAdd.setMinimumSize(new Dimension(24, 24));
        this.actionAdd.setVerticalTextPosition(3);
        this.actionAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionAddActionPerformed(evt);
            }
        });
        this.toolbar.add(this.actionAdd);
        this.buttonDelete.setAction(this.actionRemove);
        this.buttonDelete.setToolTipText("Remove");
        this.buttonDelete.setFocusable(false);
        this.buttonDelete.setHorizontalTextPosition(0);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setMaximumSize(new Dimension(24, 24));
        this.buttonDelete.setVerticalTextPosition(3);
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionRemove(evt);
            }
        });
        this.toolbar.add(this.buttonDelete);
        this.buttonDeleteWithData.setAction(this.actionRemoveWithData);
        this.buttonDeleteWithData.setToolTipText("Remove with data");
        this.buttonDeleteWithData.setFocusable(false);
        this.buttonDeleteWithData.setHorizontalTextPosition(0);
        this.buttonDeleteWithData.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDeleteWithData.setMaximumSize(new Dimension(24, 24));
        this.buttonDeleteWithData.setVerticalTextPosition(3);
        this.buttonDeleteWithData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionRemove(evt);
            }
        });
        this.toolbar.add(this.buttonDeleteWithData);
        this.buttonRemoveCompleted.setToolTipText("Remove completed");
        this.buttonRemoveCompleted.setFocusable(false);
        this.buttonRemoveCompleted.setHorizontalTextPosition(0);
        this.buttonRemoveCompleted.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveCompleted.setMaximumSize(new Dimension(24, 24));
        this.buttonRemoveCompleted.setVerticalTextPosition(3);
        this.buttonRemoveCompleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.buttonRemoveCompleted(evt);
            }
        });
        this.toolbar.add(this.buttonRemoveCompleted);
        this.toolbar.add(this.jSeparator1);
        this.buttonResume.setAction(this.actionResume);
        this.buttonResume.setToolTipText("Resume");
        this.buttonResume.setHideActionText(true);
        this.buttonResume.setMargin(new Insets(2, 2, 2, 2));
        this.buttonResume.setMaximumSize(new Dimension(24, 24));
        this.toolbar.add(this.buttonResume);
        this.buttonForceResume.setAction(this.actionForceResume);
        this.buttonForceResume.setToolTipText("Force resume");
        this.buttonForceResume.setHideActionText(true);
        this.buttonForceResume.setMargin(new Insets(2, 2, 2, 2));
        this.buttonForceResume.setMaximumSize(new Dimension(24, 24));
        this.toolbar.add(this.buttonForceResume);
        this.buttonPause.setAction(this.actionPause);
        this.buttonPause.setToolTipText("Pause");
        this.buttonPause.setHideActionText(true);
        this.buttonPause.setMargin(new Insets(2, 2, 2, 2));
        this.buttonPause.setMaximumSize(new Dimension(24, 24));
        this.toolbar.add(this.buttonPause);
        this.toolbar.add(this.jSeparator2);
        this.buttonMoveToTop.setAction(this.actionMoveToTop);
        this.buttonMoveToTop.setToolTipText("Move to top");
        this.buttonMoveToTop.setHideActionText(true);
        this.buttonMoveToTop.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveToTop.setMaximumSize(new Dimension(24, 24));
        this.buttonMoveToTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionMoveTransfer(evt);
            }
        });
        this.toolbar.add(this.buttonMoveToTop);
        this.buttonMoveUp.setAction(this.actionMoveUp);
        this.buttonMoveUp.setToolTipText("Move up");
        this.buttonMoveUp.setHideActionText(true);
        this.buttonMoveUp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveUp.setMaximumSize(new Dimension(24, 24));
        this.buttonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionMoveTransfer(evt);
            }
        });
        this.toolbar.add(this.buttonMoveUp);
        this.buttonMoveDown.setAction(this.actionMoveDown);
        this.buttonMoveDown.setToolTipText("Move down");
        this.buttonMoveDown.setHideActionText(true);
        this.buttonMoveDown.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveDown.setMaximumSize(new Dimension(24, 24));
        this.buttonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionMoveTransfer(evt);
            }
        });
        this.toolbar.add(this.buttonMoveDown);
        this.buttonMoveToBottom.setAction(this.actionMoveToBottom);
        this.buttonMoveToBottom.setToolTipText("Move to bottom");
        this.buttonMoveToBottom.setHideActionText(true);
        this.buttonMoveToBottom.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveToBottom.setMaximumSize(new Dimension(24, 24));
        this.buttonMoveToBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.actionMoveTransfer(evt);
            }
        });
        this.toolbar.add(this.buttonMoveToBottom);
        this.toolbar.add(this.filler1);
        this.jLabel2.setText("Refresh every");
        this.toolbar.add(this.jLabel2);
        this.refreshInterval.setModel(new DefaultComboBoxModel<String>(new String[]{"2 seconds", "5 seconds", "15 seconds", "30 seconds"}));
        this.refreshInterval.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.refreshInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FatRatApplet.this.refreshIntervalChanged(evt);
            }
        });
        this.toolbar.add(this.refreshInterval);
        this.mainTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FatRatApplet.this.mainTabStateChanged(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(150);
        this.queues.setSelectionMode(0);
        this.queues.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FatRatApplet.this.queuesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.queues);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.transfers.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Progress", "Size", "Speed d", "Speed u", "Time remaining", "Message"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.transfers.setRowHeight(24);
        this.transfers.setSelectionMode(2);
        this.transfers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FatRatApplet.this.transfersMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.transfers);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.mainTab.addTab("Transfers", this.jSplitPane1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 834, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 489, Short.MAX_VALUE));
        this.mainTab.addTab("Details", this.jPanel1);
        this.jSplitPane2.setOrientation(0);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea1);
        this.jSplitPane2.setTopComponent(this.jScrollPane3);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane4.setViewportView(this.jTextArea2);
        this.jSplitPane2.setRightComponent(this.jScrollPane4);
        this.jLabel1.setText("jLabel1");
        this.jSplitPane2.setTopComponent(this.jLabel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Transfer log");
        this.jLabel3.setMaximumSize(new Dimension(9999, 15));
        this.jPanel2.add((Component)this.jLabel3, "First");
        this.transferLog.setColumns(20);
        this.transferLog.setEditable(false);
        this.transferLog.setRows(5);
        this.jScrollPane5.setViewportView(this.transferLog);
        this.jPanel2.add((Component)this.jScrollPane5, "Center");
        this.jSplitPane2.setTopComponent(this.jPanel2);
        this.jPanel3.setLayout(new BorderLayout());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Global log");
        this.jLabel4.setVerticalAlignment(1);
        this.jLabel4.setMaximumSize(new Dimension(9999, 15));
        this.jPanel3.add((Component)this.jLabel4, "First");
        this.globalLog.setColumns(20);
        this.globalLog.setEditable(false);
        this.globalLog.setRows(5);
        this.jScrollPane6.setViewportView(this.globalLog);
        this.jPanel3.add((Component)this.jScrollPane6, "Center");
        this.jSplitPane2.setBottomComponent(this.jPanel3);
        this.mainTab.addTab("Log", this.jSplitPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolbar, -1, 839, Short.MAX_VALUE).addComponent(this.mainTab, -1, 839, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolbar, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainTab, -1, 516, Short.MAX_VALUE)));
    }

    private void queuesValueChanged(ListSelectionEvent evt) {
        this.updateUi();
        this.reloadData();
    }

    private void buttonRemoveCompleted(ActionEvent evt) {
        int[] ts;
        ArrayList<String> uuids = new ArrayList<String>();
        for (int t : ts = this.transfers.getSelectedRows()) {
            Map<String, Object> data = this.transferModel.getData(t);
            String curState = data.get("state").toString();
            if (!curState.equals("Completed")) continue;
            String uuid = data.get("uuid").toString();
            uuids.add(uuid);
        }
        this.removeTransfers(uuids, false);
    }

    private void actionRemove(ActionEvent evt) {
        String question;
        Object src = evt.getSource();
        boolean withData = false;
        if (src.equals(this.buttonDeleteWithData)) {
            withData = true;
        }
        if (JOptionPane.showConfirmDialog(this.rootPane, question = withData ? "Do you really want to delete the selected transfers including the data?" : "Do you really want to delete the selected transfers?", "Delete", 0, 2) != 0) {
            return;
        }
        this.removeTransfers(withData);
    }

    public void removeTransfers(boolean withData) {
        int[] ts;
        ArrayList<String> uuids = new ArrayList<String>(this.transfers.getSelectedRowCount());
        for (int t : ts = this.transfers.getSelectedRows()) {
            uuids.add(this.transferModel.getData(t).get("uuid").toString());
        }
        this.removeTransfers(uuids, withData);
    }

    public void moveTransfer(String dir) {
        int qsel = this.queues.getSelectedIndex();
        int[] tsel = this.transfers.getSelectedRows();
        if (qsel == -1 || tsel.length == 0) {
            return;
        }
        final String quuid = this.queueModel.getData(qsel).get("uuid").toString();
        final String[] tuuid = new String[tsel.length];
        final String fdir = dir;
        for (int i = 0; i < tsel.length; ++i) {
            tuuid[i] = this.transferModel.getData(tsel[i]).get("uuid").toString();
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                FatRatApplet.this.client.execute("Queue.moveTransfers", new Object[]{quuid, tuuid, fdir});
                return null;
            }

            @Override
            protected void done() {
                FatRatApplet.this.reloadData();
                ListSelectionModel model = FatRatApplet.this.transfers.getSelectionModel();
                Object[] data = FatRatApplet.this.transferModel.getData();
                model.clearSelection();
                Arrays.sort(tuuid);
                for (int i = 0; i < data.length; ++i) {
                    Map m = (Map)data[i];
                    String uuid = m.get("uuid").toString();
                    if (Arrays.binarySearch(tuuid, uuid) < 0) continue;
                    model.addSelectionInterval(i, i);
                }
            }
        };
        worker.execute();
    }

    private void actionMoveTransfer(ActionEvent evt) {
        String dir;
        Object src = evt.getSource();
        if (src.equals(this.buttonMoveToTop)) {
            dir = "top";
        } else if (src.equals(this.buttonMoveUp)) {
            dir = "up";
        } else if (src.equals(this.buttonMoveDown)) {
            dir = "down";
        } else if (src.equals(this.buttonMoveToBottom)) {
            dir = "bottom";
        } else {
            return;
        }
        this.moveTransfer(dir);
    }

    private void refreshIntervalChanged(ActionEvent evt) {
        try {
            int i = this.refreshInterval.getSelectedIndex();
            int secs = refreshIntervals[i];
            this.timer.setDelay(secs * 1000);
            this.settings.setValue("refreshInterval", i);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mainTabStateChanged(ChangeEvent evt) {
        if (this.mainTab.getSelectedIndex() != this.lastTabIndex) {
            this.lastTabIndex = this.mainTab.getSelectedIndex();
            this.reloadData();
        }
    }

    private void transfersMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.transferPopupMenu.show(this.transfers, evt.getX(), evt.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionAddActionPerformed(ActionEvent evt) {
        NewTransfer dlg = new NewTransfer(Frame.getFrames()[0], true);
        dlg.setQueueModel(this.queueModel);
        dlg.setTransferClasses(this.transferClasses);
        dlg.setVisible(true);
        if (dlg.getReturnStatus() != 1) {
            return;
        }
        LinkedList<String> urls = new LinkedList<String>(Arrays.asList(dlg.getURLs()));
        ArrayList<File> files = new ArrayList<File>();
        if (urls.isEmpty()) {
            return;
        }
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            String url = (String)it.next();
            if (!url.startsWith("local://")) continue;
            files.add(new File(url.substring(8)));
            it.remove();
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!urls.isEmpty()) {
                Object[] msg = new Object[]{false, dlg.getQueueUUID(), urls.toArray(new String[urls.size()]), dlg.getTransferClass(), dlg.getTargetDirectory(), dlg.addPaused(), dlg.getDownSpeedLimit(), dlg.getUpSpeedLimit()};
                this.client.execute("Queue.addTransfers", msg);
            }
            for (File f : files) {
                Object[] msg = new Object[]{false, dlg.getQueueUUID(), f.getName(), IOUtils.toByteArray((InputStream)new FileInputStream(f)), dlg.getTransferClass(), dlg.getTargetDirectory(), dlg.addPaused(), dlg.getDownSpeedLimit(), dlg.getUpSpeedLimit()};
                this.client.execute("Queue.addTransferWithData", msg);
            }
            this.reloadData();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.rootPane, e, "Error", 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void changeState(String state) {
        int[] ts;
        final ArrayList<String> uuid1 = new ArrayList<String>(this.transfers.getSelectedRowCount());
        final ArrayList<String> uuid2 = new ArrayList<String>();
        for (int t : ts = this.transfers.getSelectedRows()) {
            Map<String, Object> data = this.transferModel.getData(t);
            String uuid = data.get("uuid").toString();
            if (state.equals("Active")) {
                String curState = data.get("state").toString();
                if (!curState.equals("Active") && !curState.equals("ForcedActive")) {
                    uuid2.add(uuid);
                    continue;
                }
                uuid1.add(uuid);
                continue;
            }
            uuid1.add(uuid);
        }
        if (!uuid1.isEmpty() || !uuid2.isEmpty()) {
            final String state1 = state;
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (!uuid1.isEmpty()) {
                        FatRatApplet.this.client.execute("Transfer.setProperties", new Object[]{uuid1, Collections.singletonMap("state", state1)});
                    }
                    if (!uuid2.isEmpty()) {
                        FatRatApplet.this.client.execute("Transfer.setProperties", new Object[]{uuid2, Collections.singletonMap("state", "Waiting")});
                    }
                    return null;
                }

                @Override
                protected void done() {
                    FatRatApplet.this.reloadData();
                }
            };
            worker.execute();
        }
    }

    private void removeTransfers(final List<String> uuids, final boolean withData) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                FatRatApplet.this.client.execute("Transfer.delete", new Object[]{uuids, withData});
                return null;
            }

            @Override
            protected void done() {
                FatRatApplet.this.reloadData();
            }
        };
        worker.execute();
    }

    private static void setAuthFromURL(URLConnection conn, URL url) throws UnsupportedEncodingException {
        String auth = url.getUserInfo();
        if (auth != null) {
            auth = Base64.encodeBase64String((byte[])auth.getBytes("UTF-8"));
            conn.setRequestProperty("Authorization", "Basic " + auth);
        }
    }

    public AppletSettings getSettings() {
        return this.settings;
    }

    public XmlRpcClient getClient() {
        return this.client;
    }

    public Map<String, Object> getCurrentTransfer() {
        int sel = this.transfers.getSelectedRow();
        if (sel < 0) {
            return null;
        }
        return this.transferModel.getData(sel);
    }

    class MoveAction
    extends AbstractAction {
        public MoveAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FatRatApplet.this.moveTransfer(e.getActionCommand());
        }
    }

    class StateAction
    extends AbstractAction {
        public StateAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FatRatApplet.this.changeState(e.getActionCommand());
        }
    }

    class TransferSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            FatRatApplet.this.updateUi();
            FatRatApplet.this.graphTransfer.setData(null);
        }
    }

    private class RegularUpdateListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FatRatApplet.this.reloadData();
            FatRatApplet.this.updateLogs();
        }
    }
}

