/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.mission.Mission;
import org.w3c.dom.Element;

public abstract class AbstractMission
extends FreeColGameObject
implements Mission {
    private Unit unit;
    private int repeatCount = 1;
    private int turnCount;
    private static final String REPEAT_COUNT_TAG = "repeatCount";
    private static final String TURN_COUNT_TAG = "turnCount";
    private static final String UNIT_TAG = "unit";

    @Override
    public final Unit getUnit() {
        return this.unit;
    }

    public AbstractMission(Game game) {
        super(game);
    }

    public AbstractMission(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, null);
    }

    public AbstractMission(Game game, Element e) {
        super(game, null);
        this.readFromXMLElement(e);
    }

    public AbstractMission(Game game, String id) {
        super(game, id);
    }

    public final void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setRepeatCount(int newRepeatCount) {
        this.repeatCount = newRepeatCount;
    }

    public final int getTurnCount() {
        return this.turnCount;
    }

    public final void setTurnCount(int newTurnCount) {
        this.turnCount = newTurnCount;
    }

    @Override
    public boolean isValid() {
        return this.unit != null && !this.unit.isDisposed() && this.repeatCount > 0;
    }

    public static boolean isValidFor(Unit unit) {
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(UNIT_TAG, this.unit);
        xw.writeAttribute(TURN_COUNT_TAG, this.turnCount);
        xw.writeAttribute(REPEAT_COUNT_TAG, this.repeatCount);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.unit = xr.makeFreeColGameObject(this.getGame(), UNIT_TAG, Unit.class, true);
        this.turnCount = xr.getAttribute(TURN_COUNT_TAG, 0);
        this.repeatCount = xr.getAttribute(REPEAT_COUNT_TAG, 1);
    }
}

