/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.binding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.LinkedHashSet;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.language.locals.WriteFrameSlotNode;
import org.jruby.truffle.language.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObject;
import org.jruby.truffle.parser.Translator;

@CoreClass(value="Binding")
public abstract class BindingNodes {
    public static DynamicObject createBinding(RubyContext context, MaterializedFrame frame) {
        MaterializedFrame bindingFrame = Truffle.getRuntime().createMaterializedFrame(RubyArguments.pack(frame, null, RubyArguments.getMethod(frame), RubyArguments.getDeclarationContext(frame), null, RubyArguments.getSelf(frame), RubyArguments.getBlock(frame), RubyArguments.getArguments(frame)), BindingNodes.newFrameDescriptor(context));
        return Layouts.BINDING.createBinding(context.getCoreLibrary().getBindingFactory(), bindingFrame);
    }

    @CompilerDirectives.TruffleBoundary
    private static FrameDescriptor newFrameDescriptor(RubyContext context) {
        return new FrameDescriptor(context.getCoreLibrary().getNilObject());
    }

    public static FrameDescriptor getFrameDescriptor(DynamicObject binding) {
        assert (RubyGuards.isRubyBinding(binding));
        return Layouts.BINDING.getFrame(binding).getFrameDescriptor();
    }

    public static MaterializedFrame getDeclarationFrame(DynamicObject binding) {
        assert (RubyGuards.isRubyBinding(binding));
        return RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding));
    }

    public static FrameSlotAndDepth findFrameSlotOrNull(DynamicObject binding, DynamicObject symbol) {
        assert (RubyGuards.isRubyBinding(binding));
        assert (RubyGuards.isRubySymbol(symbol));
        String identifier = Layouts.SYMBOL.getString(symbol);
        return BindingNodes.findFrameSlotOrNull(binding, identifier);
    }

    public static FrameSlotAndDepth findFrameSlotOrNull(DynamicObject binding, String identifier) {
        int depth = 0;
        MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
        while (frame != null) {
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot(identifier);
            if (frameSlot != null) {
                return new FrameSlotAndDepth(frameSlot, depth);
            }
            frame = RubyArguments.getDeclarationFrame(frame);
            ++depth;
        }
        return null;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends UnaryCoreMethodNode {
        @Specialization
        public Object receiver(DynamicObject binding) {
            return RubyArguments.getSelf(Layouts.BINDING.getFrame(binding));
        }
    }

    @CoreMethod(names={"local_variables"})
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject localVariables(DynamicObject binding) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            return LocalVariablesNode.listLocalVariables(this.getContext(), frame);
        }

        @CompilerDirectives.TruffleBoundary
        public static DynamicObject listLocalVariables(RubyContext context, Frame frame) {
            LinkedHashSet<DynamicObject> names = new LinkedHashSet<DynamicObject>();
            while (frame != null) {
                for (FrameSlot frameSlot : frame.getFrameDescriptor().getSlots()) {
                    if (!(frameSlot.getIdentifier() instanceof String) || ((String)frameSlot.getIdentifier()).startsWith("rubytruffle_temp_frame_on_stack_marker") || Translator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(frameSlot.getIdentifier())) continue;
                    names.add(context.getSymbolTable().getSymbol((String)frameSlot.getIdentifier()));
                }
                frame = RubyArguments.getDeclarationFrame(frame);
            }
            int size = names.size();
            return ArrayHelpers.createArray(context, names.toArray(new Object[size]), size);
        }
    }

    @ImportStatic(value={BindingNodes.class})
    @CoreMethod(names={"local_variable_set"}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="binding"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class LocalVariableSetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isLastLine(name)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "name == cachedName"}, limit="getCacheLimit()")
        public Object localVariableSetCached(DynamicObject binding, String name, Object value, @Cached(value="name") String cachedName, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlot(binding, name)") FrameSlotAndDepth cachedFrameSlot, @Cached(value="createWriteNode(cachedFrameSlot)") WriteFrameSlotNode writeLocalVariableNode) {
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), cachedFrameSlot.depth);
            return writeLocalVariableNode.executeWrite(frame, value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isLastLine(name)"})
        public Object localVariableSetUncached(DynamicObject binding, String name, Object value) {
            FrameSlotAndDepth frameSlot = this.findFrameSlot(binding, name);
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), frameSlot.depth);
            frame.setObject(frameSlot.slot, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isLastLine(name)"})
        public Object localVariableSetLastLine(DynamicObject binding, String name, Object value) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot(name);
            frame.setObject(frameSlot, ThreadLocalObject.wrap(this.getContext(), value));
            return value;
        }

        protected FrameSlotAndDepth findFrameSlot(DynamicObject binding, String name) {
            FrameSlotAndDepth frameSlot = BindingNodes.findFrameSlotOrNull(binding, name);
            if (frameSlot == null) {
                FrameSlot newSlot = Layouts.BINDING.getFrame(binding).getFrameDescriptor().addFrameSlot(name);
                return new FrameSlotAndDepth(newSlot, 0);
            }
            return frameSlot;
        }

        protected WriteFrameSlotNode createWriteNode(FrameSlotAndDepth frameSlot) {
            return WriteFrameSlotNodeGen.create(frameSlot.slot);
        }

        protected boolean isLastLine(String name) {
            return "$_".equals("name");
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @ImportStatic(value={BindingNodes.class})
    @CoreMethod(names={"local_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="binding"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class LocalVariableGetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization(guards={"name == cachedName", "!isLastLine(cachedName)", "compatibleFrames(binding, cachedBinding)", "cachedFrameSlot != null"}, limit="getCacheLimit()")
        public Object localVariableGetCached(DynamicObject binding, String name, @Cached(value="name") String cachedName, @Cached(value="binding") DynamicObject cachedBinding, @Cached(value="findFrameSlotOrNull(binding, name)") FrameSlotAndDepth cachedFrameSlot, @Cached(value="createReadNode(cachedFrameSlot)") ReadFrameSlotNode readLocalVariableNode) {
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), cachedFrameSlot.depth);
            return readLocalVariableNode.executeRead(frame);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isLastLine(name)"})
        public Object localVariableGetUncached(DynamicObject binding, String name) {
            FrameSlotAndDepth frameSlot = BindingNodes.findFrameSlotOrNull(binding, name);
            if (frameSlot == null) {
                throw new RaiseException(this.coreExceptions().nameErrorLocalVariableNotDefined(name, binding, this));
            }
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), frameSlot.depth);
            return frame.getValue(frameSlot.slot);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isLastLine(name)"})
        public Object localVariableGetLastLine(DynamicObject binding, String name) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot(name);
            if (frameSlot == null) {
                throw new RaiseException(this.coreExceptions().nameErrorLocalVariableNotDefined(name, binding, this));
            }
            Object value = frame.getValue(frameSlot);
            if (value instanceof ThreadLocalObject) {
                return ((ThreadLocalObject)value).get();
            }
            return value;
        }

        protected boolean compatibleFrames(DynamicObject binding1, DynamicObject binding2) {
            MaterializedFrame df2;
            FrameDescriptor fd2;
            FrameDescriptor fd1 = BindingNodes.getFrameDescriptor(binding1);
            if (fd1 != (fd2 = BindingNodes.getFrameDescriptor(binding2)) && (fd1.getSize() != 0 || fd2.getSize() != 0)) {
                return false;
            }
            MaterializedFrame df1 = BindingNodes.getDeclarationFrame(binding1);
            if (df1 == null != ((df2 = BindingNodes.getDeclarationFrame(binding2)) == null)) {
                return false;
            }
            if (df1 == null) {
                return true;
            }
            return df1.getFrameDescriptor() == df2.getFrameDescriptor();
        }

        protected ReadFrameSlotNode createReadNode(FrameSlotAndDepth frameSlot) {
            if (frameSlot == null) {
                return null;
            }
            return ReadFrameSlotNodeGen.create(frameSlot.slot);
        }

        protected boolean isLastLine(String name) {
            return "$_".equals(name);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @ImportStatic(value={BindingNodes.class})
    @CoreMethod(names={"local_variable_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="binding"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class LocalVariableDefinedNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isLastLine(name)"})
        public boolean localVariableDefinedUncached(DynamicObject binding, String name) {
            FrameSlotAndDepth frameSlot = BindingNodes.findFrameSlotOrNull(binding, name);
            return frameSlot != null;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isLastLine(name)"})
        public Object localVariableDefinedLastLine(DynamicObject binding, String name) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot(name);
            return frameSlot != null;
        }

        protected boolean isLastLine(String name) {
            return "$_".equals(name);
        }
    }

    @CoreMethod(names={"dup", "clone"})
    public static abstract class DupNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject dup(DynamicObject binding) {
            DynamicObject copy = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(binding), this.copyFrame(Layouts.BINDING.getFrame(binding)));
            return copy;
        }

        private MaterializedFrame copyFrame(MaterializedFrame frame) {
            MaterializedFrame copy = Truffle.getRuntime().createMaterializedFrame(frame.getArguments(), frame.getFrameDescriptor().copy());
            for (FrameSlot frameSlot : frame.getFrameDescriptor().getSlots()) {
                copy.setObject(copy.getFrameDescriptor().findFrameSlot(frameSlot.getIdentifier()), frame.getValue(frameSlot));
            }
            return copy;
        }
    }

    protected static class FrameSlotAndDepth {
        private final FrameSlot slot;
        private final int depth;

        public FrameSlotAndDepth(FrameSlot slot, int depth) {
            this.slot = slot;
            this.depth = depth;
        }

        public FrameSlot getSlot() {
            return this.slot;
        }
    }
}

