/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.module;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.RaiseIfFrozenNode;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.core.cast.NameToJavaStringNode;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.core.cast.NameToSymbolOrStringNodeGen;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.cast.ToPathNodeGen;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.method.MethodFilter;
import org.jruby.truffle.core.module.ModuleFields;
import org.jruby.truffle.core.module.ModuleNodesFactory;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.symbol.SymbolTable;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ReadSelfNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.constants.GetConstantNode;
import org.jruby.truffle.language.constants.LookupConstantNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.loader.RequireNode;
import org.jruby.truffle.language.methods.AddMethodNode;
import org.jruby.truffle.language.methods.AddMethodNodeGen;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.CanBindMethodToModuleNode;
import org.jruby.truffle.language.methods.CanBindMethodToModuleNodeGen;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.GetCurrentVisibilityNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.ReadInstanceVariableNode;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;
import org.jruby.truffle.language.objects.WriteInstanceVariableNode;
import org.jruby.truffle.language.yield.YieldNode;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.IdUtil;

@CoreClass(value="Module")
public abstract class ModuleNodes {
    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createModule(RubyContext context, DynamicObject selfClass, DynamicObject lexicalParent, String name, Node currentNode) {
        DynamicObject module;
        ModuleFields model = new ModuleFields(context, lexicalParent, name);
        model.rubyModuleObject = module = Layouts.MODULE.createModule(Layouts.CLASS.getInstanceFactory(selfClass), model);
        if (lexicalParent != null) {
            Layouts.MODULE.getFields(module).getAdoptedByLexicalParent(context, lexicalParent, name, currentNode);
        } else if (Layouts.MODULE.getFields((DynamicObject)module).givenBaseName != null) {
            Layouts.MODULE.getFields(module).setFullName(Layouts.MODULE.getFields((DynamicObject)module).givenBaseName);
        }
        return module;
    }

    @CoreMethod(names={"singleton_class?"})
    public static abstract class IsSingletonClassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isRubyClass(rubyModule)"})
        public Object doModule(DynamicObject rubyModule) {
            return false;
        }

        @Specialization(guards={"isRubyClass(rubyClass)"})
        public Object doClass(DynamicObject rubyClass) {
            return Layouts.CLASS.getIsSingleton(rubyClass);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return ModuleNodes.createModule(this.getContext(), rubyClass, null, null, this);
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class SetMethodVisibilityNode
    extends RubyNode {
        private final Visibility visibility;
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;
        @Node.Child
        AddMethodNode addMethodNode;

        public SetMethodVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.nameToJavaStringNode = NameToJavaStringNode.create();
            this.addMethodNode = AddMethodNodeGen.create(context, sourceSection, true, false, null, null, null);
        }

        public abstract DynamicObject executeSetMethodVisibility(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public DynamicObject setMethodVisibility(VirtualFrame frame, DynamicObject module, Object name, @Cached(value="create()") BranchProfile errorProfile) {
            String methodName = this.nameToJavaStringNode.executeToJavaString(frame, name);
            InternalMethod method = Layouts.MODULE.getFields(module).deepMethodSearch(this.getContext(), methodName);
            if (method == null) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().nameErrorUndefinedMethod(methodName, module, this));
            }
            return this.addMethodNode.executeAddMethod(module, method, this.visibility);
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="names")})
    public static abstract class SetVisibilityNode
    extends RubyNode {
        private final Visibility visibility;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public SetVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, visibility, null, null);
        }

        public abstract DynamicObject executeSetVisibility(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization
        public DynamicObject setVisibility(VirtualFrame frame, DynamicObject module, Object[] names) {
            if (names.length == 0) {
                this.setCurrentVisibility(this.visibility);
            } else {
                for (Object name : names) {
                    this.setMethodVisibilityNode.executeSetMethodVisibility(frame, module, name);
                }
            }
            return module;
        }

        private void setCurrentVisibility(Visibility visibility) {
            Frame callerFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
            DeclarationContext.changeVisibility(callerFrame, visibility);
        }
    }

    @CoreMethod(names={"undef_method"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class UndefMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNode.create();
        @Node.Child
        RaiseIfFrozenNode raiseIfFrozenNode;
        @Node.Child
        CallDispatchHeadNode methodUndefinedNode;

        public UndefMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.raiseIfFrozenNode = new RaiseIfFrozenNode(context, sourceSection, new ProfileArgumentNode(new ReadSelfNode()));
            this.methodUndefinedNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public DynamicObject undefMethods(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.undefMethod(frame, module, this.nameToJavaStringNode.executeToJavaString(frame, name));
            }
            return module;
        }

        private void undefMethod(VirtualFrame frame, DynamicObject module, String name) {
            this.raiseIfFrozenNode.execute(frame);
            Layouts.MODULE.getFields(module).undefMethod(this.getContext(), this, name);
            if (RubyGuards.isSingletonClass(module)) {
                DynamicObject receiver = Layouts.CLASS.getAttached(module);
                this.methodUndefinedNode.call(frame, receiver, "singleton_method_undefined", this.getSymbol(name));
            } else {
                this.methodUndefinedNode.call(frame, module, "method_undefined", this.getSymbol(name));
            }
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SnippetNode snippetNode;

        @Specialization
        public DynamicObject toS(VirtualFrame frame, DynamicObject module) {
            String moduleName;
            if (RubyGuards.isSingletonClass(module)) {
                String name;
                DynamicObject attached = Layouts.CLASS.getAttached(module);
                if (Layouts.CLASS.isClass(attached) || Layouts.MODULE.isModule(attached)) {
                    if (this.snippetNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.snippetNode = this.insert(new SnippetNode());
                    }
                    DynamicObject inspectResult = (DynamicObject)this.snippetNode.execute(frame, "Rubinius::Type.inspect(val)", "val", attached);
                    name = StringOperations.getString(inspectResult);
                } else {
                    name = Layouts.MODULE.getFields(module).getName();
                }
                moduleName = "#<Class:" + name + ">";
            } else {
                moduleName = Layouts.MODULE.getFields(module).getName();
            }
            return this.createString(StringOperations.encodeRope(moduleName, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"remove_method"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class RemoveMethodNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile errorProfile = BranchProfile.create();
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNode.create();
        @Node.Child
        IsFrozenNode isFrozenNode;
        @Node.Child
        CallDispatchHeadNode methodRemovedNode;

        public RemoveMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.methodRemovedNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public DynamicObject removeMethods(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.removeMethod(frame, module, this.nameToJavaStringNode.executeToJavaString(frame, name));
            }
            return module;
        }

        private void removeMethod(VirtualFrame frame, DynamicObject module, String name) {
            this.isFrozenNode.raiseIfFrozen(module);
            if (Layouts.MODULE.getFields(module).getMethod(name) != null) {
                Layouts.MODULE.getFields(module).removeMethod(name);
                if (RubyGuards.isSingletonClass(module)) {
                    DynamicObject receiver = Layouts.CLASS.getAttached(module);
                    this.methodRemovedNode.call(frame, receiver, "singleton_method_removed", this.getSymbol(name));
                } else {
                    this.methodRemovedNode.call(frame, module, "method_removed", this.getSymbol(name));
                }
            } else {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().nameErrorMethodNotDefinedIn(module, name, this));
            }
        }
    }

    @CoreMethod(names={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveConstNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object removeConstant(DynamicObject module, String name) {
            RubyConstant oldConstant = Layouts.MODULE.getFields(module).removeConstant(this.getContext(), this, name);
            if (oldConstant == null) {
                throw new RaiseException(this.coreExceptions().nameErrorConstantNotDefined(module, name, this));
            }
            if (oldConstant.isAutoload()) {
                return this.nil();
            }
            return oldConstant.getValue();
        }
    }

    @CoreMethod(names={"remove_class_variable"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveClassVariableNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public Object removeClassVariableString(DynamicObject module, String name) {
            SymbolTable.checkClassVariableName(this.getContext(), name, module, this);
            return ModuleOperations.removeClassVariable(Layouts.MODULE.getFields(module), this.getContext(), this, name);
        }
    }

    @CoreMethod(names={"protected"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class ProtectedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ProtectedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PROTECTED, null, null);
        }

        @Specialization
        public DynamicObject doProtected(VirtualFrame frame, DynamicObject module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_constant"}, rest=true)
    public static abstract class PublicConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNode.create();

        @Specialization
        public DynamicObject publicConstant(VirtualFrame frame, DynamicObject module, Object[] args) {
            for (Object arg : args) {
                String name = this.nameToJavaStringNode.executeToJavaString(frame, arg);
                Layouts.MODULE.getFields(module).changeConstantVisibility(this.getContext(), this, name, false);
            }
            return module;
        }
    }

    @CoreMethod(names={"deprecate_constant"}, rest=true, raiseIfFrozenSelf=true)
    public static abstract class DeprecateConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNode.create();

        public DeprecateConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject deprecateConstant(VirtualFrame frame, DynamicObject module, Object[] args) {
            for (Object arg : args) {
                String name = this.nameToJavaStringNode.executeToJavaString(frame, arg);
                Layouts.MODULE.getFields(module).deprecateConstant(this.getContext(), this, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"private_constant"}, rest=true)
    public static abstract class PrivateConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNode.create();

        @Specialization
        public DynamicObject privateConstant(VirtualFrame frame, DynamicObject module, Object[] args) {
            for (Object arg : args) {
                String name = this.nameToJavaStringNode.executeToJavaString(frame, arg);
                Layouts.MODULE.getFields(module).changeConstantVisibility(this.getContext(), this, name, true);
            }
            return module;
        }
    }

    @CoreMethod(names={"instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceMethodNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        public DynamicObject instanceMethod(DynamicObject module, String name, @Cached(value="create()") BranchProfile errorProfile) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().nameErrorUndefinedMethod(name, module, this));
            }
            return Layouts.UNBOUND_METHOD.createUnboundMethod(this.coreLibrary().getUnboundMethodFactory(), module, method);
        }
    }

    @CoreMethod(names={"instance_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class InstanceMethodsNode
    extends CoreMethodNode {
        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(true, includeAncestors);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject instanceMethods(DynamicObject module, boolean includeAncestors) {
            Object[] objects = Layouts.MODULE.getFields(module).filterMethods(this.getContext(), includeAncestors, MethodFilter.PUBLIC_PROTECTED).toArray();
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"private_method_defined?"}, required=1)
    public static abstract class PrivateMethodDefinedNode
    extends AbstractMethodDefinedNode {
        public PrivateMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, Visibility.PRIVATE);
        }
    }

    @CoreMethod(names={"protected_method_defined?"}, required=1)
    public static abstract class ProtectedMethodDefinedNode
    extends AbstractMethodDefinedNode {
        public ProtectedMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, Visibility.PROTECTED);
        }
    }

    @CoreMethod(names={"public_method_defined?"}, required=1)
    public static abstract class PublicMethodDefinedNode
    extends AbstractMethodDefinedNode {
        public PublicMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, Visibility.PUBLIC);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    protected static abstract class AbstractMethodDefinedNode
    extends CoreMethodNode {
        final Visibility visibility;

        public AbstractMethodDefinedNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        public boolean isMethodDefined(DynamicObject module, String name) {
            return ModuleOperations.lookupMethod(module, name, this.visibility) != null;
        }
    }

    @CoreMethod(names={"private_instance_methods"}, optional=1)
    public static abstract class PrivateInstanceMethodsNode
    extends AbstractInstanceMethodsNode {
        public PrivateInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, Visibility.PRIVATE);
        }
    }

    @CoreMethod(names={"protected_instance_methods"}, optional=1)
    public static abstract class ProtectedInstanceMethodsNode
    extends AbstractInstanceMethodsNode {
        public ProtectedInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, Visibility.PROTECTED);
        }
    }

    @CoreMethod(names={"public_instance_methods"}, optional=1)
    public static abstract class PublicInstanceMethodsNode
    extends AbstractInstanceMethodsNode {
        public PublicInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, Visibility.PUBLIC);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    protected static abstract class AbstractInstanceMethodsNode
    extends CoreMethodNode {
        final Visibility visibility;

        public AbstractInstanceMethodsNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(true, includeAncestors);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public DynamicObject getInstanceMethods(DynamicObject module, boolean includeAncestors) {
            Object[] objects = Layouts.MODULE.getFields(module).filterMethods(this.getContext(), includeAncestors, MethodFilter.by(this.visibility)).toArray();
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"public_instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PublicInstanceMethodNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        public DynamicObject publicInstanceMethod(DynamicObject module, String name, @Cached(value="create()") BranchProfile errorProfile) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().nameErrorUndefinedMethod(name, module, this));
            }
            if (method.getVisibility() != Visibility.PUBLIC) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().nameErrorPrivateMethod(name, module, this));
            }
            return Layouts.UNBOUND_METHOD.createUnboundMethod(this.coreLibrary().getUnboundMethodFactory(), module, method);
        }
    }

    @CoreMethod(names={"private_class_method"}, rest=true)
    public static abstract class PrivateClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public PrivateClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        @Specialization
        public DynamicObject privateClassMethod(VirtualFrame frame, DynamicObject module, Object[] names) {
            DynamicObject singletonClass = this.singletonClassNode.executeSingletonClass(module);
            for (Object name : names) {
                this.setMethodVisibilityNode.executeSetMethodVisibility(frame, singletonClass, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"prepend_features"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class PrependFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TaintResultNode taintResultNode;

        public PrependFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @Specialization(guards={"isRubyModule(target)"})
        public DynamicObject prependFeatures(DynamicObject features, DynamicObject target, @Cached(value="create()") BranchProfile errorProfile) {
            if (RubyGuards.isRubyClass(features)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeError("prepend_features must be called only on modules", this));
            }
            Layouts.MODULE.getFields(target).prepend(this.getContext(), this, features);
            this.taintResultNode.maybeTaint(features, target);
            return this.nil();
        }
    }

    @CoreMethod(names={"private"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class PrivateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        public abstract DynamicObject executePrivate(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization
        public DynamicObject doPrivate(VirtualFrame frame, DynamicObject module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_class_method"}, rest=true)
    public static abstract class PublicClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public PublicClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        @Specialization
        public DynamicObject publicClassMethod(VirtualFrame frame, DynamicObject module, Object[] names) {
            DynamicObject singletonClass = this.singletonClassNode.executeSingletonClass(module);
            for (Object name : names) {
                this.setMethodVisibilityNode.executeSetMethodVisibility(frame, singletonClass, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"public"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class PublicNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        public abstract DynamicObject executePublic(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization
        public DynamicObject doPublic(VirtualFrame frame, DynamicObject module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"nesting"}, onSingleton=true)
    public static abstract class NestingNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject nesting() {
            DynamicObject enclosing;
            ArrayList<DynamicObject> modules = new ArrayList<DynamicObject>();
            DynamicObject object = this.coreLibrary().getObjectClass();
            for (LexicalScope lexicalScope = (method = this.getContext().getCallStack().getCallingMethodIgnoringSend()) == null ? null : method.getSharedMethodInfo().getLexicalScope(); lexicalScope != null && (enclosing = lexicalScope.getLiveModule()) != object; lexicalScope = lexicalScope.getParent()) {
                modules.add(enclosing);
            }
            Object[] objects = modules.toArray(new Object[modules.size()]);
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object name(DynamicObject module, @Cached(value="createIdentityProfile()") ValueProfile fieldsProfile) {
            ModuleFields fields = fieldsProfile.profile(Layouts.MODULE.getFields(module));
            if (!fields.hasPartialName()) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeRope(fields.getName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"module_function"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class ModuleFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ModuleFunctionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.MODULE_FUNCTION, null, null);
        }

        @Specialization
        public DynamicObject moduleFunction(VirtualFrame frame, DynamicObject module, Object[] names, @Cached(value="create()") BranchProfile errorProfile) {
            if (RubyGuards.isRubyClass(module) && !this.coreLibrary().isLoadingRubyCore()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeError("module_function must be called for modules", this));
            }
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"method_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class MethodDefinedNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(true, inherit);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isMethodDefined(DynamicObject module, String name, boolean inherit) {
            InternalMethod method = inherit ? ModuleOperations.lookupMethod(module, name) : Layouts.MODULE.getFields(module).getMethod(name);
            return method != null && !method.getVisibility().isPrivate() && !method.isUndefined();
        }
    }

    @CoreMethod(names={"included_modules"})
    public static abstract class IncludedModulesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject includedModules(DynamicObject module) {
            ArrayList<DynamicObject> modules = new ArrayList<DynamicObject>();
            for (DynamicObject included : Layouts.MODULE.getFields(module).ancestors()) {
                if (RubyGuards.isRubyClass(included) || included == module) continue;
                modules.add(included);
            }
            Object[] objects = modules.toArray(new Object[modules.size()]);
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"included"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class IncludedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject included(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        @Specialization(guards={"!isRubyClass(self)", "isRubyModule(from)", "!isRubyClass(from)"})
        public Object initializeCopyModule(DynamicObject self, DynamicObject from) {
            Layouts.MODULE.getFields(self).initCopy(from);
            return this.nil();
        }

        @Specialization(guards={"isRubyClass(self)", "isRubyClass(from)"})
        public Object initializeCopyClass(DynamicObject self, DynamicObject from, @Cached(value="create()") BranchProfile errorProfile) {
            if (from == this.coreLibrary().getBasicObjectClass()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeError("can't copy the root class", this));
            }
            if (Layouts.CLASS.getIsSingleton(from)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeError("can't copy singleton class", this));
            }
            Layouts.MODULE.getFields(self).initCopy(from);
            DynamicObject selfMetaClass = this.getSingletonClass(self);
            DynamicObject fromMetaClass = Layouts.BASIC_OBJECT.getMetaClass(from);
            assert (Layouts.CLASS.getIsSingleton(fromMetaClass));
            assert (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(self)));
            Layouts.MODULE.getFields(selfMetaClass).initCopy(fromMetaClass);
            return this.nil();
        }

        protected DynamicObject getSingletonClass(DynamicObject object) {
            if (this.singletonClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.singletonClassNode = this.insert(SingletonClassNodeGen.create(this.getContext(), null, null));
            }
            return this.singletonClassNode.executeSingletonClass(object);
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassExecNode classExecNode;

        public abstract DynamicObject executeInitialize(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        void classEval(VirtualFrame frame, DynamicObject module, DynamicObject block) {
            if (this.classExecNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.classExecNode = this.insert(ModuleNodesFactory.ClassExecNodeFactory.create(this.getContext(), null, null));
            }
            this.classExecNode.executeClassExec(frame, module, new Object[]{module}, block);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject module, NotProvided block) {
            return module;
        }

        @Specialization
        public DynamicObject initialize(VirtualFrame frame, DynamicObject module, DynamicObject block) {
            this.classEval(frame, module, block);
            return module;
        }
    }

    @CoreMethod(names={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class ExtendObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public ExtendObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject extendObject(DynamicObject module, DynamicObject object, @Cached(value="create()") BranchProfile errorProfile) {
            if (RubyGuards.isRubyClass(module)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorWrongArgumentType(module, "Module", this));
            }
            Layouts.MODULE.getFields(this.singletonClassNode.executeSingletonClass(object)).include(this.getContext(), this, module);
            return module;
        }
    }

    @CoreMethod(names={"define_method"}, needsBlock=true, required=1, optional=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="proc"), @NodeChild(type=RubyNode.class, value="block")})
    public static abstract class DefineMethodNode
    extends CoreMethodNode {
        @Node.Child
        AddMethodNode addMethodNode;

        public DefineMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.addMethodNode = AddMethodNodeGen.create(context, sourceSection, false, false, null, null, null);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject defineMethod(DynamicObject module, String name, NotProvided proc, NotProvided block) {
            throw new RaiseException(this.coreExceptions().argumentError("needs either proc or block", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject defineMethodBlock(DynamicObject module, String name, NotProvided proc, DynamicObject block) {
            return this.defineMethodProc(module, name, block, NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyProc(proc)"})
        public DynamicObject defineMethodProc(DynamicObject module, String name, DynamicObject proc, NotProvided block) {
            return this.defineMethod(module, name, proc);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyMethod(methodObject)"})
        public DynamicObject defineMethodMethod(DynamicObject module, String name, DynamicObject methodObject, NotProvided block, @Cached(value="createCanBindMethodToModuleNode()") CanBindMethodToModuleNode canBindMethodToModuleNode) {
            InternalMethod method = Layouts.METHOD.getMethod(methodObject);
            if (!canBindMethodToModuleNode.executeCanBindMethodToModule(method, module)) {
                DynamicObject declaringModule = method.getDeclaringModule();
                if (RubyGuards.isSingletonClass(declaringModule)) {
                    throw new RaiseException(this.coreExceptions().typeError("can't bind singleton method to a different class", this));
                }
                throw new RaiseException(this.coreExceptions().typeError("class must be a subclass of " + Layouts.MODULE.getFields(declaringModule).getName(), this));
            }
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method.withName(name));
            return this.getSymbol(name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyUnboundMethod(method)"})
        public DynamicObject defineMethod(DynamicObject module, String name, DynamicObject method, NotProvided block) {
            DynamicObject origin = Layouts.UNBOUND_METHOD.getOrigin(method);
            if (!ModuleOperations.canBindMethodTo(origin, module)) {
                throw new RaiseException(this.coreExceptions().typeError("bind argument must be a subclass of " + Layouts.MODULE.getFields(origin).getName(), this));
            }
            return this.addMethod(module, name, Layouts.UNBOUND_METHOD.getMethod(method));
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject defineMethod(DynamicObject module, String name, DynamicObject proc) {
            RootCallTarget callTarget = (RootCallTarget)Layouts.PROC.getCallTargetForLambdas(proc);
            RubyRootNode rootNode = (RubyRootNode)callTarget.getRootNode();
            SharedMethodInfo info = Layouts.PROC.getSharedMethodInfo(proc).withName(name);
            RubyNode body = NodeUtil.cloneNode(rootNode.getBody());
            CallMethodWithProcBody newBody = new CallMethodWithProcBody(this.getContext(), info.getSourceSection(), Layouts.PROC.getDeclarationFrame(proc), body);
            RubyRootNode newRootNode = new RubyRootNode(this.getContext(), info.getSourceSection(), rootNode.getFrameDescriptor(), info, newBody, false);
            RootCallTarget newCallTarget = Truffle.getRuntime().createCallTarget(newRootNode);
            InternalMethod method = InternalMethod.fromProc(this.getContext(), info, name, module, Visibility.PUBLIC, proc, newCallTarget);
            return this.addMethod(module, name, method);
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject addMethod(DynamicObject module, String name, InternalMethod method) {
            method = method.withName(name);
            Frame frame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            Visibility visibility = GetCurrentVisibilityNode.getVisibilityFromNameAndFrame(name, frame);
            return this.addMethodNode.executeAddMethod(module, method, visibility);
        }

        protected CanBindMethodToModuleNode createCanBindMethodToModuleNode() {
            return CanBindMethodToModuleNodeGen.create(this.getContext(), null, null, null);
        }

        private static class CallMethodWithProcBody
        extends RubyNode {
            private final MaterializedFrame declarationFrame;
            @Node.Child
            private RubyNode procBody;

            public CallMethodWithProcBody(RubyContext context, SourceSection sourceSection, MaterializedFrame declarationFrame, RubyNode procBody) {
                super(context, sourceSection);
                this.declarationFrame = declarationFrame;
                this.procBody = procBody;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                RubyArguments.setDeclarationFrame(frame, this.declarationFrame);
                return this.procBody.execute(frame);
            }
        }
    }

    @CoreMethod(names={"const_set"}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class ConstSetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object setConstant(DynamicObject module, String name, Object value) {
            if (!IdUtil.isValidConstantName19((String)name)) {
                throw new RaiseException(this.coreExceptions().nameError(StringUtils.format("wrong constant name %s", name), module, name, this));
            }
            Layouts.MODULE.getFields(module).setConstant(this.getContext(), this, name, value);
            return value;
        }
    }

    @CoreMethod(names={"const_missing"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ConstMissingNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        public Object constMissing(DynamicObject module, String name) {
            throw new RaiseException(this.coreExceptions().nameErrorUninitializedConstant(module, name, this));
        }
    }

    @CoreMethod(names={"const_get"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstGetNode
    extends CoreMethodNode {
        @Node.Child
        private RequireNode requireNode;
        @Node.Child
        LookupConstantNode lookupConstantNode = LookupConstantNode.create(true, true);
        @Node.Child
        GetConstantNode getConstantNode = GetConstantNode.create();

        @CreateCast(value={"name"})
        public RubyNode coerceToSymbolOrString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(null, null, name);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(true, inherit);
        }

        @Specialization(guards={"inherit", "isRubySymbol(name)"})
        public Object getConstant(VirtualFrame frame, DynamicObject module, DynamicObject name, boolean inherit) {
            return this.getConstant(frame, module, Layouts.SYMBOL.getString(name));
        }

        @Specialization(guards={"!inherit", "isRubySymbol(name)"})
        public Object getConstantNoInherit(VirtualFrame frame, DynamicObject module, DynamicObject name, boolean inherit) {
            return this.getConstantNoInherit(frame, module, Layouts.SYMBOL.getString(name), this);
        }

        @Specialization(guards={"inherit", "isRubyString(name)", "!isScoped(name)"})
        public Object getConstantString(VirtualFrame frame, DynamicObject module, DynamicObject name, boolean inherit) {
            return this.getConstant(frame, module, name.toString());
        }

        @Specialization(guards={"!inherit", "isRubyString(name)", "!isScoped(name)"})
        public Object getConstantNoInheritString(VirtualFrame frame, DynamicObject module, DynamicObject name, boolean inherit) {
            return this.getConstantNoInherit(frame, module, name.toString(), this);
        }

        @Specialization(guards={"isRubyString(fullName)", "isScoped(fullName)"})
        public Object getConstantScoped(DynamicObject module, DynamicObject fullName, boolean inherit) {
            return this.getConstantScoped(module, fullName.toString(), inherit);
        }

        private Object getConstant(VirtualFrame frame, Object module, String name) {
            RubyConstant constant = this.lookupConstantNode.lookupConstant(frame, module, name);
            return this.getConstantNode.executeGetConstant(frame, module, name, constant, this.lookupConstantNode);
        }

        private Object getConstantNoInherit(VirtualFrame frame, DynamicObject module, String name, Node currentNode) {
            RubyConstant constant = ModuleOperations.lookupConstantWithInherit(this.getContext(), module, name, false, currentNode);
            if (constant == null) {
                return this.getConstantNode.executeGetConstant(frame, module, name, null, this.lookupConstantNode);
            }
            if (constant.isAutoload()) {
                this.loadAutoloadedConstant(frame, constant);
                constant = ModuleOperations.lookupConstantWithInherit(this.getContext(), module, name, false, currentNode);
            }
            return constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        private Object getConstantScoped(DynamicObject module, String fullName, boolean inherit) {
            RubyConstant constant = ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this);
            if (constant == null) {
                throw new RaiseException(this.coreExceptions().nameErrorUninitializedConstant(module, fullName, this));
            }
            return constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        boolean isScoped(DynamicObject name) {
            assert (RubyGuards.isRubyString(name));
            return name.toString().contains("::");
        }

        private void loadAutoloadedConstant(VirtualFrame frame, RubyConstant constant) {
            if (this.requireNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.requireNode = this.insert(RequireNode.create());
            }
            String feature = StringOperations.getString((DynamicObject)constant.getValue());
            this.requireNode.executeRequire(frame, feature);
        }
    }

    @CoreMethod(names={"const_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstDefinedNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(true, inherit);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isConstDefined(DynamicObject module, String fullName, boolean inherit) {
            return ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this) != null;
        }
    }

    @CoreMethod(names={"constants"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstantsNode
    extends CoreMethodNode {
        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(true, inherit);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject constants(DynamicObject module, boolean inherit) {
            ArrayList<DynamicObject> constantsArray = new ArrayList<DynamicObject>();
            Iterable<Map.Entry<String, RubyConstant>> constants = inherit ? ModuleOperations.getAllConstants(module) : Layouts.MODULE.getFields(module).getConstants();
            for (Map.Entry<String, RubyConstant> constant : constants) {
                if (constant.getValue().isPrivate()) continue;
                constantsArray.add(this.getSymbol(constant.getKey()));
            }
            Object[] objects = constantsArray.toArray(new Object[constantsArray.size()]);
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"class_variables"})
    public static abstract class ClassVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject getClassVariables(DynamicObject module) {
            Map<String, Object> allClassVariables = ModuleOperations.getAllClassVariables(module);
            int size = allClassVariables.size();
            Object[] store = new Object[size];
            int i = 0;
            for (String variable : allClassVariables.keySet()) {
                store[i++] = this.getSymbol(variable);
            }
            return this.createArray(store, size);
        }
    }

    @CoreMethod(names={"class_variable_set"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class ClassVariableSetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public Object setClassVariable(DynamicObject module, String name, Object value) {
            SymbolTable.checkClassVariableName(this.getContext(), name, module, this);
            ModuleOperations.setClassVariable(this.getContext(), module, name, value, this);
            return value;
        }
    }

    @CoreMethod(names={"class_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ClassVariableGetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public Object getClassVariable(DynamicObject module, String name) {
            SymbolTable.checkClassVariableName(this.getContext(), name, module, this);
            Object value = ModuleOperations.lookupClassVariable(module, name);
            if (value == null) {
                throw new RaiseException(this.coreExceptions().nameErrorUninitializedClassVariable(module, name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"class_variable_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ClassVariableDefinedNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public boolean isClassVariableDefinedString(DynamicObject module, String name) {
            SymbolTable.checkClassVariableName(this.getContext(), name, module, this);
            Object value = ModuleOperations.lookupClassVariable(module, name);
            return value != null;
        }
    }

    @CoreMethod(names={"class_exec", "module_exec"}, rest=true, needsBlock=true)
    public static abstract class ClassExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldNode yield;

        public ClassExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldNode(context, DeclarationContext.CLASS_EVAL);
        }

        public abstract Object executeClassExec(VirtualFrame var1, DynamicObject var2, Object[] var3, DynamicObject var4);

        @Specialization
        public Object classExec(VirtualFrame frame, DynamicObject self, Object[] args, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, self, args);
        }

        @Specialization
        public Object classExec(DynamicObject self, Object[] args, NotProvided block) {
            throw new RaiseException(this.coreExceptions().noBlockGiven(this));
        }
    }

    @CoreMethod(names={"class_eval", "module_eval"}, optional=3, lowerFixnum={3}, needsBlock=true)
    public static abstract class ClassEvalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldNode yield;
        @Node.Child
        private ToStrNode toStrNode;

        public ClassEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldNode(context, DeclarationContext.CLASS_EVAL);
        }

        protected DynamicObject toStr(VirtualFrame frame, Object object) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), null, null));
            }
            return this.toStrNode.executeToStr(frame, object);
        }

        @Specialization(guards={"isRubyString(code)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, DynamicObject code, NotProvided file, NotProvided line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            return this.classEvalSource(frame, module, code, "(eval)", callNode);
        }

        @Specialization(guards={"isRubyString(code)", "isRubyString(file)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, DynamicObject code, DynamicObject file, NotProvided line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            return this.classEvalSource(frame, module, code, file.toString(), callNode);
        }

        @Specialization(guards={"isRubyString(code)", "isRubyString(file)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, DynamicObject code, DynamicObject file, int line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            CodeLoader.DeferredCall deferredCall = this.classEvalSource(module, code, file.toString(), line);
            return deferredCall.call(frame, callNode);
        }

        @Specialization(guards={"wasProvided(code)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, Object code, NotProvided file, NotProvided line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            return this.classEvalSource(frame, module, this.toStr(frame, code), file.toString(), callNode);
        }

        @Specialization(guards={"isRubyString(code)", "wasProvided(file)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, DynamicObject code, Object file, NotProvided line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            return this.classEvalSource(frame, module, code, this.toStr(frame, file).toString(), callNode);
        }

        private Object classEvalSource(VirtualFrame frame, DynamicObject module, DynamicObject code, String file, @Cached(value="create()") IndirectCallNode callNode) {
            CodeLoader.DeferredCall deferredCall = this.classEvalSource(module, code, file, 1);
            return deferredCall.call(frame, callNode);
        }

        @CompilerDirectives.TruffleBoundary
        private CodeLoader.DeferredCall classEvalSource(DynamicObject module, DynamicObject rubySource, String file, int line) {
            assert (RubyGuards.isRubyString(rubySource));
            Rope code = StringOperations.rope(rubySource);
            MaterializedFrame callerFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize();
            Encoding encoding = Layouts.STRING.getRope(rubySource).getEncoding();
            String s = new String(new char[Math.max(line - 1, 0)]);
            String space = StringUtils.replace(s, "\u0000", "\n");
            Source source = this.getContext().getSourceLoader().loadFragment(space + code, file);
            RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, encoding, ParserContext.MODULE, callerFrame, true, this);
            return this.getContext().getCodeLoader().prepareExecute(ParserContext.MODULE, DeclarationContext.CLASS_EVAL, rootNode, callerFrame, module);
        }

        @Specialization
        public Object classEval(VirtualFrame frame, DynamicObject self, NotProvided code, NotProvided file, NotProvided line, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, self, self);
        }

        @Specialization
        public Object classEval(DynamicObject self, NotProvided code, NotProvided file, NotProvided line, NotProvided block) {
            throw new RaiseException(this.coreExceptions().argumentError(0, 1, 2, this));
        }

        @Specialization(guards={"wasProvided(code)"})
        public Object classEval(DynamicObject self, Object code, NotProvided file, NotProvided line, DynamicObject block) {
            throw new RaiseException(this.coreExceptions().argumentError(1, 0, this));
        }
    }

    @CoreMethod(names={"autoload?"}, required=1)
    public static abstract class AutoloadQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubySymbol(name)"})
        public Object autoloadQuerySymbol(DynamicObject module, DynamicObject name) {
            return this.autoloadQuery(module, Layouts.SYMBOL.getString(name));
        }

        @Specialization(guards={"isRubyString(name)"})
        public Object autoloadQueryString(DynamicObject module, DynamicObject name) {
            return this.autoloadQuery(module, name.toString());
        }

        private Object autoloadQuery(DynamicObject module, String name) {
            RubyConstant constant = ModuleOperations.lookupConstant(this.getContext(), module, name);
            if (constant == null || !constant.isAutoload()) {
                return this.nil();
            }
            return constant.getValue();
        }
    }

    @CoreMethod(names={"autoload"}, required=2, unsafe={UnsafeGroup.LOAD})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="filename")})
    public static abstract class AutoloadNode
    extends CoreMethodNode {
        public AutoloadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceNameToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @CreateCast(value={"filename"})
        public RubyNode coerceFilenameToPath(RubyNode filename) {
            return ToPathNodeGen.create(null, null, filename);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(filename)"})
        public DynamicObject autoload(DynamicObject module, String name, DynamicObject filename) {
            if (!IdUtil.isValidConstantName19((String)name)) {
                throw new RaiseException(this.coreExceptions().nameError(StringUtils.format("autoload must be constant name: %s", name), module, name, this));
            }
            if (StringOperations.rope(filename).isEmpty()) {
                throw new RaiseException(this.coreExceptions().argumentError("empty file name", this));
            }
            if (Layouts.MODULE.getFields(module).getConstant(name) != null) {
                return this.nil();
            }
            Layouts.MODULE.getFields(module).setAutoloadConstant(this.getContext(), this, name, filename);
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrWriterNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrWriterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public DynamicObject attrWriter(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrReaderNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;

        public AttrReaderNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
        }

        @Specialization
        public DynamicObject attrReader(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrAccessorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrAccessorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public DynamicObject attrAccessor(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public DynamicObject attr(VirtualFrame frame, DynamicObject module, Object[] names) {
            boolean setter;
            if (names.length == 2 && names[1] instanceof Boolean) {
                setter = (Boolean)names[1];
                names = new Object[]{names[0]};
            } else {
                setter = false;
            }
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
                if (!setter) continue;
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class GenerateAccessorNode
    extends RubyNode {
        final boolean isGetter;
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public GenerateAccessorNode(RubyContext context, SourceSection sourceSection, boolean isGetter) {
            super(context, sourceSection);
            this.isGetter = isGetter;
            this.nameToJavaStringNode = NameToJavaStringNode.create();
        }

        public abstract DynamicObject executeGenerateAccessor(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public DynamicObject generateAccessor(VirtualFrame frame, DynamicObject module, Object nameObject) {
            String name = this.nameToJavaStringNode.executeToJavaString(frame, nameObject);
            this.createAccesor(module, name);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private void createAccesor(DynamicObject module, String name) {
            RubyNode accessInstanceVariable;
            FrameInstance callerFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend();
            SourceSection sourceSection = callerFrame.getCallNode().getEncapsulatingSourceSection();
            RubySourceSection rubySourceSection = new RubySourceSection(sourceSection);
            Visibility visibility = DeclarationContext.findVisibility(callerFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            Arity arity = this.isGetter ? Arity.NO_ARGUMENTS : Arity.ONE_REQUIRED;
            String ivar = "@" + name;
            String accessorName = this.isGetter ? name : name + "=";
            String indicativeName = name + "(attr_" + (this.isGetter ? "reader" : "writer") + ")";
            RubyNode checkArity = Translator.createCheckArityNode(this.getContext(), sourceSection.getSource(), rubySourceSection, arity);
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, LexicalScope.NONE, arity, indicativeName, false, null, false, false, false);
            ProfileArgumentNode self = new ProfileArgumentNode(new ReadSelfNode());
            if (this.isGetter) {
                accessInstanceVariable = new ReadInstanceVariableNode(this.getContext(), sourceSection, ivar, self);
            } else {
                ProfileArgumentNode readArgument = new ProfileArgumentNode(new ReadPreArgumentNode(0, MissingArgumentBehavior.RUNTIME_ERROR));
                accessInstanceVariable = new WriteInstanceVariableNode(this.getContext(), sourceSection, ivar, self, readArgument);
            }
            RubyNode sequence = Translator.sequence(this.getContext(), sourceSection.getSource(), rubySourceSection, Arrays.asList(checkArity, accessInstanceVariable));
            RubyRootNode rootNode = new RubyRootNode(this.getContext(), sourceSection, null, sharedMethodInfo, sequence, false);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
            InternalMethod method = new InternalMethod(this.getContext(), sharedMethodInfo, accessorName, module, visibility, callTarget);
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method);
        }
    }

    @CoreMethod(names={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class AppendFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TaintResultNode taintResultNode;

        public AppendFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @Specialization(guards={"isRubyModule(target)"})
        public DynamicObject appendFeatures(DynamicObject features, DynamicObject target, @Cached(value="create()") BranchProfile errorProfile) {
            if (RubyGuards.isRubyClass(features)) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeError("append_features must be called only on modules", this));
            }
            Layouts.MODULE.getFields(target).include(this.getContext(), this, features);
            this.taintResultNode.maybeTaint(features, target);
            return this.nil();
        }
    }

    @CoreMethod(names={"ancestors"})
    public static abstract class AncestorsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject ancestors(DynamicObject self) {
            ArrayList<DynamicObject> ancestors = new ArrayList<DynamicObject>();
            for (DynamicObject module : Layouts.MODULE.getFields(self).ancestors()) {
                ancestors.add(module);
            }
            Object[] objects = ancestors.toArray(new Object[ancestors.size()]);
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"alias_method"}, required=2, raiseIfFrozenSelf=true, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="newName"), @NodeChild(type=RubyNode.class, value="oldName")})
    public static abstract class AliasMethodNode
    extends CoreMethodNode {
        @CreateCast(value={"newName"})
        public RubyNode coercetNewNameToString(RubyNode newName) {
            return NameToJavaStringNodeGen.create(newName);
        }

        @CreateCast(value={"oldName"})
        public RubyNode coerceOldNameToString(RubyNode oldName) {
            return NameToJavaStringNodeGen.create(oldName);
        }

        @Specialization
        public DynamicObject aliasMethod(DynamicObject module, String newName, String oldName) {
            Layouts.MODULE.getFields(module).alias(this.getContext(), this, newName, oldName);
            return module;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsSubclassOfOrEqualToNode subclassNode;

        private Object isSubclass(DynamicObject self, DynamicObject other) {
            if (this.subclassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.subclassNode = this.insert(ModuleNodesFactory.IsSubclassOfOrEqualToNodeFactory.create(null));
            }
            return this.subclassNode.executeIsSubclassOfOrEqualTo(self, other);
        }

        @Specialization(guards={"isRubyModule(other)"})
        public Object compare(DynamicObject self, DynamicObject other) {
            if (self == other) {
                return 0;
            }
            Object isSubclass = this.isSubclass(self, other);
            if (isSubclass == this.nil()) {
                return this.nil();
            }
            return (Boolean)isSubclass != false ? -1 : 1;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object compareOther(DynamicObject self, DynamicObject other) {
            return this.nil();
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class IsSuperclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSuperclassOfOrEqualTo(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyModule(other)"})
        public Object isSuperclassOfOrEqualTo(DynamicObject self, DynamicObject other) {
            if (self == other || ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSuperclassOfOrEqualToOther(DynamicObject self, DynamicObject other) {
            throw new RaiseException(this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class IsSuperclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSuperclassOf(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyModule(other)"})
        public Object isSuperclassOf(DynamicObject self, DynamicObject other) {
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSuperclassOfOther(DynamicObject self, DynamicObject other) {
            throw new RaiseException(this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class IsSubclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSubclassOfOrEqualTo(DynamicObject var1, DynamicObject var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyModule(other)"})
        public Object isSubclassOfOrEqualTo(DynamicObject self, DynamicObject other) {
            if (self == other || ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSubclassOfOrEqualToOther(DynamicObject self, DynamicObject other) {
            throw new RaiseException(this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class IsSubclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSubclassOf(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyModule(other)"})
        public Object isSubclassOf(DynamicObject self, DynamicObject other) {
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSubclassOfOther(DynamicObject self, DynamicObject other) {
            throw new RaiseException(this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class ContainsInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode;

        public ContainsInstanceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public boolean containsInstance(DynamicObject module, Object instance) {
            return this.isANode.executeIsA(instance, module);
        }
    }
}

