/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.JavaException;

public class JRubyInterop {
    private final Ruby jrubyRuntime;
    private final RubyContext context;
    private String originalInputFile;
    private final String jrubyHome;

    public JRubyInterop(RubyContext context, Ruby jrubyRuntime) {
        this.context = context;
        this.jrubyRuntime = jrubyRuntime;
        this.jrubyHome = this.findJRubyHome();
    }

    public String getJRubyHome() {
        return this.jrubyHome;
    }

    private String findJRubyHome() {
        CodeSource codeSource;
        if (System.getenv("JRUBY_HOME") == null && System.getProperty("jruby.home") == null && (codeSource = Ruby.class.getProtectionDomain().getCodeSource()) != null) {
            String jarDir;
            File currentJarFile;
            try {
                currentJarFile = new File(codeSource.getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new JavaException(e);
            }
            if (currentJarFile.getName().equals("ruby.jar") && new File(jarDir = currentJarFile.getParent(), "lib").isDirectory()) {
                this.jrubyRuntime.setJRubyHome(jarDir);
                return jarDir;
            }
        }
        return this.context.getJRubyRuntime().getJRubyHome();
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject toTruffle(RubyException jrubyException, RubyNode currentNode) {
        switch (jrubyException.getMetaClass().getName()) {
            case "ArgumentError": {
                return this.context.getCoreExceptions().argumentError(jrubyException.getMessage().toString(), currentNode);
            }
            case "RegexpError": {
                return this.context.getCoreExceptions().regexpError(jrubyException.getMessage().toString(), currentNode);
            }
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public String getArg0() {
        return this.jrubyRuntime.getGlobalVariables().get("$0").toString();
    }

    public String[] getArgv() {
        IRubyObject[] jrubyStrings = ((RubyArray)this.jrubyRuntime.getObject().getConstant("ARGV")).toJavaArray();
        String[] strings = new String[jrubyStrings.length];
        for (int n = 0; n < strings.length; ++n) {
            strings[n] = jrubyStrings[n].toString();
        }
        return strings;
    }

    public String[] getOriginalLoadPath() {
        ArrayList<String> loadPath = new ArrayList<String>();
        for (IRubyObject path : ((RubyArray)this.jrubyRuntime.getLoadService().getLoadPath()).toJavaArray()) {
            String pathString = path.toString();
            if (pathString.endsWith("lib/ruby/2.2/site_ruby") || pathString.endsWith("lib/ruby/shared") || pathString.endsWith("lib/ruby/stdlib")) continue;
            if (pathString.startsWith("uri:classloader:")) {
                pathString = "jruby:" + pathString.substring("uri:classloader:".length());
            }
            loadPath.add(pathString);
        }
        return loadPath.toArray(new String[loadPath.size()]);
    }

    public void setVerbose(boolean verbose) {
        this.jrubyRuntime.setVerbose((IRubyObject)this.jrubyRuntime.newBoolean(verbose));
    }

    public void setVerboseNil() {
        this.jrubyRuntime.setVerbose(this.jrubyRuntime.getNil());
    }

    public void setOriginalInputFile(String originalInputFile) {
        this.originalInputFile = originalInputFile;
    }

    public String getOriginalInputFile() {
        return this.originalInputFile;
    }
}

