/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class MethodWriter
extends GeneratorAdapter {
    private final BitSet statements;
    private final CompilerSettings settings;
    private final Deque<List<Type>> stringConcatArgs = WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE == null ? null : new ArrayDeque();

    public MethodWriter(int access, Method method, ClassVisitor cw, BitSet statements, CompilerSettings settings) {
        super(327680, cw.visitMethod(access, method.getName(), method.getDescriptor(), null, null), access, method.getName(), method.getDescriptor());
        this.statements = statements;
        this.settings = settings;
    }

    public void writeStatementOffset(Location location) {
        int offset = location.getOffset();
        assert (!this.statements.get(offset));
        this.statements.set(offset);
    }

    public void writeDebugInfo(Location location) {
        Label label = new Label();
        this.visitLabel(label);
        this.visitLineNumber(location.getOffset() + 1, label);
    }

    public void writeLoopCounter(int slot, int count, Location location) {
        assert (slot != -1);
        this.writeDebugInfo(location);
        Label end = new Label();
        this.iinc(slot, -count);
        this.visitVarInsn(21, slot);
        this.push(0);
        this.ifICmp(157, end);
        this.throwException(WriterConstants.PAINLESS_ERROR_TYPE, "The maximum number of statements that can be executed in a loop has been reached.");
        this.mark(end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCast(Definition.Cast cast) {
        if (cast == null) return;
        Definition.Type from = cast.from;
        Definition.Type to = cast.to;
        if (from.sort == Definition.Sort.CHAR && to.sort == Definition.Sort.STRING) {
            this.invokeStatic(WriterConstants.UTILITY_TYPE, WriterConstants.CHAR_TO_STRING);
            return;
        } else if (from.sort == Definition.Sort.STRING && to.sort == Definition.Sort.CHAR) {
            this.invokeStatic(WriterConstants.UTILITY_TYPE, WriterConstants.STRING_TO_CHAR);
            return;
        } else if (cast.unboxFrom) {
            if (from.sort == Definition.Sort.DEF) {
                if (cast.explicit) {
                    if (to.sort == Definition.Sort.BOOL) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BOOLEAN);
                        return;
                    } else if (to.sort == Definition.Sort.BYTE) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BYTE_EXPLICIT);
                        return;
                    } else if (to.sort == Definition.Sort.SHORT) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_SHORT_EXPLICIT);
                        return;
                    } else if (to.sort == Definition.Sort.CHAR) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_CHAR_EXPLICIT);
                        return;
                    } else if (to.sort == Definition.Sort.INT) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_INT_EXPLICIT);
                        return;
                    } else if (to.sort == Definition.Sort.LONG) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_LONG_EXPLICIT);
                        return;
                    } else if (to.sort == Definition.Sort.FLOAT) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_FLOAT_EXPLICIT);
                        return;
                    } else {
                        if (to.sort != Definition.Sort.DOUBLE) throw new IllegalStateException("Illegal tree structure.");
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_DOUBLE_EXPLICIT);
                    }
                    return;
                } else if (to.sort == Definition.Sort.BOOL) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BOOLEAN);
                    return;
                } else if (to.sort == Definition.Sort.BYTE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BYTE_IMPLICIT);
                    return;
                } else if (to.sort == Definition.Sort.SHORT) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_SHORT_IMPLICIT);
                    return;
                } else if (to.sort == Definition.Sort.CHAR) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_CHAR_IMPLICIT);
                    return;
                } else if (to.sort == Definition.Sort.INT) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_INT_IMPLICIT);
                    return;
                } else if (to.sort == Definition.Sort.LONG) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_LONG_IMPLICIT);
                    return;
                } else if (to.sort == Definition.Sort.FLOAT) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_FLOAT_IMPLICIT);
                    return;
                } else {
                    if (to.sort != Definition.Sort.DOUBLE) throw new IllegalStateException("Illegal tree structure.");
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_DOUBLE_IMPLICIT);
                }
                return;
            } else {
                this.unbox(from.type);
                this.writeCast(from, to);
            }
            return;
        } else if (cast.unboxTo) {
            this.writeCast(from, to);
            this.unbox(to.type);
            return;
        } else if (cast.boxFrom) {
            this.box(from.type);
            this.writeCast(from, to);
            return;
        } else if (cast.boxTo) {
            this.writeCast(from, to);
            this.box(to.type);
            return;
        } else {
            this.writeCast(from, to);
        }
    }

    private void writeCast(Definition.Type from, Definition.Type to) {
        if (from.equals(to)) {
            return;
        }
        if (from.sort.numeric && from.sort.primitive && to.sort.numeric && to.sort.primitive) {
            this.cast(from.type, to.type);
        } else if (!to.clazz.isAssignableFrom(from.clazz)) {
            this.checkCast(to.type);
        }
    }

    public void box(Type type) {
        this.valueOf(type);
    }

    public void writeBranch(Label tru, Label fals) {
        if (tru != null) {
            this.visitJumpInsn(154, tru);
        } else if (fals != null) {
            this.visitJumpInsn(153, fals);
        }
    }

    public int writeNewStrings() {
        if (WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE != null) {
            this.stringConcatArgs.push(new ArrayList());
            return 0;
        }
        this.newInstance(WriterConstants.STRINGBUILDER_TYPE);
        this.dup();
        this.invokeConstructor(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_CONSTRUCTOR);
        return 1;
    }

    public void writeAppendStrings(Definition.Type type) {
        if (WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE != null) {
            this.stringConcatArgs.peek().add(type.type);
            if (this.stringConcatArgs.peek().size() >= 200) {
                this.writeToStrings();
                this.writeNewStrings();
                this.stringConcatArgs.peek().add(WriterConstants.STRING_TYPE);
            }
        } else {
            switch (type.sort) {
                case BOOL: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_BOOLEAN);
                    break;
                }
                case CHAR: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_CHAR);
                    break;
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_INT);
                    break;
                }
                case LONG: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_LONG);
                    break;
                }
                case FLOAT: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_FLOAT);
                    break;
                }
                case DOUBLE: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_DOUBLE);
                    break;
                }
                case STRING: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_STRING);
                    break;
                }
                default: {
                    this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_OBJECT);
                }
            }
        }
    }

    public void writeToStrings() {
        if (WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE != null) {
            String desc = Type.getMethodDescriptor((Type)WriterConstants.STRING_TYPE, (Type[])((Type[])this.stringConcatArgs.pop().stream().toArray(Type[]::new)));
            this.invokeDynamic("concat", desc, WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE, new Object[0]);
        } else {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_TOSTRING);
        }
    }

    public void writeDynamicBinaryInstruction(Location location, Definition.Type returnType, Definition.Type lhs, Definition.Type rhs, Operation operation, int flags) {
        Type methodType = Type.getMethodType((Type)returnType.type, (Type[])new Type[]{lhs.type, rhs.type});
        switch (operation) {
            case MUL: {
                this.invokeDefCall("mul", methodType, 8, flags);
                break;
            }
            case DIV: {
                this.invokeDefCall("div", methodType, 8, flags);
                break;
            }
            case REM: {
                this.invokeDefCall("rem", methodType, 8, flags);
                break;
            }
            case ADD: {
                boolean hasPrimitiveArg;
                boolean bl = hasPrimitiveArg = lhs.clazz.isPrimitive() || rhs.clazz.isPrimitive();
                if (!hasPrimitiveArg) {
                    flags |= 1;
                }
                this.invokeDefCall("add", methodType, 8, flags);
                break;
            }
            case SUB: {
                this.invokeDefCall("sub", methodType, 8, flags);
                break;
            }
            case LSH: {
                this.invokeDefCall("lsh", methodType, 9, flags);
                break;
            }
            case USH: {
                this.invokeDefCall("ush", methodType, 9, flags);
                break;
            }
            case RSH: {
                this.invokeDefCall("rsh", methodType, 9, flags);
                break;
            }
            case BWAND: {
                this.invokeDefCall("and", methodType, 8, flags);
                break;
            }
            case XOR: {
                this.invokeDefCall("xor", methodType, 8, flags);
                break;
            }
            case BWOR: {
                this.invokeDefCall("or", methodType, 8, flags);
                break;
            }
            default: {
                throw location.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    public void writeBinaryInstruction(Location location, Definition.Type type, Operation operation) {
        Definition.Sort sort = type.sort;
        if (!(sort != Definition.Sort.FLOAT && sort != Definition.Sort.DOUBLE || operation != Operation.LSH && operation != Operation.USH && operation != Operation.RSH && operation != Operation.BWAND && operation != Operation.XOR && operation != Operation.BWOR)) {
            throw location.createError(new IllegalStateException("Illegal tree structure."));
        }
        switch (operation) {
            case MUL: {
                this.math(104, type.type);
                break;
            }
            case DIV: {
                this.math(108, type.type);
                break;
            }
            case REM: {
                this.math(112, type.type);
                break;
            }
            case ADD: {
                this.math(96, type.type);
                break;
            }
            case SUB: {
                this.math(100, type.type);
                break;
            }
            case LSH: {
                this.math(120, type.type);
                break;
            }
            case USH: {
                this.math(124, type.type);
                break;
            }
            case RSH: {
                this.math(122, type.type);
                break;
            }
            case BWAND: {
                this.math(126, type.type);
                break;
            }
            case XOR: {
                this.math(130, type.type);
                break;
            }
            case BWOR: {
                this.math(128, type.type);
                break;
            }
            default: {
                throw location.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    public void writeDup(int size, int xsize) {
        if (size == 1) {
            if (xsize == 2) {
                this.dupX2();
            } else if (xsize == 1) {
                this.dupX1();
            } else {
                this.dup();
            }
        } else if (size == 2) {
            if (xsize == 2) {
                this.dup2X2();
            } else if (xsize == 1) {
                this.dup2X1();
            } else {
                this.dup2();
            }
        }
    }

    public void writePop(int size) {
        if (size == 1) {
            this.pop();
        } else if (size == 2) {
            this.pop2();
        }
    }

    public void endMethod() {
        if (this.stringConcatArgs != null && !this.stringConcatArgs.isEmpty()) {
            throw new IllegalStateException("String concat bytecode not completed.");
        }
        super.endMethod();
    }

    public void visitEnd() {
        throw new AssertionError((Object)"Should never call this method on MethodWriter, use endMethod() instead");
    }

    public void invokeDefCall(String name, Type methodType, int flavor, Object ... params) {
        Object[] args = new Object[params.length + 2];
        args[0] = this.settings.getInitialCallSiteDepth();
        args[1] = flavor;
        System.arraycopy(params, 0, args, 2, params.length);
        this.invokeDynamic(name, methodType.getDescriptor(), WriterConstants.DEF_BOOTSTRAP_HANDLE, args);
    }
}

