/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

final class RequestLogger {
    private static final Log tracer = LogFactory.getLog((String)"tracer");

    private RequestLogger() {
    }

    static void logResponse(Log logger, HttpUriRequest request, HttpHost host, HttpResponse httpResponse) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request [" + request.getMethod() + " " + host + RequestLogger.getUri(request.getRequestLine()) + "] returned [" + httpResponse.getStatusLine() + "]"));
        }
        if (tracer.isTraceEnabled()) {
            String responseLine;
            String requestLine;
            try {
                requestLine = RequestLogger.buildTraceRequest(request, host);
            }
            catch (IOException e) {
                requestLine = "";
                tracer.trace((Object)"error while reading request for trace purposes", (Throwable)e);
            }
            try {
                responseLine = RequestLogger.buildTraceResponse(httpResponse);
            }
            catch (IOException e) {
                responseLine = "";
                tracer.trace((Object)"error while reading response for trace purposes", (Throwable)e);
            }
            tracer.trace((Object)(requestLine + '\n' + responseLine));
        }
    }

    static void logFailedRequest(Log logger, HttpUriRequest request, HttpHost host, Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request [" + request.getMethod() + " " + host + RequestLogger.getUri(request.getRequestLine()) + "] failed"), (Throwable)e);
        }
        if (tracer.isTraceEnabled()) {
            String traceRequest;
            try {
                traceRequest = RequestLogger.buildTraceRequest(request, host);
            }
            catch (IOException e1) {
                tracer.trace((Object)"error while reading request for trace purposes", (Throwable)e);
                traceRequest = "";
            }
            tracer.trace((Object)traceRequest);
        }
    }

    static String buildTraceRequest(HttpUriRequest request, HttpHost host) throws IOException {
        HttpEntityEnclosingRequest enclosingRequest;
        String requestLine = "curl -iX " + request.getMethod() + " '" + host + RequestLogger.getUri(request.getRequestLine()) + "'";
        if (request instanceof HttpEntityEnclosingRequest && (enclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            requestLine = requestLine + " -d '";
            HttpEntity entity = enclosingRequest.getEntity();
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(enclosingRequest.getEntity());
                enclosingRequest.setEntity(entity);
            }
            requestLine = requestLine + EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) + "'";
        }
        return requestLine;
    }

    static String buildTraceResponse(HttpResponse httpResponse) throws IOException {
        String responseLine = "# " + httpResponse.getStatusLine().toString();
        for (Header header : httpResponse.getAllHeaders()) {
            responseLine = responseLine + "\n# " + header.getName() + ": " + header.getValue();
        }
        responseLine = responseLine + "\n#";
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
            }
            httpResponse.setEntity(entity);
            ContentType contentType = ContentType.get((HttpEntity)entity);
            Charset charset = StandardCharsets.UTF_8;
            if (contentType != null && contentType.getCharset() != null) {
                charset = contentType.getCharset();
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), charset));){
                String line;
                while ((line = reader.readLine()) != null) {
                    responseLine = responseLine + "\n# " + line;
                }
            }
        }
        return responseLine;
    }

    private static String getUri(RequestLine requestLine) {
        if (requestLine.getUri().charAt(0) != '/') {
            return "/" + requestLine.getUri();
        }
        return requestLine.getUri();
    }
}

