/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.ILambda;
import org.elasticsearch.painless.node.SFunction;
import org.objectweb.asm.Type;

public final class ELambda
extends AExpression
implements ILambda {
    private final String name;
    private final SFunction.FunctionReserved reserved;
    private final List<String> paramTypeStrs;
    private final List<String> paramNameStrs;
    private final List<AStatement> statements;
    private SFunction desugared;
    private List<Locals.Variable> captures;
    private FunctionRef ref;
    private String defPointer;

    public ELambda(String name, SFunction.FunctionReserved reserved, Location location, List<String> paramTypes, List<String> paramNames, List<AStatement> statements) {
        super(location);
        this.name = Objects.requireNonNull(name);
        this.reserved = Objects.requireNonNull(reserved);
        this.paramTypeStrs = Collections.unmodifiableList(paramTypes);
        this.paramNameStrs = Collections.unmodifiableList(paramNames);
        this.statements = Collections.unmodifiableList(statements);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AStatement statement : this.statements) {
            statement.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        List<String> actualParamTypeStrs;
        Definition.Type returnType;
        Definition.Method interfaceMethod;
        if (this.expected == null) {
            interfaceMethod = null;
            returnType = Definition.DEF_TYPE;
            actualParamTypeStrs = this.paramTypeStrs;
        } else {
            interfaceMethod = this.expected.struct.getFunctionalMethod();
            if (interfaceMethod == null) {
                throw this.createError(new IllegalArgumentException("Cannot pass lambda to [" + this.expected.name + "], not a functional interface"));
            }
            if (interfaceMethod.arguments.size() != this.paramTypeStrs.size()) {
                throw new IllegalArgumentException("Incorrect number of parameters for [" + interfaceMethod.name + "] in [" + this.expected.clazz + "]");
            }
            returnType = interfaceMethod.rtn == Definition.VOID_TYPE ? Definition.DEF_TYPE : interfaceMethod.rtn;
            actualParamTypeStrs = new ArrayList<String>();
            for (int i = 0; i < this.paramTypeStrs.size(); ++i) {
                String paramType = this.paramTypeStrs.get(i);
                if (paramType.equals(Definition.DEF_TYPE.name)) {
                    actualParamTypeStrs.add(interfaceMethod.arguments.get((int)i).name);
                    continue;
                }
                actualParamTypeStrs.add(paramType);
            }
        }
        HashSet<String> variables = new HashSet<String>();
        for (AStatement statement : this.statements) {
            statement.extractVariables(variables);
        }
        this.captures = new ArrayList<Locals.Variable>();
        for (String variable : variables) {
            if (!locals.hasVariable(variable)) continue;
            this.captures.add(locals.getVariable(this.location, variable));
        }
        ArrayList<String> paramTypes = new ArrayList<String>();
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Locals.Variable var : this.captures) {
            paramTypes.add(var.type.name);
            paramNames.add(var.name);
        }
        paramTypes.addAll(actualParamTypeStrs);
        paramNames.addAll(this.paramNameStrs);
        this.desugared = new SFunction(this.reserved, this.location, returnType.name, this.name, paramTypes, paramNames, this.statements, true);
        this.desugared.generateSignature();
        this.desugared.analyze(Locals.newLambdaScope(locals.getProgramScope(), returnType, this.desugared.parameters, this.captures.size(), this.reserved.getMaxLoopCounter()));
        if (this.expected == null) {
            this.ref = null;
            this.actual = Definition.getType("String");
            this.defPointer = "Sthis." + this.name + "," + this.captures.size();
        } else {
            this.defPointer = null;
            try {
                this.ref = new FunctionRef(this.expected, interfaceMethod, this.desugared.method, this.captures.size());
            }
            catch (IllegalArgumentException e) {
                throw this.createError(e);
            }
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.ref != null) {
            writer.writeDebugInfo(this.location);
            for (Locals.Variable capture : this.captures) {
                writer.visitVarInsn(capture.type.type.getOpcode(21), capture.getSlot());
            }
            String invokedType = this.ref.invokedType.toMethodDescriptorString();
            Type samMethodType = Type.getMethodType((String)this.ref.samMethodType.toMethodDescriptorString());
            Type interfaceType = Type.getMethodType((String)this.ref.interfaceMethodType.toMethodDescriptorString());
            if (this.ref.needsBridges()) {
                writer.invokeDynamic(this.ref.invokedName, invokedType, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{samMethodType, this.ref.implMethodASM, samMethodType, 4, 1, interfaceType});
            } else {
                writer.invokeDynamic(this.ref.invokedName, invokedType, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{samMethodType, this.ref.implMethodASM, samMethodType, 0});
            }
        } else {
            writer.push(null);
            for (Locals.Variable capture : this.captures) {
                writer.visitVarInsn(capture.type.type.getOpcode(21), capture.getSlot());
            }
        }
        globals.addSyntheticMethod(this.desugared);
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        Type[] types = new Type[this.captures.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.captures.get((int)i).type.type;
        }
        return types;
    }

    @Override
    public String toString() {
        return this.multilineToString(this.pairwiseToString(this.paramTypeStrs, this.paramNameStrs), this.statements);
    }
}

