/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class RestAliasesExistAction
extends BaseRestHandler {
    @Inject
    public RestAliasesExistAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.HEAD, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] aliases = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().aliasesExist(getAliasesRequest, new ActionListener<AliasesExistResponse>(){

            @Override
            public void onResponse(AliasesExistResponse response) {
                try {
                    if (response.isExists()) {
                        channel.sendResponse(new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY));
                    } else {
                        channel.sendResponse(new BytesRestResponse(RestStatus.NOT_FOUND, "text/plain; charset=UTF-8", BytesArray.EMPTY));
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(new BytesRestResponse(ExceptionsHelper.status(e), "text/plain; charset=UTF-8", BytesArray.EMPTY));
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    RestAliasesExistAction.this.logger.error("Failed to send failure response", (Throwable)inner);
                }
            }
        });
    }
}

