/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.support;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.DocValueFormat;

public class IncludeExclude
implements Writeable,
ToXContent {
    private static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    private static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    private static final ParseField PATTERN_FIELD = new ParseField("pattern", new String[0]);
    private final RegExp include;
    private final RegExp exclude;
    private final SortedSet<BytesRef> includeValues;
    private final SortedSet<BytesRef> excludeValues;

    public IncludeExclude(RegExp include, RegExp exclude) {
        if (include == null && exclude == null) {
            throw new IllegalArgumentException();
        }
        this.include = include;
        this.exclude = exclude;
        this.includeValues = null;
        this.excludeValues = null;
    }

    public IncludeExclude(String include, String exclude) {
        this(include == null ? null : new RegExp(include), exclude == null ? null : new RegExp(exclude));
    }

    public IncludeExclude(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
        if (includeValues == null && excludeValues == null) {
            throw new IllegalArgumentException();
        }
        this.include = null;
        this.exclude = null;
        this.includeValues = includeValues;
        this.excludeValues = excludeValues;
    }

    public IncludeExclude(String[] includeValues, String[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(double[] includeValues, double[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(long[] includeValues, long[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(StreamInput in) throws IOException {
        int i;
        int size;
        if (in.readBoolean()) {
            this.includeValues = null;
            this.excludeValues = null;
            String includeString = in.readOptionalString();
            this.include = includeString == null ? null : new RegExp(includeString);
            String excludeString = in.readOptionalString();
            this.exclude = excludeString == null ? null : new RegExp(excludeString);
            return;
        }
        this.include = null;
        this.exclude = null;
        if (in.readBoolean()) {
            size = in.readVInt();
            this.includeValues = new TreeSet<BytesRef>();
            for (i = 0; i < size; ++i) {
                this.includeValues.add(in.readBytesRef());
            }
        } else {
            this.includeValues = null;
        }
        if (in.readBoolean()) {
            size = in.readVInt();
            this.excludeValues = new TreeSet<BytesRef>();
            for (i = 0; i < size; ++i) {
                this.excludeValues.add(in.readBytesRef());
            }
        } else {
            this.excludeValues = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean regexBased = this.isRegexBased();
        out.writeBoolean(regexBased);
        if (regexBased) {
            out.writeOptionalString(this.include == null ? null : this.include.getOriginalString());
            out.writeOptionalString(this.exclude == null ? null : this.exclude.getOriginalString());
        } else {
            boolean hasIncludes = this.includeValues != null;
            out.writeBoolean(hasIncludes);
            if (hasIncludes) {
                out.writeVInt(this.includeValues.size());
                for (BytesRef value : this.includeValues) {
                    out.writeBytesRef(value);
                }
            }
            boolean hasExcludes = this.excludeValues != null;
            out.writeBoolean(hasExcludes);
            if (hasExcludes) {
                out.writeVInt(this.excludeValues.size());
                for (BytesRef value : this.excludeValues) {
                    out.writeBytesRef(value);
                }
            }
        }
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(String[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (String value : values) {
                returnSet.add(new BytesRef((CharSequence)value));
            }
        }
        return returnSet;
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(double[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (double value : values) {
                returnSet.add(new BytesRef((CharSequence)String.valueOf(value)));
            }
        }
        return returnSet;
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(long[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (long value : values) {
                returnSet.add(new BytesRef((CharSequence)String.valueOf(value)));
            }
        }
        return returnSet;
    }

    public boolean isRegexBased() {
        return this.include != null || this.exclude != null;
    }

    private Automaton toAutomaton() {
        Automaton a = null;
        a = this.include != null ? this.include.toAutomaton() : (this.includeValues != null ? Automata.makeStringUnion(this.includeValues) : Automata.makeAnyString());
        if (this.exclude != null) {
            a = Operations.minus((Automaton)a, (Automaton)this.exclude.toAutomaton(), (int)10000);
        } else if (this.excludeValues != null) {
            a = Operations.minus((Automaton)a, (Automaton)Automata.makeStringUnion(this.excludeValues), (int)10000);
        }
        return a;
    }

    public StringFilter convertToStringFilter(DocValueFormat format) {
        if (this.isRegexBased()) {
            return new AutomatonBackedStringFilter(this.toAutomaton());
        }
        return new TermListBackedStringFilter(IncludeExclude.parseForDocValues(this.includeValues, format), IncludeExclude.parseForDocValues(this.excludeValues, format));
    }

    private static SortedSet<BytesRef> parseForDocValues(SortedSet<BytesRef> endUserFormattedValues, DocValueFormat format) {
        SortedSet<BytesRef> result = endUserFormattedValues;
        if (endUserFormattedValues != null && format != DocValueFormat.RAW) {
            result = new TreeSet<BytesRef>();
            for (BytesRef formattedVal : endUserFormattedValues) {
                result.add(format.parseBytesRef(formattedVal.utf8ToString()));
            }
        }
        return result;
    }

    public OrdinalsFilter convertToOrdinalsFilter(DocValueFormat format) {
        if (this.isRegexBased()) {
            return new AutomatonBackedOrdinalsFilter(this.toAutomaton());
        }
        return new TermListBackedOrdinalsFilter(IncludeExclude.parseForDocValues(this.includeValues, format), IncludeExclude.parseForDocValues(this.excludeValues, format));
    }

    public LongFilter convertToLongFilter(DocValueFormat format) {
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        LongFilter result = new LongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                result.addAccept(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                result.addReject(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        return result;
    }

    public LongFilter convertToDoubleFilter() {
        double dval;
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        LongFilter result = new LongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addAccept(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addReject(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        return result;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include != null) {
            builder.field(INCLUDE_FIELD.getPreferredName(), this.include.getOriginalString());
        }
        if (this.includeValues != null) {
            builder.startArray(INCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.includeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        }
        if (this.exclude != null) {
            builder.field(EXCLUDE_FIELD.getPreferredName(), this.exclude.getOriginalString());
        }
        if (this.excludeValues != null) {
            builder.startArray(EXCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.excludeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.include == null ? null : this.include.getOriginalString(), this.exclude == null ? null : this.exclude.getOriginalString(), this.includeValues, this.excludeValues);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeExclude other = (IncludeExclude)obj;
        return Objects.equals(this.include == null ? null : this.include.getOriginalString(), other.include == null ? null : other.include.getOriginalString()) && Objects.equals(this.exclude == null ? null : this.exclude.getOriginalString(), other.exclude == null ? null : other.exclude.getOriginalString()) && Objects.equals(this.includeValues, other.includeValues) && Objects.equals(this.excludeValues, other.excludeValues);
    }

    public static class Parser {
        public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser, ParseFieldMatcher parseFieldMatcher, Map<ParseField, Object> otherOptions) throws IOException {
            if (token == XContentParser.Token.VALUE_STRING) {
                if (parseFieldMatcher.match(currentFieldName, INCLUDE_FIELD)) {
                    otherOptions.put(INCLUDE_FIELD, parser.text());
                } else if (parseFieldMatcher.match(currentFieldName, EXCLUDE_FIELD)) {
                    otherOptions.put(EXCLUDE_FIELD, parser.text());
                } else {
                    return false;
                }
                return true;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (parseFieldMatcher.match(currentFieldName, INCLUDE_FIELD)) {
                    otherOptions.put(INCLUDE_FIELD, new TreeSet<BytesRef>(this.parseArrayToSet(parser)));
                    return true;
                }
                if (parseFieldMatcher.match(currentFieldName, EXCLUDE_FIELD)) {
                    otherOptions.put(EXCLUDE_FIELD, new TreeSet<BytesRef>(this.parseArrayToSet(parser)));
                    return true;
                }
                return false;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseFieldMatcher.match(currentFieldName, INCLUDE_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING || !parseFieldMatcher.match(currentFieldName, PATTERN_FIELD)) continue;
                        otherOptions.put(INCLUDE_FIELD, parser.text());
                    }
                } else if (parseFieldMatcher.match(currentFieldName, EXCLUDE_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING || !parseFieldMatcher.match(currentFieldName, PATTERN_FIELD)) continue;
                        otherOptions.put(EXCLUDE_FIELD, parser.text());
                    }
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }

        private Set<BytesRef> parseArrayToSet(XContentParser parser) throws IOException {
            HashSet<BytesRef> set = new HashSet<BytesRef>();
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("Missing start of array in include/exclude clause", new Object[0]);
            }
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (!parser.currentToken().isValue()) {
                    throw new ElasticsearchParseException("Array elements in include/exclude clauses should be string values", new Object[0]);
                }
                set.add(new BytesRef((CharSequence)parser.text()));
            }
            return set;
        }

        public IncludeExclude createIncludeExclude(Map<ParseField, Object> otherOptions) {
            RegExp excludePattern;
            Object includeObject = otherOptions.get(INCLUDE_FIELD);
            String include = null;
            SortedSet includeValues = null;
            if (includeObject != null) {
                if (includeObject instanceof String) {
                    include = (String)includeObject;
                } else if (includeObject instanceof SortedSet) {
                    includeValues = (SortedSet)includeObject;
                }
            }
            Object excludeObject = otherOptions.get(EXCLUDE_FIELD);
            String exclude = null;
            SortedSet excludeValues = null;
            if (excludeObject != null) {
                if (excludeObject instanceof String) {
                    exclude = (String)excludeObject;
                } else if (excludeObject instanceof SortedSet) {
                    excludeValues = (SortedSet)excludeObject;
                }
            }
            RegExp includePattern = include != null ? new RegExp(include) : null;
            RegExp regExp = excludePattern = exclude != null ? new RegExp(exclude) : null;
            if (includePattern != null || excludePattern != null) {
                if (includeValues != null || excludeValues != null) {
                    throw new IllegalArgumentException("Can only use regular expression include/exclude or a set of values, not both");
                }
                return new IncludeExclude(includePattern, excludePattern);
            }
            if (includeValues != null || excludeValues != null) {
                return new IncludeExclude(includeValues, excludeValues);
            }
            return null;
        }
    }

    private static class DocValuesTerms
    extends Terms {
        private final SortedSetDocValues values;

        DocValuesTerms(SortedSetDocValues values) {
            this.values = values;
        }

        public TermsEnum iterator() throws IOException {
            return this.values.termsEnum();
        }

        public long size() throws IOException {
            return -1L;
        }

        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        public long getSumDocFreq() throws IOException {
            return -1L;
        }

        public int getDocCount() throws IOException {
            return -1;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    }

    static class TermListBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final SortedSet<BytesRef> includeValues;
        private final SortedSet<BytesRef> excludeValues;

        public TermListBackedOrdinalsFilter(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
            this.includeValues = includeValues;
            this.excludeValues = excludeValues;
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(RandomAccessOrds globalOrdinals) throws IOException {
            long ord;
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            if (this.includeValues != null) {
                for (BytesRef term : this.includeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.set(ord);
                }
            } else if (acceptedGlobalOrdinals.length() > 0L) {
                acceptedGlobalOrdinals.set(0L, acceptedGlobalOrdinals.length());
            }
            if (this.excludeValues != null) {
                for (BytesRef term : this.excludeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.clear(ord);
                }
            }
            return acceptedGlobalOrdinals;
        }
    }

    static class AutomatonBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final CompiledAutomaton compiled;

        private AutomatonBackedOrdinalsFilter(Automaton automaton) {
            this.compiled = new CompiledAutomaton(automaton);
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(RandomAccessOrds globalOrdinals) throws IOException {
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            DocValuesTerms globalTerms = new DocValuesTerms((SortedSetDocValues)globalOrdinals);
            TermsEnum globalTermsEnum = this.compiled.getTermsEnum((Terms)globalTerms);
            BytesRef term = globalTermsEnum.next();
            while (term != null) {
                acceptedGlobalOrdinals.set(globalTermsEnum.ord());
                term = globalTermsEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    public static abstract class OrdinalsFilter {
        public abstract LongBitSet acceptedGlobalOrdinals(RandomAccessOrds var1) throws IOException;
    }

    static class TermListBackedStringFilter
    extends StringFilter {
        private final Set<BytesRef> valids;
        private final Set<BytesRef> invalids;

        public TermListBackedStringFilter(Set<BytesRef> includeValues, Set<BytesRef> excludeValues) {
            this.valids = includeValues;
            this.invalids = excludeValues;
        }

        @Override
        public boolean accept(BytesRef value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }
    }

    static class AutomatonBackedStringFilter
    extends StringFilter {
        private final ByteRunAutomaton runAutomaton;

        private AutomatonBackedStringFilter(Automaton automaton) {
            this.runAutomaton = new ByteRunAutomaton(automaton);
        }

        @Override
        public boolean accept(BytesRef value) {
            return this.runAutomaton.run(value.bytes, value.offset, value.length);
        }
    }

    public static abstract class StringFilter {
        public abstract boolean accept(BytesRef var1);
    }

    public static class LongFilter {
        private LongSet valids;
        private LongSet invalids;

        private LongFilter(int numValids, int numInvalids) {
            if (numValids > 0) {
                this.valids = new LongHashSet(numValids);
            }
            if (numInvalids > 0) {
                this.invalids = new LongHashSet(numInvalids);
            }
        }

        public boolean accept(long value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }

        private void addAccept(long val) {
            this.valids.add(val);
        }

        private void addReject(long val) {
            this.invalids.add(val);
        }
    }
}

