/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class FieldHighlighter {
    protected final String field;
    protected final FieldOffsetStrategy fieldOffsetStrategy;
    protected final BreakIterator breakIterator;
    protected final PassageScorer passageScorer;
    protected final int maxPassages;
    protected final int maxNoHighlightPassages;
    protected final PassageFormatter passageFormatter;
    protected static final PostingsEnum EMPTY = new PostingsEnum(){

        public int nextPosition() throws IOException {
            return 0;
        }

        public int startOffset() throws IOException {
            return Integer.MAX_VALUE;
        }

        public int endOffset() throws IOException {
            return Integer.MAX_VALUE;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }

        public int freq() throws IOException {
            return 0;
        }

        public int docID() {
            return Integer.MAX_VALUE;
        }

        public int nextDoc() throws IOException {
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return Integer.MAX_VALUE;
        }

        public long cost() {
            return 0L;
        }
    };

    public FieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter) {
        this.field = field;
        this.fieldOffsetStrategy = fieldOffsetStrategy;
        this.breakIterator = breakIterator;
        this.passageScorer = passageScorer;
        this.maxPassages = maxPassages;
        this.maxNoHighlightPassages = maxNoHighlightPassages;
        this.passageFormatter = passageFormatter;
    }

    public String getField() {
        return this.field;
    }

    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return this.fieldOffsetStrategy.getOffsetSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object highlightFieldForDoc(IndexReader reader, int docId, String content) throws IOException {
        Passage[] passages;
        if (content.length() == 0) {
            return null;
        }
        this.breakIterator.setText(content);
        List<OffsetsEnum> offsetsEnums = this.fieldOffsetStrategy.getOffsetsEnums(reader, docId, content);
        try {
            passages = this.highlightOffsetsEnums(offsetsEnums);
        }
        finally {
            IOUtils.close(offsetsEnums);
        }
        if (passages.length == 0) {
            passages = this.getSummaryPassagesNoHighlight(this.maxNoHighlightPassages == -1 ? this.maxPassages : this.maxNoHighlightPassages);
        }
        if (passages.length > 0) {
            return this.passageFormatter.format(passages, content);
        }
        return null;
    }

    protected Passage[] getSummaryPassagesNoHighlight(int maxPassages) {
        int next;
        assert (this.breakIterator.current() == this.breakIterator.first());
        ArrayList<Passage> passages = new ArrayList<Passage>(Math.min(maxPassages, 10));
        int pos = this.breakIterator.current();
        assert (pos == 0);
        while (passages.size() < maxPassages && (next = this.breakIterator.next()) != -1) {
            Passage passage = new Passage();
            passage.score = Float.NaN;
            passage.startOffset = pos;
            passage.endOffset = next;
            passages.add(passage);
            pos = next;
        }
        return passages.toArray(new Passage[passages.size()]);
    }

    protected Passage[] highlightOffsetsEnums(List<OffsetsEnum> offsetsEnums) throws IOException {
        Passage[] passages;
        OffsetsEnum off;
        PassageScorer scorer = this.passageScorer;
        BreakIterator breakIterator = this.breakIterator;
        int contentLength = breakIterator.getText().getEndIndex();
        PriorityQueue<OffsetsEnum> offsetsEnumQueue = new PriorityQueue<OffsetsEnum>(offsetsEnums.size() + 1);
        for (OffsetsEnum off2 : offsetsEnums) {
            off2.weight = scorer.weight(contentLength, off2.postingsEnum.freq());
            off2.nextPosition();
            offsetsEnumQueue.add(off2);
        }
        offsetsEnumQueue.add(new OffsetsEnum(null, EMPTY));
        PriorityQueue<Passage> passageQueue = new PriorityQueue<Passage>(Math.min(64, this.maxPassages + 1), (left, right) -> {
            if (left.score < right.score) {
                return -1;
            }
            if (left.score > right.score) {
                return 1;
            }
            return left.startOffset - right.startOffset;
        });
        Passage passage = new Passage();
        while ((off = (OffsetsEnum)offsetsEnumQueue.poll()) != null) {
            int tf;
            block13: {
                int start = off.startOffset();
                if (start == -1) {
                    throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
                }
                int end = off.endOffset();
                assert (EMPTY.startOffset() == Integer.MAX_VALUE);
                if (start < contentLength && end > contentLength) continue;
                if (start >= passage.endOffset) {
                    if (passage.startOffset >= 0) {
                        passage.score *= scorer.norm(passage.startOffset);
                        if (passageQueue.size() == this.maxPassages && passage.score < ((Passage)passageQueue.peek()).score) {
                            passage.reset();
                        } else {
                            passageQueue.offer(passage);
                            if (passageQueue.size() > this.maxPassages) {
                                passage = (Passage)passageQueue.poll();
                                passage.reset();
                            } else {
                                passage = new Passage();
                            }
                        }
                    }
                    if (start >= contentLength) break;
                    passage.startOffset = Math.max(breakIterator.preceding(start + 1), 0);
                    passage.endOffset = Math.min(breakIterator.following(start), contentLength);
                }
                tf = 0;
                do {
                    ++tf;
                    BytesRef term = off.getTerm();
                    assert (term != null);
                    passage.addMatch(start, end, term);
                    if (!off.hasMorePositions()) break block13;
                    off.nextPosition();
                    start = off.startOffset();
                    end = off.endOffset();
                } while (start < passage.endOffset && end <= contentLength);
                offsetsEnumQueue.offer(off);
            }
            passage.score += off.weight * scorer.tf(tf, passage.endOffset - passage.startOffset);
        }
        for (Passage p : passages = passageQueue.toArray(new Passage[passageQueue.size()])) {
            p.sort();
        }
        Arrays.sort(passages, (left, right) -> left.startOffset - right.startOffset);
        return passages;
    }
}

