/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PutPipelineRequest
extends AcknowledgedRequest<PutPipelineRequest> {
    private String id;
    private BytesReference source;

    public PutPipelineRequest(String id, BytesReference source) {
        if (id == null) {
            throw new IllegalArgumentException("id is missing");
        }
        if (source == null) {
            throw new IllegalArgumentException("source is missing");
        }
        this.id = id;
        this.source = source;
    }

    PutPipelineRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
    }
}

