/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class ShardsLimitAllocationDecider
extends AllocationDecider {
    public static final String NAME = "shards_limit";
    private volatile int clusterShardLimit;
    public static final Setting<Integer> INDEX_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting("index.routing.allocation.total_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting("cluster.routing.allocation.total_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public ShardsLimitAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.clusterShardLimit = CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING, this::setClusterShardLimit);
    }

    private void setClusterShardLimit(int clusterShardLimit) {
        this.clusterShardLimit = clusterShardLimit;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd = allocation.metaData().getIndexSafe(shardRouting.index());
        int indexShardLimit = INDEX_TOTAL_SHARDS_PER_NODE_SETTING.get(indexMd.getSettings(), this.settings);
        int clusterShardLimit = this.clusterShardLimit;
        if (indexShardLimit <= 0 && clusterShardLimit <= 0) {
            return allocation.decision(Decision.YES, NAME, "total shard limits are disabled: [index: %d, cluster: %d] <= 0", indexShardLimit, clusterShardLimit);
        }
        int indexShardCount = 0;
        int nodeShardCount = 0;
        for (ShardRouting nodeShard : node) {
            if (nodeShard.relocating()) continue;
            ++nodeShardCount;
            if (!nodeShard.index().equals(shardRouting.index())) continue;
            ++indexShardCount;
        }
        if (clusterShardLimit > 0 && nodeShardCount >= clusterShardLimit) {
            return allocation.decision(Decision.NO, NAME, "too many shards for this node [%d], cluster-level limit per node: [%d]", nodeShardCount, clusterShardLimit);
        }
        if (indexShardLimit > 0 && indexShardCount >= indexShardLimit) {
            return allocation.decision(Decision.NO, NAME, "too many shards for this index [%s] on node [%d], index-level limit per node: [%d]", shardRouting.index(), indexShardCount, indexShardLimit);
        }
        return allocation.decision(Decision.YES, NAME, "the shard count is under index limit [%d] and cluster level node limit [%d] of total shards per node", indexShardLimit, clusterShardLimit);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd = allocation.metaData().getIndexSafe(shardRouting.index());
        int indexShardLimit = INDEX_TOTAL_SHARDS_PER_NODE_SETTING.get(indexMd.getSettings(), this.settings);
        int clusterShardLimit = this.clusterShardLimit;
        if (indexShardLimit <= 0 && clusterShardLimit <= 0) {
            return allocation.decision(Decision.YES, NAME, "total shard limits are disabled: [index: %d, cluster: %d] <= 0", indexShardLimit, clusterShardLimit);
        }
        int indexShardCount = 0;
        int nodeShardCount = 0;
        for (ShardRouting nodeShard : node) {
            if (nodeShard.relocating()) continue;
            ++nodeShardCount;
            if (!nodeShard.index().equals(shardRouting.index())) continue;
            ++indexShardCount;
        }
        if (clusterShardLimit > 0 && nodeShardCount > clusterShardLimit) {
            return allocation.decision(Decision.NO, NAME, "too many shards for this node [%d], cluster-level limit per node: [%d]", nodeShardCount, clusterShardLimit);
        }
        if (indexShardLimit > 0 && indexShardCount > indexShardLimit) {
            return allocation.decision(Decision.NO, NAME, "too many shards for this index [%s] on node [%d], index-level limit per node: [%d]", shardRouting.index(), indexShardCount, indexShardLimit);
        }
        return allocation.decision(Decision.YES, NAME, "the shard count is under index limit [%d] and cluster level node limit [%d] of total shards per node", indexShardLimit, clusterShardLimit);
    }

    @Override
    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        int clusterShardLimit = this.clusterShardLimit;
        if (clusterShardLimit <= 0) {
            return allocation.decision(Decision.YES, NAME, "total shard limits are disabled: [cluster: %d] <= 0", clusterShardLimit);
        }
        int nodeShardCount = 0;
        for (ShardRouting nodeShard : node) {
            if (nodeShard.relocating()) continue;
            ++nodeShardCount;
        }
        if (clusterShardLimit >= 0 && nodeShardCount >= clusterShardLimit) {
            return allocation.decision(Decision.NO, NAME, "too many shards for this node [%d], cluster-level limit per node: [%d]", nodeShardCount, clusterShardLimit);
        }
        return allocation.decision(Decision.YES, NAME, "the shard count is under node limit [%d] of total shards per node", clusterShardLimit);
    }
}

