/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.ip;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.ip.IpRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class IpRangeParser
extends AbstractValuesSourceParser.BytesValuesSourceParser {
    private static final ParseField MASK_FIELD = new ParseField("mask", new String[0]);

    public IpRangeParser() {
        super(false, false);
    }

    @Override
    protected ValuesSourceAggregationBuilder<ValuesSource.Bytes, ?> createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        IpRangeAggregationBuilder range = new IpRangeAggregationBuilder(aggregationName);
        Iterable ranges = (Iterable)otherOptions.get(RangeAggregator.RANGES_FIELD);
        if (otherOptions.containsKey(RangeAggregator.RANGES_FIELD)) {
            for (IpRangeAggregationBuilder.Range r : ranges) {
                range.addRange(r);
            }
        }
        if (otherOptions.containsKey(RangeAggregator.KEYED_FIELD)) {
            range.keyed((Boolean)otherOptions.get(RangeAggregator.KEYED_FIELD));
        }
        return range;
    }

    private IpRangeAggregationBuilder.Range parseRange(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        String key = null;
        String from = null;
        String to = null;
        String mask = null;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[ranges] must contain objects, but hit a " + (Object)((Object)parser.currentToken()), new Object[0]);
        }
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) continue;
            if (parseFieldMatcher.match(parser.currentName(), RangeAggregator.Range.KEY_FIELD)) {
                key = parser.text();
                continue;
            }
            if (parseFieldMatcher.match(parser.currentName(), RangeAggregator.Range.FROM_FIELD)) {
                from = parser.textOrNull();
                continue;
            }
            if (parseFieldMatcher.match(parser.currentName(), RangeAggregator.Range.TO_FIELD)) {
                to = parser.textOrNull();
                continue;
            }
            if (parseFieldMatcher.match(parser.currentName(), MASK_FIELD)) {
                mask = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected ip range parameter: [" + parser.currentName() + "]", new Object[0]);
        }
        if (mask != null) {
            if (key == null) {
                key = mask;
            }
            return new IpRangeAggregationBuilder.Range(key, mask);
        }
        return new IpRangeAggregationBuilder.Range(key, from, to);
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (context.matchField(currentFieldName, RangeAggregator.RANGES_FIELD)) {
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new ParsingException(parser.getTokenLocation(), "[ranges] must be passed as an array, but got a " + (Object)((Object)token), new Object[0]);
            }
            ArrayList<IpRangeAggregationBuilder.Range> ranges = new ArrayList<IpRangeAggregationBuilder.Range>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                IpRangeAggregationBuilder.Range range = this.parseRange(parser, context.getParseFieldMatcher());
                ranges.add(range);
            }
            otherOptions.put(RangeAggregator.RANGES_FIELD, ranges);
            return true;
        }
        if (context.matchField(parser.currentName(), RangeAggregator.KEYED_FIELD)) {
            otherOptions.put(RangeAggregator.KEYED_FIELD, parser.booleanValue());
            return true;
        }
        return false;
    }
}

