/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Contact;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.data.Tuple;
import esmska.transfer.GatewayExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class SMS {
    private static final Logger logger = Logger.getLogger(SMS.class.getName());
    private String number;
    private String name;
    private String text;
    private ImageIcon image;
    private String imageCode = "";
    private String imageHint;
    private String gateway;
    private Status status = Status.NEW;
    private String supplMsg = "";
    private Tuple<GatewayExecutor.Problem, String> problem;
    private String id;

    public SMS(String number, String text, String gateway) {
        this(number, text, gateway, null, null);
    }

    public SMS(String number, String text, String gateway, String name, String id) {
        this.setNumber(number);
        this.setText(text);
        this.setGateway(gateway);
        this.setName(name);
        this.setId(id);
    }

    public static String generateID() {
        String newId = Long.toString(System.currentTimeMillis());
        newId = newId + "#" + RandomStringUtils.randomAlphanumeric(4);
        return newId;
    }

    private Signature getSignature() {
        Gateway gw = Gateways.getInstance().get(this.gateway);
        if (gw == null) {
            return null;
        }
        String sigName = gw.getConfig().getSignature();
        Signature signature = Signatures.getInstance().get(sigName);
        return signature;
    }

    public boolean isProblematic() {
        return this.problem != null;
    }

    public String getRecipient() {
        return StringUtils.defaultIfEmpty(this.name, this.number);
    }

    public String getNumber() {
        return this.number;
    }

    public String getText() {
        return this.text;
    }

    public String getSenderNumber() {
        return this.getSignature() == null ? "" : this.getSignature().getUserNumber();
    }

    public String getSenderName() {
        return this.getSignature() == null ? "" : this.getSignature().getUserName();
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public String getImageCode() {
        return this.imageCode;
    }

    public String getImageHint() {
        return this.imageHint;
    }

    public String getGateway() {
        return this.gateway;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getSupplMsg() {
        return this.supplMsg;
    }

    public Tuple<GatewayExecutor.Problem, String> getProblem() {
        return this.problem;
    }

    public void setNumber(String number) {
        Validate.notEmpty(number);
        if (!number.startsWith("+")) {
            throw new IllegalArgumentException("Number does not start with '+': " + number);
        }
        this.number = number;
    }

    public void setText(String text) {
        Validate.notNull(text);
        this.text = text;
    }

    public void setImage(ImageIcon image) {
        this.image = image;
    }

    public void setImageCode(String imageCode) {
        this.imageCode = StringUtils.defaultString(imageCode);
    }

    public void setImageHint(String imageHint) {
        this.imageHint = imageHint;
    }

    public void setGateway(String gateway) {
        Validate.notEmpty(gateway);
        this.gateway = gateway;
    }

    void setStatus(Status status) {
        Validate.notNull((Object)status);
        if (this.status != status) {
            logger.log(Level.FINER, "SMS {0} has a new status: {1}", new Object[]{this, status});
        }
        this.status = status;
    }

    public void setName(String name) {
        this.name = StringUtils.defaultString(name);
    }

    public void setSupplMsg(String supplMsg) {
        if (!StringUtils.equals(supplMsg = StringUtils.defaultString(supplMsg), this.supplMsg)) {
            logger.log(Level.FINER, "SMS {0} has a new supplemental message: {1}", new Object[]{this, supplMsg});
        }
        this.supplMsg = supplMsg;
    }

    public void setProblem(Tuple<GatewayExecutor.Problem, String> problem) {
        if (!ObjectUtils.equals(problem, this.problem) && problem != null) {
            logger.log(Level.FINER, "SMS {0} has a new problem: {1}", new Object[]{this, problem});
        }
        this.problem = problem;
    }

    public void setId(String id) {
        this.id = StringUtils.isEmpty(id) ? SMS.generateID() : id;
    }

    public String toString() {
        return "[recipient=" + StringUtils.defaultIfEmpty(this.name, Contact.anonymizeNumber(this.number)) + ", gateway=" + this.gateway + "]";
    }

    public String toDebugString() {
        return "[name=" + this.name + ", number=" + Contact.anonymizeNumber(this.number) + ", gateway=" + this.gateway + ", status=" + (Object)((Object)this.status) + ", supplMsg=" + this.supplMsg + ", problem=" + this.problem + "]";
    }

    public static enum Status {
        NEW,
        WAITING,
        READY,
        SENDING,
        SENT;

    }
}

