// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepFeat_SplitShape_HeaderFile
#define _BRepFeat_SplitShape_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <LocOpe_Spliter.hxx>
#include <Handle_LocOpe_WiresOnShape.hxx>
#include <BRepBuilderAPI_MakeShape.hxx>
#include <Standard_Boolean.hxx>
class LocOpe_WiresOnShape;
class StdFail_NotDone;
class Standard_ConstructionError;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopoDS_Wire;
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Compound;
class TopTools_ListOfShape;


//! One of the most significant aspects of BRepFeat functionality is the use of local
//! operations as opposed to global ones. In a global operation, you would first construct a
//! form of the type you wanted in your final feature, and then remove matter so that it could
//! fit into your initial basis object. In a local operation, however, you specify the domain of
//! the feature construction with aspects of the shape on which the feature is being created.
//! These semantics are expressed in terms of a member shape of the basis shape from which -
//! or up to which - matter will be added or removed. As a result, local operations make
//! calculations simpler and faster than global operations.
//! In BRepFeat, the semantics of local operations define features constructed from a contour or a
//! part of the basis shape referred to as the tool. In a SplitShape object, wires or edges of a
//! face in the basis shape to be used as a part of the feature are cut out and projected to a plane
//! outside or inside the basis shape. By rebuilding the initial shape incorporating the edges and
//! the faces of the tool, protrusion or depression features can be constructed.
class BRepFeat_SplitShape  : public BRepBuilderAPI_MakeShape
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Empty constructor
    BRepFeat_SplitShape();
  
  //! Creates the process  with the shape <S>.
    BRepFeat_SplitShape(const TopoDS_Shape& S);
  
  //! Initializes the process on the shape <S>.
      void Init (const TopoDS_Shape& S) ;
  
  //! Set the flag of check internal intersections
  //! default value is True (to check)
      void SetCheckInterior (const Standard_Boolean ToCheckInterior) ;
  
  //! Adds the wire <W> on the face <F>.
  //! Raises NoSuchObject  if <F> does not belong to the original shape.
      void Add (const TopoDS_Wire& W, const TopoDS_Face& F) ;
  
  //! Adds the edge <E> on the face <F>.
      void Add (const TopoDS_Edge& E, const TopoDS_Face& F) ;
  
  //! Adds the compound <Comp> on the face <F>. The
  //! compound <Comp> must consist of edges lying on the
  //! face <F>. If edges are geometrically connected,
  //! they must be connected topologically, i.e. they
  //! must share common vertices.
  //!
  //! Raises NoSuchObject  if <F> does not belong to the original shape.
      void Add (const TopoDS_Compound& Comp, const TopoDS_Face& F) ;
  
  //! Adds the edge <E> on the existing edge <EOn>.
      void Add (const TopoDS_Edge& E, const TopoDS_Edge& EOn) ;
  
  //! Returns  the faces   which  are the  left of   the
  //! projected wires.
  Standard_EXPORT  const  TopTools_ListOfShape& DirectLeft()  const;
  
  //! Returns the faces of the "left" part on the shape.
  //! (It  is build   from  DirectLeft,  with  the faces
  //! connected to this set, and so on...).
  //! Raises NotDone if IsDone returns <Standard_False>.
  Standard_EXPORT  const  TopTools_ListOfShape& Left()  const;
  
  //! Builds the cut and the resulting faces and edges as well.
  Standard_EXPORT   void Build() ;
  
  //! Returns true if the shape has been deleted.
  Standard_EXPORT virtual   Standard_Boolean IsDeleted (const TopoDS_Shape& S) ;
  
  //! Returns the list of generated Faces.
  Standard_EXPORT  const  TopTools_ListOfShape& Modified (const TopoDS_Shape& F) ;




protected:





private:



  LocOpe_Spliter mySShape;
  Handle(LocOpe_WiresOnShape) myWOnShape;


};


#include <BRepFeat_SplitShape.lxx>





#endif // _BRepFeat_SplitShape_HeaderFile
