/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.launcher.daemon.server.health.memory.AvailableMemory;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandleBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmstatAvailableMemory
implements AvailableMemory {
    private static final Pattern VMSTAT_LINE_PATTERN = Pattern.compile("^\\D+(\\d+)\\D+$");
    private static final String VMSTAT_EXECUTABLE_PATH = "/usr/bin/vm_stat";
    private final Matcher vmstatMatcher = VMSTAT_LINE_PATTERN.matcher("");

    @Override
    public long get() throws UnsupportedOperationException {
        long freeMemoryFromVmstat = this.parseFreeMemoryFromVmstat(this.getVmstatOutput());
        if (freeMemoryFromVmstat == -1L) {
            throw new UnsupportedOperationException("Unable to get free memory from /usr/bin/vm_stat");
        }
        return freeMemoryFromVmstat;
    }

    private List<String> getVmstatOutput() {
        try {
            String line;
            StreamByteBuffer buffer = new StreamByteBuffer();
            ExecHandleBuilder builder = new DefaultExecActionFactory(new IdentityFileResolver()).newExec();
            builder.setWorkingDir((Object)new File(".").getAbsolutePath());
            builder.setCommandLine(new Object[]{VMSTAT_EXECUTABLE_PATH});
            builder.setStandardOutput(buffer.getOutputStream());
            builder.build().start().waitForFinish().assertNormalExitValue();
            BufferedReader reader = new BufferedReader(new InputStreamReader(buffer.getInputStream()));
            ArrayList lines = Lists.newArrayList();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unable to read memory info from /usr/bin/vm_stat", e);
        }
    }

    @VisibleForTesting
    long parseFreeMemoryFromVmstat(List<String> vmstatLines) {
        VmstatOutput vmstatOutput = new VmstatOutput();
        if (!vmstatLines.isEmpty()) {
            long pageSize = this.parseVmstatBytes(vmstatLines.get(0));
            for (String line : vmstatLines) {
                if (line.startsWith("Pages free")) {
                    vmstatOutput.setFreeBytes(this.parseVmstatBytes(line) * pageSize);
                    continue;
                }
                if (!line.startsWith("File-backed pages")) continue;
                vmstatOutput.setReclaimableBytes(this.parseVmstatBytes(line) * pageSize);
            }
        }
        return vmstatOutput.getAvailableBytes();
    }

    private long parseVmstatBytes(String line) {
        Matcher matcher = this.vmstatMatcher.reset(line);
        if (matcher.matches()) {
            return Long.parseLong(matcher.group(1));
        }
        throw new UnsupportedOperationException("Unable to parse vm_stat output to get available memory");
    }

    private class VmstatOutput {
        private long freeBytes = -1L;
        private long reclaimableBytes = -1L;

        private VmstatOutput() {
        }

        void setFreeBytes(long freeBytes) {
            this.freeBytes = freeBytes;
        }

        void setReclaimableBytes(long reclaimableBytes) {
            this.reclaimableBytes = reclaimableBytes;
        }

        long getAvailableBytes() {
            if (this.freeBytes != -1L && this.reclaimableBytes != -1L) {
                return this.freeBytes + this.reclaimableBytes;
            }
            return -1L;
        }
    }
}

