/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.OrderInsensitiveTaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.OrderSensitiveTaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheKeyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskFilePropertyCompareStrategy {
    ORDERED(new OrderSensitiveTaskFilePropertyCompareStrategy()),
    UNORDERED(new OrderInsensitiveTaskFilePropertyCompareStrategy(true)),
    OUTPUT(new OrderInsensitiveTaskFilePropertyCompareStrategy(false));

    private final Impl delegate;

    private TaskFilePropertyCompareStrategy(Impl delegate) {
        this.delegate = delegate;
    }

    public Iterator<TaskStateChange> iterateContentChangesSince(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String fileType, boolean pathIsAbsolute) {
        Iterator<TaskStateChange> trivialResult = TaskFilePropertyCompareStrategy.compareTrivialSnapshots(current, previous, fileType, this.delegate.isIncludeAdded());
        if (trivialResult != null) {
            return trivialResult;
        }
        return this.delegate.iterateContentChangesSince(current, previous, fileType, pathIsAbsolute);
    }

    public void appendToCacheKey(BuildCacheKeyBuilder builder, Map<String, NormalizedFileSnapshot> snapshots) {
        this.delegate.appendToCacheKey(builder, snapshots);
    }

    @VisibleForTesting
    static Iterator<TaskStateChange> compareTrivialSnapshots(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String fileType, boolean includeAdded) {
        switch (current.size()) {
            case 0: {
                switch (previous.size()) {
                    case 0: {
                        return Iterators.emptyIterator();
                    }
                    case 1: {
                        String path = previous.keySet().iterator().next();
                        FileChange change = new FileChange(path, ChangeType.REMOVED, fileType);
                        return Iterators.singletonIterator((Object)change);
                    }
                }
                return null;
            }
            case 1: {
                switch (previous.size()) {
                    case 0: {
                        if (includeAdded) {
                            String path = current.keySet().iterator().next();
                            FileChange change = new FileChange(path, ChangeType.ADDED, fileType);
                            return Iterators.singletonIterator((Object)change);
                        }
                        return Iterators.emptyIterator();
                    }
                    case 1: {
                        Map.Entry<String, NormalizedFileSnapshot> previousEntry = previous.entrySet().iterator().next();
                        Map.Entry<String, NormalizedFileSnapshot> currentEntry = current.entrySet().iterator().next();
                        return TaskFilePropertyCompareStrategy.compareTrivialSnapshotEntries(currentEntry, previousEntry, fileType, includeAdded);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static Iterator<TaskStateChange> compareTrivialSnapshotEntries(Map.Entry<String, NormalizedFileSnapshot> currentEntry, Map.Entry<String, NormalizedFileSnapshot> previousEntry, String fileType, boolean includeAdded) {
        NormalizedFileSnapshot normalizedPrevious = previousEntry.getValue();
        NormalizedFileSnapshot normalizedCurrent = currentEntry.getValue();
        if (normalizedCurrent.getNormalizedPath().equals(normalizedPrevious.getNormalizedPath())) {
            IncrementalFileSnapshot previousSnapshot = normalizedPrevious.getSnapshot();
            IncrementalFileSnapshot currentSnapshot = normalizedCurrent.getSnapshot();
            if (!currentSnapshot.isContentUpToDate(previousSnapshot)) {
                String path = currentEntry.getKey();
                FileChange change = new FileChange(path, ChangeType.MODIFIED, fileType);
                return Iterators.singletonIterator((Object)change);
            }
            return Iterators.emptyIterator();
        }
        if (includeAdded) {
            String previousPath = previousEntry.getKey();
            String currentPath = currentEntry.getKey();
            FileChange remove = new FileChange(previousPath, ChangeType.REMOVED, fileType);
            FileChange add = new FileChange(currentPath, ChangeType.ADDED, fileType);
            return Iterators.forArray((Object[])new TaskStateChange[]{remove, add});
        }
        String path = previousEntry.getKey();
        FileChange change = new FileChange(path, ChangeType.REMOVED, fileType);
        return Iterators.singletonIterator((Object)change);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Impl {
        public Iterator<TaskStateChange> iterateContentChangesSince(Map<String, NormalizedFileSnapshot> var1, Map<String, NormalizedFileSnapshot> var2, String var3, boolean var4);

        public void appendToCacheKey(BuildCacheKeyBuilder var1, Map<String, NormalizedFileSnapshot> var2);

        public boolean isIncludeAdded();
    }
}

