/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EdtInvocationManager {
    @NotNull
    private static volatile EdtInvocationManager ourInstance = new SwingEdtInvocationManager();

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager edtInvocationManager = ourInstance;
        if (edtInvocationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager", "getInstance"));
        }
        return edtInvocationManager;
    }

    private static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        private SwingEdtInvocationManager() {
        }

        @Override
        public boolean isEventDispatchThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager", "invokeLater"));
            }
            SwingUtilities.invokeLater(task);
        }
    }
}

