/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "debugName", "(Ljava/util/Map;Ljava/lang/String;)V", "getPackageFqName2Parts", "()Ljava/util/Map;", "findPackageParts", "packageFqName", "toString", "Companion", "kotlin-compiler"})
public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), "EMPTY");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "MAPPING_FILE_EXT", "", "create", "proto", "", "debugName", "kotlin-compiler"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] proto, @Nullable String debugName) {
            JvmPackageTable.PackageTable parseFrom;
            int[] nArray;
            void size$iv;
            JvmMetadataVersion jvmMetadataVersion;
            if (proto == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(proto));
            int n = stream2.readInt();
            JvmMetadataVersion jvmMetadataVersion2 = jvmMetadataVersion;
            JvmMetadataVersion jvmMetadataVersion3 = jvmMetadataVersion;
            int[] result$iv = new int[size$iv];
            boolean bl = false;
            void var9_11 = size$iv - true;
            if (bl <= var9_11) {
                void i$iv;
                do {
                    int n2;
                    void var10_13 = ++i$iv;
                    void var11_15 = i$iv;
                    nArray = result$iv;
                    nArray[var11_15] = n2 = stream2.readInt();
                } while (i$iv != var9_11);
            }
            nArray = result$iv;
            jvmMetadataVersion2(Arrays.copyOf(nArray, nArray.length));
            JvmMetadataVersion version = jvmMetadataVersion3;
            if (version.isCompatible() && (parseFrom = JvmPackageTable.PackageTable.parseFrom(stream2)) != null) {
                void $receiver$iv;
                HashMap<String, PackageParts> packageFqNameParts = MapsKt.hashMapOf(new Pair[0]);
                Iterable i$iv = parseFrom.getPackagePartsList();
                for (Object element$iv : $receiver$iv) {
                    void $receiver$iv2;
                    JvmPackageTable.PackageParts it = (JvmPackageTable.PackageParts)element$iv;
                    String string = it.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "it.packageFqName");
                    PackageParts packageParts = new PackageParts(string);
                    packageFqNameParts.put(it.getPackageFqName(), packageParts);
                    Iterable iterable = it.getClassNameList();
                    for (Object element$iv2 : $receiver$iv2) {
                        String it2 = (String)element$iv2;
                        packageParts.getParts().add(it2);
                    }
                }
                Map map2 = packageFqNameParts;
                String string = debugName;
                if (string == null) {
                    string = "<unknown>";
                }
                return new ModuleMapping(map2, string, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

