/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.Stash;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassFilesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;

public class ClassSetAnalysisUpdater {
    private static final Logger LOG = Logging.getLogger(ClassSetAnalysisUpdater.class);
    private final Stash<ClassSetAnalysisData> stash;
    private final FileOperations fileOperations;
    private ClassDependenciesAnalyzer analyzer;

    public ClassSetAnalysisUpdater(Stash<ClassSetAnalysisData> stash, FileOperations fileOperations, ClassDependenciesAnalyzer analyzer) {
        this.stash = stash;
        this.fileOperations = fileOperations;
        this.analyzer = analyzer;
    }

    public void updateAnalysis(JavaCompileSpec spec) {
        Timer clock = Timers.startTimer();
        ConfigurableFileTree tree = this.fileOperations.fileTree((Object)spec.getDestinationDir());
        ClassFilesAnalyzer analyzer = new ClassFilesAnalyzer(this.analyzer);
        tree.visit((FileVisitor)analyzer);
        ClassSetAnalysisData data = analyzer.getAnalysis();
        this.stash.put((Object)data);
        LOG.info("Class dependency analysis for incremental compilation took {}.", (Object)clock.getElapsed());
    }
}

