/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatGuards;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.convert.ToIntegerNode;

@GeneratedBy(value=ToIntegerNode.class)
public final class ToIntegerNodeGen
extends ToIntegerNode
implements SpecializedNode {
    @Node.Child
    private FormatNode value_;
    @Node.Child
    private BaseNode_ specialization_;

    private ToIntegerNodeGen(RubyContext context, FormatNode value) {
        super(context);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeToInteger(VirtualFrame frameValue, Object valueValue) {
        return this.specialization_.execute1(frameValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ToIntegerNode create(RubyContext context, FormatNode value) {
        return new ToIntegerNodeGen(context, value);
    }

    @GeneratedBy(methodName="toInteger(VirtualFrame, Object)", value=ToIntegerNode.class)
    private static final class ToInteger4Node_
    extends BaseNode_ {
        ToInteger4Node_(ToIntegerNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            if (!(FormatGuards.isInteger(valueValue) || FormatGuards.isLong(valueValue) || FormatGuards.isRubyBignum(valueValue))) {
                return this.root.toInteger(frameValue, valueValue);
            }
            return this.getNext().execute1(frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new ToInteger4Node_(root);
        }
    }

    @GeneratedBy(methodName="toInteger(double)", value=ToIntegerNode.class)
    private static final class ToInteger3Node_
    extends BaseNode_ {
        ToInteger3Node_(ToIntegerNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Double) {
                double valueValue_ = (Double)valueValue;
                return this.root.toInteger(valueValue_);
            }
            return this.getNext().execute1(frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new ToInteger3Node_(root);
        }
    }

    @GeneratedBy(methodName="toInteger(DynamicObject)", value=ToIntegerNode.class)
    private static final class ToInteger2Node_
    extends BaseNode_ {
        ToInteger2Node_(ToIntegerNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && FormatGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.toInteger(valueValue_);
            }
            return this.getNext().execute1(frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new ToInteger2Node_(root);
        }
    }

    @GeneratedBy(methodName="toInteger(long)", value=ToIntegerNode.class)
    private static final class ToInteger1Node_
    extends BaseNode_ {
        ToInteger1Node_(ToIntegerNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Long) {
                long valueValue_ = (Long)valueValue;
                return this.root.toInteger(valueValue_);
            }
            return this.getNext().execute1(frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new ToInteger1Node_(root);
        }
    }

    @GeneratedBy(methodName="toInteger(int)", value=ToIntegerNode.class)
    private static final class ToInteger0Node_
    extends BaseNode_ {
        ToInteger0Node_(ToIntegerNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                return this.root.toInteger(valueValue_);
            }
            return this.getNext().execute1(frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new ToInteger0Node_(root);
        }
    }

    @GeneratedBy(value=ToIntegerNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ToIntegerNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().execute1(frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ToIntegerNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ToIntegerNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object valueValue) {
            return this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(ToIntegerNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ToIntegerNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ToIntegerNodeGen root;

        BaseNode_(ToIntegerNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ToIntegerNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.execute1((VirtualFrame)frameValue, valueValue);
        }

        public abstract Object execute1(VirtualFrame var1, Object var2);

        public Object execute0(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.execute1(frameValue, valueValue_);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof Integer) {
                return ToInteger0Node_.create(this.root);
            }
            if (valueValue instanceof Long) {
                return ToInteger1Node_.create(this.root);
            }
            if (valueValue instanceof DynamicObject && FormatGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return ToInteger2Node_.create(this.root);
            }
            if (valueValue instanceof Double) {
                return ToInteger3Node_.create(this.root);
            }
            if (!(FormatGuards.isInteger(valueValue) || FormatGuards.isLong(valueValue) || FormatGuards.isRubyBignum(valueValue))) {
                return ToInteger4Node_.create(this.root);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

