/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChild(value="array", type=RubyNode.class)
public abstract class ArrayToObjectArrayNode
extends RubyNode {
    public Object[] unsplat(Object[] arguments) {
        assert (arguments.length == 1);
        assert (RubyGuards.isRubyArray(arguments[0]));
        return this.executeToObjectArray((DynamicObject)arguments[0]);
    }

    public abstract Object[] executeToObjectArray(DynamicObject var1);

    @Specialization(guards={"isNullArray(array)"})
    public Object[] toObjectArrayNull(DynamicObject array) {
        return ArrayUtils.EMPTY_ARRAY;
    }

    @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public Object[] toObjectArrayOther(DynamicObject array, @Cached(value="of(array)") ArrayStrategy strategy) {
        int size = Layouts.ARRAY.getSize(array);
        return strategy.newMirror(array).getBoxedCopy(size);
    }
}

