/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.SideEffectFree;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class StrParseNode
extends ParseNode
implements ILiteralNode,
SideEffectFree {
    private final ByteList value;
    private final int codeRange;
    private boolean frozen;

    public StrParseNode(ISourcePosition position, ByteList value) {
        this(position, value, StringSupport.codeRangeScan((Encoding)value.getEncoding(), (ByteList)value));
    }

    public StrParseNode(ISourcePosition position, ByteList value, int codeRange) {
        super(position, false);
        this.value = value;
        this.codeRange = codeRange;
    }

    public StrParseNode(ISourcePosition position, StrParseNode head, StrParseNode tail) {
        super(position, false);
        ByteList headBL = head.getValue();
        ByteList tailBL = tail.getValue();
        ByteList myValue = new ByteList(headBL.getRealSize() + tailBL.getRealSize());
        myValue.setEncoding(headBL.getEncoding());
        myValue.append(headBL);
        myValue.append(tailBL);
        this.frozen = head.isFrozen() && tail.isFrozen();
        this.value = myValue;
        this.codeRange = StringSupport.codeRangeScan((Encoding)this.value.getEncoding(), (ByteList)this.value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public ByteList getValue() {
        return this.value;
    }

    public int getCodeRange() {
        return this.codeRange;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }
}

