/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class Symbol
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Symbol";
    private static final String fullName = "Symbol";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "SymbolEncoding";
    private static final int capHeight = 1010;
    private static final int xHeight = 520;
    private static final int ascender = 1010;
    private static final int descender = -293;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("SymbolEncoding");
    private boolean enableKerning = false;

    public Symbol() {
        this(false);
    }

    public Symbol(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return "Symbol";
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return "Symbol";
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 1010;
    }

    public int getCapHeight(int size) {
        return size * 1010;
    }

    public int getDescender(int size) {
        return size * -293;
    }

    public int getXHeight(int size) {
        return size * 520;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return false;
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + "Symbol".toLowerCase());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        Symbol.width[32] = 250;
        Symbol.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        Symbol.width[33] = 333;
        Symbol.boundingBoxes[33] = new Rectangle(128, -17, 112, 689);
        Symbol.width[34] = 713;
        Symbol.boundingBoxes[34] = new Rectangle(31, 0, 650, 705);
        Symbol.width[35] = 500;
        Symbol.boundingBoxes[35] = new Rectangle(20, -16, 461, 689);
        Symbol.width[36] = 549;
        Symbol.boundingBoxes[36] = new Rectangle(25, 0, 453, 707);
        Symbol.width[37] = 833;
        Symbol.boundingBoxes[37] = new Rectangle(63, -36, 708, 691);
        Symbol.width[38] = 778;
        Symbol.boundingBoxes[38] = new Rectangle(41, -18, 709, 679);
        Symbol.width[39] = 439;
        Symbol.boundingBoxes[39] = new Rectangle(48, -17, 366, 517);
        Symbol.width[40] = 333;
        Symbol.boundingBoxes[40] = new Rectangle(53, -191, 247, 864);
        Symbol.width[41] = 333;
        Symbol.boundingBoxes[41] = new Rectangle(30, -191, 247, 864);
        Symbol.width[42] = 500;
        Symbol.boundingBoxes[42] = new Rectangle(65, 134, 362, 417);
        Symbol.width[43] = 549;
        Symbol.boundingBoxes[43] = new Rectangle(10, 0, 529, 533);
        Symbol.width[44] = 250;
        Symbol.boundingBoxes[44] = new Rectangle(56, -152, 138, 256);
        Symbol.width[45] = 549;
        Symbol.boundingBoxes[45] = new Rectangle(11, 233, 524, 55);
        Symbol.width[46] = 250;
        Symbol.boundingBoxes[46] = new Rectangle(69, -17, 112, 112);
        Symbol.width[47] = 278;
        Symbol.boundingBoxes[47] = new Rectangle(0, -18, 254, 664);
        Symbol.width[48] = 500;
        Symbol.boundingBoxes[48] = new Rectangle(24, -14, 452, 699);
        Symbol.width[49] = 500;
        Symbol.boundingBoxes[49] = new Rectangle(117, 0, 273, 673);
        Symbol.width[50] = 500;
        Symbol.boundingBoxes[50] = new Rectangle(25, 0, 450, 685);
        Symbol.width[51] = 500;
        Symbol.boundingBoxes[51] = new Rectangle(43, -14, 392, 699);
        Symbol.width[52] = 500;
        Symbol.boundingBoxes[52] = new Rectangle(15, 0, 454, 685);
        Symbol.width[53] = 500;
        Symbol.boundingBoxes[53] = new Rectangle(32, -14, 413, 704);
        Symbol.width[54] = 500;
        Symbol.boundingBoxes[54] = new Rectangle(34, -14, 434, 699);
        Symbol.width[55] = 500;
        Symbol.boundingBoxes[55] = new Rectangle(24, -16, 424, 689);
        Symbol.width[56] = 500;
        Symbol.boundingBoxes[56] = new Rectangle(56, -14, 389, 699);
        Symbol.width[57] = 500;
        Symbol.boundingBoxes[57] = new Rectangle(30, -18, 429, 703);
        Symbol.width[58] = 278;
        Symbol.boundingBoxes[58] = new Rectangle(81, -17, 112, 477);
        Symbol.width[59] = 278;
        Symbol.boundingBoxes[59] = new Rectangle(83, -152, 138, 612);
        Symbol.width[60] = 549;
        Symbol.boundingBoxes[60] = new Rectangle(26, 0, 497, 522);
        Symbol.width[61] = 549;
        Symbol.boundingBoxes[61] = new Rectangle(11, 141, 526, 249);
        Symbol.width[62] = 549;
        Symbol.boundingBoxes[62] = new Rectangle(26, 0, 497, 522);
        Symbol.width[63] = 444;
        Symbol.boundingBoxes[63] = new Rectangle(70, -17, 342, 703);
        Symbol.width[64] = 549;
        Symbol.boundingBoxes[64] = new Rectangle(11, 0, 526, 475);
        Symbol.width[65] = 722;
        Symbol.boundingBoxes[65] = new Rectangle(4, 0, 680, 673);
        Symbol.width[66] = 667;
        Symbol.boundingBoxes[66] = new Rectangle(29, 0, 563, 673);
        Symbol.width[67] = 722;
        Symbol.boundingBoxes[67] = new Rectangle(-9, 0, 713, 673);
        Symbol.width[68] = 612;
        Symbol.boundingBoxes[68] = new Rectangle(6, 0, 602, 688);
        Symbol.width[69] = 611;
        Symbol.boundingBoxes[69] = new Rectangle(32, 0, 585, 673);
        Symbol.width[70] = 763;
        Symbol.boundingBoxes[70] = new Rectangle(26, 0, 715, 673);
        Symbol.width[71] = 603;
        Symbol.boundingBoxes[71] = new Rectangle(24, 0, 585, 673);
        Symbol.width[72] = 722;
        Symbol.boundingBoxes[72] = new Rectangle(39, 0, 690, 673);
        Symbol.width[73] = 333;
        Symbol.boundingBoxes[73] = new Rectangle(32, 0, 284, 673);
        Symbol.width[74] = 631;
        Symbol.boundingBoxes[74] = new Rectangle(18, -18, 605, 707);
        Symbol.width[75] = 722;
        Symbol.boundingBoxes[75] = new Rectangle(35, 0, 687, 673);
        Symbol.width[76] = 686;
        Symbol.boundingBoxes[76] = new Rectangle(6, 0, 674, 688);
        Symbol.width[77] = 889;
        Symbol.boundingBoxes[77] = new Rectangle(28, 0, 859, 673);
        Symbol.width[78] = 722;
        Symbol.boundingBoxes[78] = new Rectangle(29, -8, 691, 681);
        Symbol.width[79] = 722;
        Symbol.boundingBoxes[79] = new Rectangle(41, -17, 674, 702);
        Symbol.width[80] = 768;
        Symbol.boundingBoxes[80] = new Rectangle(25, 0, 720, 673);
        Symbol.width[81] = 741;
        Symbol.boundingBoxes[81] = new Rectangle(41, -17, 674, 702);
        Symbol.width[82] = 556;
        Symbol.boundingBoxes[82] = new Rectangle(28, 0, 535, 673);
        Symbol.width[83] = 592;
        Symbol.boundingBoxes[83] = new Rectangle(5, 0, 584, 673);
        Symbol.width[84] = 611;
        Symbol.boundingBoxes[84] = new Rectangle(33, 0, 574, 673);
        Symbol.width[85] = 690;
        Symbol.boundingBoxes[85] = new Rectangle(-8, 0, 702, 673);
        Symbol.width[86] = 439;
        Symbol.boundingBoxes[86] = new Rectangle(40, -233, 396, 733);
        Symbol.width[87] = 768;
        Symbol.boundingBoxes[87] = new Rectangle(34, 0, 702, 688);
        Symbol.width[88] = 645;
        Symbol.boundingBoxes[88] = new Rectangle(40, 0, 559, 673);
        Symbol.width[89] = 795;
        Symbol.boundingBoxes[89] = new Rectangle(15, 0, 766, 684);
        Symbol.width[90] = 611;
        Symbol.boundingBoxes[90] = new Rectangle(44, 0, 592, 673);
        Symbol.width[91] = 333;
        Symbol.boundingBoxes[91] = new Rectangle(86, -155, 213, 829);
        Symbol.width[92] = 863;
        Symbol.boundingBoxes[92] = new Rectangle(163, 0, 538, 487);
        Symbol.width[93] = 333;
        Symbol.boundingBoxes[93] = new Rectangle(33, -155, 213, 829);
        Symbol.width[94] = 658;
        Symbol.boundingBoxes[94] = new Rectangle(15, 0, 637, 674);
        Symbol.width[95] = 500;
        Symbol.boundingBoxes[95] = new Rectangle(-2, -125, 504, 50);
        Symbol.width[96] = 500;
        Symbol.boundingBoxes[96] = new Rectangle(480, 881, 610, 36);
        Symbol.width[97] = 631;
        Symbol.boundingBoxes[97] = new Rectangle(41, -18, 581, 518);
        Symbol.width[98] = 549;
        Symbol.boundingBoxes[98] = new Rectangle(61, -223, 454, 964);
        Symbol.width[99] = 549;
        Symbol.boundingBoxes[99] = new Rectangle(12, -231, 510, 730);
        Symbol.width[100] = 494;
        Symbol.boundingBoxes[100] = new Rectangle(40, -19, 441, 759);
        Symbol.width[101] = 439;
        Symbol.boundingBoxes[101] = new Rectangle(22, -19, 405, 521);
        Symbol.width[102] = 521;
        Symbol.boundingBoxes[102] = new Rectangle(28, -224, 464, 897);
        Symbol.width[103] = 411;
        Symbol.boundingBoxes[103] = new Rectangle(5, -225, 479, 724);
        Symbol.width[104] = 603;
        Symbol.boundingBoxes[104] = new Rectangle(0, -202, 527, 716);
        Symbol.width[105] = 329;
        Symbol.boundingBoxes[105] = new Rectangle(0, -17, 301, 520);
        Symbol.width[106] = 603;
        Symbol.boundingBoxes[106] = new Rectangle(36, -224, 551, 723);
        Symbol.width[107] = 549;
        Symbol.boundingBoxes[107] = new Rectangle(33, 0, 525, 501);
        Symbol.width[108] = 549;
        Symbol.boundingBoxes[108] = new Rectangle(24, -17, 524, 756);
        Symbol.width[109] = 576;
        Symbol.boundingBoxes[109] = new Rectangle(33, -223, 534, 723);
        Symbol.width[110] = 521;
        Symbol.boundingBoxes[110] = new Rectangle(-9, -16, 484, 523);
        Symbol.width[111] = 549;
        Symbol.boundingBoxes[111] = new Rectangle(35, -19, 466, 518);
        Symbol.width[112] = 549;
        Symbol.boundingBoxes[112] = new Rectangle(10, -19, 520, 506);
        Symbol.width[113] = 521;
        Symbol.boundingBoxes[113] = new Rectangle(43, -17, 442, 707);
        Symbol.width[114] = 549;
        Symbol.boundingBoxes[114] = new Rectangle(50, -230, 440, 729);
        Symbol.width[115] = 603;
        Symbol.boundingBoxes[115] = new Rectangle(30, -21, 558, 521);
        Symbol.width[116] = 439;
        Symbol.boundingBoxes[116] = new Rectangle(10, -19, 408, 519);
        Symbol.width[117] = 576;
        Symbol.boundingBoxes[117] = new Rectangle(7, -18, 528, 525);
        Symbol.width[118] = 713;
        Symbol.boundingBoxes[118] = new Rectangle(12, -18, 659, 601);
        Symbol.width[119] = 686;
        Symbol.boundingBoxes[119] = new Rectangle(42, -17, 642, 517);
        Symbol.width[120] = 493;
        Symbol.boundingBoxes[120] = new Rectangle(27, -224, 442, 990);
        Symbol.width[121] = 686;
        Symbol.boundingBoxes[121] = new Rectangle(12, -228, 689, 728);
        Symbol.width[122] = 494;
        Symbol.boundingBoxes[122] = new Rectangle(60, -225, 407, 981);
        Symbol.width[123] = 480;
        Symbol.boundingBoxes[123] = new Rectangle(58, -183, 339, 856);
        Symbol.width[124] = 200;
        Symbol.boundingBoxes[124] = new Rectangle(65, -293, 70, 1000);
        Symbol.width[125] = 480;
        Symbol.boundingBoxes[125] = new Rectangle(79, -183, 339, 856);
        Symbol.width[126] = 549;
        Symbol.boundingBoxes[126] = new Rectangle(17, 203, 512, 104);
        Symbol.width[160] = 750;
        Symbol.boundingBoxes[160] = new Rectangle(20, -12, 694, 697);
        Symbol.width[161] = 620;
        Symbol.boundingBoxes[161] = new Rectangle(-2, 0, 612, 685);
        Symbol.width[162] = 247;
        Symbol.boundingBoxes[162] = new Rectangle(27, 459, 201, 276);
        Symbol.width[163] = 549;
        Symbol.boundingBoxes[163] = new Rectangle(29, 0, 497, 639);
        Symbol.width[164] = 167;
        Symbol.boundingBoxes[164] = new Rectangle(-180, -12, 520, 689);
        Symbol.width[165] = 713;
        Symbol.boundingBoxes[165] = new Rectangle(26, 124, 662, 280);
        Symbol.width[166] = 500;
        Symbol.boundingBoxes[166] = new Rectangle(2, -193, 492, 879);
        Symbol.width[167] = 753;
        Symbol.boundingBoxes[167] = new Rectangle(86, -26, 574, 559);
        Symbol.width[168] = 753;
        Symbol.boundingBoxes[168] = new Rectangle(142, -36, 458, 586);
        Symbol.width[169] = 753;
        Symbol.boundingBoxes[169] = new Rectangle(117, -33, 514, 565);
        Symbol.width[170] = 753;
        Symbol.boundingBoxes[170] = new Rectangle(113, -36, 516, 584);
        Symbol.width[171] = 1042;
        Symbol.boundingBoxes[171] = new Rectangle(24, -15, 1000, 526);
        Symbol.width[172] = 987;
        Symbol.boundingBoxes[172] = new Rectangle(32, -15, 910, 526);
        Symbol.width[173] = 603;
        Symbol.boundingBoxes[173] = new Rectangle(45, 0, 526, 910);
        Symbol.width[174] = 987;
        Symbol.boundingBoxes[174] = new Rectangle(49, -15, 910, 526);
        Symbol.width[175] = 603;
        Symbol.boundingBoxes[175] = new Rectangle(45, -22, 526, 910);
        Symbol.width[176] = 400;
        Symbol.boundingBoxes[176] = new Rectangle(50, 385, 300, 300);
        Symbol.width[177] = 549;
        Symbol.boundingBoxes[177] = new Rectangle(10, 0, 529, 645);
        Symbol.width[178] = 411;
        Symbol.boundingBoxes[178] = new Rectangle(20, 459, 393, 278);
        Symbol.width[179] = 549;
        Symbol.boundingBoxes[179] = new Rectangle(29, 0, 497, 639);
        Symbol.width[180] = 549;
        Symbol.boundingBoxes[180] = new Rectangle(17, 8, 516, 516);
        Symbol.width[181] = 713;
        Symbol.boundingBoxes[181] = new Rectangle(27, 123, 612, 281);
        Symbol.width[182] = 494;
        Symbol.boundingBoxes[182] = new Rectangle(26, -20, 436, 766);
        Symbol.width[183] = 460;
        Symbol.boundingBoxes[183] = new Rectangle(50, 113, 360, 360);
        Symbol.width[184] = 549;
        Symbol.boundingBoxes[184] = new Rectangle(10, 71, 526, 385);
        Symbol.width[185] = 549;
        Symbol.boundingBoxes[185] = new Rectangle(15, -25, 525, 574);
        Symbol.width[186] = 549;
        Symbol.boundingBoxes[186] = new Rectangle(14, 82, 524, 361);
        Symbol.width[187] = 549;
        Symbol.boundingBoxes[187] = new Rectangle(14, 135, 513, 259);
        Symbol.width[188] = 1000;
        Symbol.boundingBoxes[188] = new Rectangle(111, -17, 778, 112);
        Symbol.width[189] = 603;
        Symbol.boundingBoxes[189] = new Rectangle(280, -120, 56, 1130);
        Symbol.width[190] = 1000;
        Symbol.boundingBoxes[190] = new Rectangle(-60, 220, 1110, 56);
        Symbol.width[191] = 658;
        Symbol.boundingBoxes[191] = new Rectangle(15, -16, 587, 645);
        Symbol.width[192] = 823;
        Symbol.boundingBoxes[192] = new Rectangle(175, -18, 486, 676);
        Symbol.width[193] = 686;
        Symbol.boundingBoxes[193] = new Rectangle(10, -53, 568, 793);
        Symbol.width[194] = 795;
        Symbol.boundingBoxes[194] = new Rectangle(26, -15, 733, 749);
        Symbol.width[195] = 987;
        Symbol.boundingBoxes[195] = new Rectangle(159, -211, 711, 784);
        Symbol.width[196] = 768;
        Symbol.boundingBoxes[196] = new Rectangle(43, -17, 690, 690);
        Symbol.width[197] = 768;
        Symbol.boundingBoxes[197] = new Rectangle(43, -15, 690, 690);
        Symbol.width[198] = 823;
        Symbol.boundingBoxes[198] = new Rectangle(39, -24, 742, 743);
        Symbol.width[199] = 768;
        Symbol.boundingBoxes[199] = new Rectangle(40, 0, 692, 509);
        Symbol.width[200] = 768;
        Symbol.boundingBoxes[200] = new Rectangle(40, -17, 692, 509);
        Symbol.width[201] = 713;
        Symbol.boundingBoxes[201] = new Rectangle(20, 0, 653, 470);
        Symbol.width[202] = 713;
        Symbol.boundingBoxes[202] = new Rectangle(20, -125, 653, 595);
        Symbol.width[203] = 713;
        Symbol.boundingBoxes[203] = new Rectangle(36, -70, 654, 610);
        Symbol.width[204] = 713;
        Symbol.boundingBoxes[204] = new Rectangle(37, 0, 653, 470);
        Symbol.width[205] = 713;
        Symbol.boundingBoxes[205] = new Rectangle(37, -125, 653, 595);
        Symbol.width[206] = 713;
        Symbol.boundingBoxes[206] = new Rectangle(45, 0, 460, 468);
        Symbol.width[207] = 713;
        Symbol.boundingBoxes[207] = new Rectangle(45, -58, 460, 613);
        Symbol.width[208] = 768;
        Symbol.boundingBoxes[208] = new Rectangle(26, 0, 712, 673);
        Symbol.width[209] = 713;
        Symbol.boundingBoxes[209] = new Rectangle(36, -19, 645, 737);
        Symbol.width[210] = 790;
        Symbol.boundingBoxes[210] = new Rectangle(50, -17, 690, 690);
        Symbol.width[211] = 790;
        Symbol.boundingBoxes[211] = new Rectangle(51, -15, 690, 690);
        Symbol.width[212] = 890;
        Symbol.boundingBoxes[212] = new Rectangle(18, 293, 837, 380);
        Symbol.width[213] = 823;
        Symbol.boundingBoxes[213] = new Rectangle(25, -101, 778, 852);
        Symbol.width[214] = 549;
        Symbol.boundingBoxes[214] = new Rectangle(10, -38, 505, 955);
        Symbol.width[215] = 250;
        Symbol.boundingBoxes[215] = new Rectangle(69, 210, 100, 100);
        Symbol.width[216] = 713;
        Symbol.boundingBoxes[216] = new Rectangle(15, 0, 665, 288);
        Symbol.width[217] = 603;
        Symbol.boundingBoxes[217] = new Rectangle(23, 0, 560, 454);
        Symbol.width[218] = 603;
        Symbol.boundingBoxes[218] = new Rectangle(30, 0, 548, 477);
        Symbol.width[219] = 1042;
        Symbol.boundingBoxes[219] = new Rectangle(27, -20, 996, 530);
        Symbol.width[220] = 987;
        Symbol.boundingBoxes[220] = new Rectangle(30, -15, 909, 528);
        Symbol.width[221] = 603;
        Symbol.boundingBoxes[221] = new Rectangle(39, 2, 528, 909);
        Symbol.width[222] = 987;
        Symbol.boundingBoxes[222] = new Rectangle(45, -20, 909, 528);
        Symbol.width[223] = 603;
        Symbol.boundingBoxes[223] = new Rectangle(44, -19, 528, 909);
        Symbol.width[224] = 494;
        Symbol.boundingBoxes[224] = new Rectangle(18, 0, 448, 745);
        Symbol.width[225] = 329;
        Symbol.boundingBoxes[225] = new Rectangle(25, -198, 281, 944);
        Symbol.width[226] = 790;
        Symbol.boundingBoxes[226] = new Rectangle(50, -20, 690, 690);
        Symbol.width[227] = 790;
        Symbol.boundingBoxes[227] = new Rectangle(49, -15, 690, 690);
        Symbol.width[228] = 786;
        Symbol.boundingBoxes[228] = new Rectangle(5, 293, 720, 380);
        Symbol.width[229] = 713;
        Symbol.boundingBoxes[229] = new Rectangle(14, -108, 681, 860);
        Symbol.width[230] = 384;
        Symbol.boundingBoxes[230] = new Rectangle(24, -293, 412, 1219);
        Symbol.width[231] = 384;
        Symbol.boundingBoxes[231] = new Rectangle(24, -85, 84, 1010);
        Symbol.width[232] = 384;
        Symbol.boundingBoxes[232] = new Rectangle(24, -293, 412, 1219);
        Symbol.width[233] = 384;
        Symbol.boundingBoxes[233] = new Rectangle(0, -80, 349, 1006);
        Symbol.width[234] = 384;
        Symbol.boundingBoxes[234] = new Rectangle(0, -79, 77, 1004);
        Symbol.width[235] = 384;
        Symbol.boundingBoxes[235] = new Rectangle(0, -80, 349, 1006);
        Symbol.width[236] = 494;
        Symbol.boundingBoxes[236] = new Rectangle(209, -85, 236, 1010);
        Symbol.width[237] = 494;
        Symbol.boundingBoxes[237] = new Rectangle(20, -85, 264, 1020);
        Symbol.width[238] = 494;
        Symbol.boundingBoxes[238] = new Rectangle(209, -75, 236, 1010);
        Symbol.width[239] = 494;
        Symbol.boundingBoxes[239] = new Rectangle(209, -85, 75, 1020);
        Symbol.width[241] = 329;
        Symbol.boundingBoxes[241] = new Rectangle(21, -198, 281, 944);
        Symbol.width[242] = 274;
        Symbol.boundingBoxes[242] = new Rectangle(2, -107, 289, 1023);
        Symbol.width[243] = 686;
        Symbol.boundingBoxes[243] = new Rectangle(308, -88, 367, 1008);
        Symbol.width[244] = 686;
        Symbol.boundingBoxes[244] = new Rectangle(308, -88, 70, 1063);
        Symbol.width[245] = 686;
        Symbol.boundingBoxes[245] = new Rectangle(11, -87, 367, 1008);
        Symbol.width[246] = 384;
        Symbol.boundingBoxes[246] = new Rectangle(54, -293, 412, 1219);
        Symbol.width[247] = 384;
        Symbol.boundingBoxes[247] = new Rectangle(382, -85, 84, 1010);
        Symbol.width[248] = 384;
        Symbol.boundingBoxes[248] = new Rectangle(54, -293, 412, 1219);
        Symbol.width[249] = 384;
        Symbol.boundingBoxes[249] = new Rectangle(22, -80, 349, 1006);
        Symbol.width[250] = 384;
        Symbol.boundingBoxes[250] = new Rectangle(294, -79, 77, 1004);
        Symbol.width[251] = 384;
        Symbol.boundingBoxes[251] = new Rectangle(22, -80, 349, 1006);
        Symbol.width[252] = 494;
        Symbol.boundingBoxes[252] = new Rectangle(48, -85, 236, 1010);
        Symbol.width[253] = 494;
        Symbol.boundingBoxes[253] = new Rectangle(209, -85, 264, 1020);
        Symbol.width[254] = 494;
        Symbol.boundingBoxes[254] = new Rectangle(48, -75, 236, 1010);
        familyNames = new HashSet();
        familyNames.add("Symbol");
    }
}

