/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.profile.commands.io;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.cli.profile.ExecutionContext;
import org.grails.cli.profile.commands.io.FileSystemInteraction;
import org.grails.io.support.DefaultResourceLoader;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.PathMatchingResourcePatternResolver;
import org.grails.io.support.Resource;
import org.grails.io.support.ResourceLoader;
import org.grails.io.support.ResourceLocator;
import org.grails.io.support.SpringIOUtils;

public class FileSystemInteractionImpl
implements FileSystemInteraction,
GroovyObject {
    private ExecutionContext executionContext;
    private ResourceLoader resourceLoader;
    private PathMatchingResourcePatternResolver resourcePatternResolver;
    private ResourceLocator resourceLocator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public FileSystemInteractionImpl(ExecutionContext executionContext, ResourceLoader resourceLoader) {
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver;
        ResourceLocator resourceLocator;
        void resourceLoader2;
        void executionContext2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var4_4 = executionContext2;
        this.executionContext = var4_4;
        void var5_5 = resourceLoader2;
        this.resourceLoader = var5_5;
        this.resourceLocator = resourceLocator = new ResourceLocator();
        this.resourceLocator.setSearchLocation(executionContext2.getBaseDir().getAbsolutePath());
        this.resourcePatternResolver = pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver((ResourceLoader)resourceLoader2);
    }

    public FileSystemInteractionImpl(ExecutionContext executionContext) {
        this(executionContext, (ResourceLoader)new DefaultResourceLoader());
    }

    @Override
    public FileSystemInteractionImpl mkdir(Object path) {
        File file = this.file(path);
        Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        return this;
    }

    @Override
    public FileSystemInteractionImpl delete(Object path) {
        File file = this.file(path);
        Boolean bl = file != null ? Boolean.valueOf(file.delete()) : null;
        return this;
    }

    @Override
    public FileSystemInteractionImpl copy(@DelegatesTo(value=FileSystemInteraction.CopySpec.class) Closure callable) {
        FileSystemInteraction.CopySpec spec = new FileSystemInteraction.CopySpec();
        FileSystemInteraction.CopySpec copySpec = spec;
        callable.setDelegate((Object)copySpec);
        callable.call();
        if (DefaultTypeTransformation.booleanUnbox((Object)spec.getFrom()) && DefaultTypeTransformation.booleanUnbox((Object)spec.getInto())) {
            if (spec.getFrom() instanceof Iterable) {
                this.copyAll((Iterable)ScriptBytecodeAdapter.castToType((Object)spec.getFrom(), Iterable.class), spec.getInto());
            } else {
                this.copy(spec.getFrom(), spec.getInto());
            }
        }
        return this;
    }

    @Override
    public FileSystemInteractionImpl copy(Object path, Object destination) {
        Resource from = this.resource(path);
        File to = this.file(destination);
        this.copy(from, to);
        return this;
    }

    @Override
    public FileSystemInteractionImpl copyAll(Iterable resources, Object destination) {
        this.mkdir(destination);
        Object path2 = null;
        for (Object path2 : resources) {
            Resource from = this.resource(path2);
            File to = this.file(destination);
            this.copy(from, to);
        }
        return this;
    }

    @Override
    public FileSystemInteractionImpl copy(Resource from, File to) {
        File file = to;
        if (!DefaultTypeTransformation.booleanUnbox(file != null ? Boolean.valueOf(file.exists()) : null)) {
            this.mkdir(to);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)from) && DefaultTypeTransformation.booleanUnbox((Object)to)) {
            if (to.isDirectory()) {
                File file2;
                this.mkdir(to);
                to = file2 = new File(to, from.getFilename());
            }
            SpringIOUtils.copy((Resource)from, (File)to);
            GrailsConsole.getInstance().addStatus(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{from.getFilename(), to.getCanonicalPath()}, new String[]{"Copied ", " to location ", ""})));
        }
        return this;
    }

    @Override
    public File file(Object path) {
        if (path instanceof File) {
            return (File)ScriptBytecodeAdapter.castToType((Object)path, File.class);
        }
        if (path instanceof Resource) {
            return ((Resource)ScriptBytecodeAdapter.castToType((Object)path, Resource.class)).getFile();
        }
        File baseDir = this.executionContext.getBaseDir();
        File file = baseDir;
        return new File(DefaultTypeTransformation.booleanUnbox((Object)file) ? file : new File("."), DefaultGroovyMethods.toString((Object)path));
    }

    @Override
    public File getBuildDir() {
        return BuildSettings.TARGET_DIR;
    }

    @Override
    public File getResourcesDir() {
        return BuildSettings.RESOURCES_DIR;
    }

    @Override
    public File getClassesDir() {
        return BuildSettings.CLASSES_DIR;
    }

    @Override
    public Resource source(String className) {
        return this.resourceLocator.findResourceForClassName(className);
    }

    @Override
    public String className(Resource resource) {
        return GrailsResourceUtils.getClassName((Resource)resource);
    }

    @Override
    public Resource resource(Object path) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)path)) {
            return (Resource)ScriptBytecodeAdapter.castToType(null, Resource.class);
        }
        if (path instanceof Resource) {
            return (Resource)ScriptBytecodeAdapter.castToType((Object)path, Resource.class);
        }
        File f = this.file(path);
        File file = f;
        if (DefaultTypeTransformation.booleanUnbox(file != null ? Boolean.valueOf(file.exists()) : null) && f.isFile()) {
            return new FileSystemResource(f);
        }
        String pathStr = DefaultGroovyMethods.toString((Object)path);
        Resource resource = this.resourceLoader.getResource(pathStr);
        if (resource.exists()) {
            return resource;
        }
        Collection<Resource> allResources = this.resources(pathStr);
        if (DefaultTypeTransformation.booleanUnbox(allResources)) {
            return (Resource)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(allResources, (int)0), Resource.class);
        }
        return resource;
    }

    @Override
    public Collection<Resource> resources(String pattern) {
        List list = DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)this.resourcePatternResolver.getResources(pattern), Object[].class)));
        try {
            return list;
        }
        catch (Exception e) {
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            return list2;
        }
    }

    @Override
    public String projectPath(Object path) {
        File file = this.file(path);
        if (DefaultTypeTransformation.booleanUnbox((Object)file)) {
            String basePath = this.executionContext.getBaseDir().getCanonicalPath();
            return StringGroovyMethods.minus((CharSequence)file.getCanonicalPath(), (Object)basePath).substring(1);
        }
        return "";
    }

    @Override
    public Collection<File> files(String pattern) {
        public class _files_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _files_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Resource res) {
                return res.getFile();
            }

            public Object call(Resource res) {
                return this.doCall(res);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _files_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect(this.resources(pattern), (Closure)new _files_closure1(this, this));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileSystemInteractionImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver getResourcePatternResolver() {
        return this.resourcePatternResolver;
    }

    public void setResourcePatternResolver(PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver) {
        this.resourcePatternResolver = pathMatchingResourcePatternResolver;
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }
}

