/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.DeleteFromRelationConfirmationDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> toDelete;
    private final Map<OsmPrimitive, PrimitiveData> clonedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();

    public DeleteCommand(Collection<? extends OsmPrimitive> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "data");
        this.toDelete = collection;
        this.checkConsistency();
    }

    public DeleteCommand(OsmPrimitive osmPrimitive) {
        this(Collections.singleton(osmPrimitive));
    }

    public DeleteCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive) {
        this(osmDataLayer, Collections.singleton(osmPrimitive));
    }

    public DeleteCommand(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        super(osmDataLayer);
        CheckParameterUtil.ensureParameterNotNull(collection, "data");
        this.toDelete = collection;
        this.checkConsistency();
    }

    public DeleteCommand(DataSet dataSet, Collection<? extends OsmPrimitive> collection) {
        super(dataSet);
        CheckParameterUtil.ensureParameterNotNull(collection, "data");
        this.toDelete = collection;
        this.checkConsistency();
    }

    private void checkConsistency() {
        if (this.toDelete.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection", new Object[0]));
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive == null) {
                throw new IllegalArgumentException("Primitive to delete must not be null");
            }
            if (osmPrimitive.getDataSet() != null) continue;
            throw new IllegalArgumentException("Primitive to delete must be in a dataset");
        }
    }

    @Override
    public boolean executeCommand() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive.isDeleted()) {
                throw new IllegalArgumentException(osmPrimitive + " is already deleted");
            }
            this.clonedPrimitives.put(osmPrimitive, osmPrimitive.save());
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).setNodes(null);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ((Relation)osmPrimitive).setMembers(null);
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        for (OsmPrimitive object : this.toDelete) {
            object.setDeleted(false);
        }
        for (Map.Entry entry : this.clonedPrimitives.entrySet()) {
            ((OsmPrimitive)entry.getKey()).load((PrimitiveData)entry.getValue());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    private EnumSet<OsmPrimitiveType> getTypesToDelete() {
        EnumSet<OsmPrimitiveType> enumSet = EnumSet.noneOf(OsmPrimitiveType.class);
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            enumSet.add(OsmPrimitiveType.from(osmPrimitive));
        }
        return enumSet;
    }

    @Override
    public String getDescriptionText() {
        String string;
        if (this.toDelete.size() == 1) {
            String string2;
            OsmPrimitive osmPrimitive = this.toDelete.iterator().next();
            switch (OsmPrimitiveType.from(osmPrimitive)) {
                case NODE: {
                    string2 = I18n.marktr("Delete node {0}");
                    break;
                }
                case WAY: {
                    string2 = I18n.marktr("Delete way {0}");
                    break;
                }
                case RELATION: {
                    string2 = I18n.marktr("Delete relation {0}");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return I18n.tr(string2, osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        }
        EnumSet<OsmPrimitiveType> enumSet = this.getTypesToDelete();
        if (enumSet.size() > 1) {
            string = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            OsmPrimitiveType osmPrimitiveType = (OsmPrimitiveType)((Object)enumSet.iterator().next());
            switch (osmPrimitiveType) {
                case NODE: {
                    string = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case WAY: {
                    string = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case RELATION: {
                    string = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return string;
    }

    @Override
    public Icon getDescriptionIcon() {
        if (this.toDelete.size() == 1) {
            return ImageProvider.get(this.toDelete.iterator().next().getDisplayType());
        }
        EnumSet<OsmPrimitiveType> enumSet = this.getTypesToDelete();
        if (enumSet.size() > 1) {
            return ImageProvider.get("data", "object");
        }
        return ImageProvider.get((OsmPrimitiveType)((Object)enumSet.iterator().next()));
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.toDelete.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>(this.toDelete.size());
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            arrayList.add(new DeleteChildCommand(osmPrimitive));
        }
        return arrayList;
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toDelete;
    }

    public static Command deleteWithReferences(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Set<OsmPrimitive> set = OsmPrimitive.getReferrer(collection);
        set.addAll(collection);
        if (set.isEmpty()) {
            return null;
        }
        if (!bl && !DeleteCommand.checkAndConfirmOutlyingDelete(set, null)) {
            return null;
        }
        return new DeleteCommand(osmDataLayer, set);
    }

    public static Command deleteWithReferences(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.deleteWithReferences(osmDataLayer, collection, false);
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.delete(osmDataLayer, collection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(Collection<OsmPrimitive> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Way way : OsmPrimitive.getFilteredList(collection, Way.class)) {
            for (Node node : way.getNodes()) {
                if (node.isTagged()) continue;
                List<OsmPrimitive> list = node.getReferrers();
                list.removeAll(collection);
                int n = 0;
                for (OsmPrimitive osmPrimitive : list) {
                    if (osmPrimitive.isDeleted()) continue;
                    ++n;
                }
                if (n != 0) continue;
                hashSet.add(node);
            }
        }
        return hashSet;
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl) {
        return DeleteCommand.delete(osmDataLayer, collection, bl, false);
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl, boolean bl2) {
        OsmPrimitive osmPrimitive;
        Collection<Node> collection2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        SubclassFilteredCollection<? extends OsmPrimitive, Relation> subclassFilteredCollection = Utils.filteredCollection(hashSet, Relation.class);
        if (!(subclassFilteredCollection.isEmpty() || bl2 || DeleteCommand.confirmRelationDeletion(subclassFilteredCollection))) {
            return null;
        }
        if (bl) {
            collection2 = DeleteCommand.computeNodesToDelete(hashSet);
            hashSet.addAll(collection2);
        }
        if (!bl2 && !DeleteCommand.checkAndConfirmOutlyingDelete(hashSet, Utils.filteredCollection(hashSet, Way.class))) {
            return null;
        }
        collection2 = new HashSet<Way>(OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(hashSet), Way.class));
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Way object : collection2) {
            osmPrimitive = new Way(object);
            ((Way)osmPrimitive).removeNodes(OsmPrimitive.getFilteredSet(hashSet, Node.class));
            if (((Way)osmPrimitive).getNodesCount() < 2) {
                hashSet.add(object);
                continue;
            }
            linkedList.add(new ChangeNodesCommand(object, ((Way)osmPrimitive).getNodes()));
        }
        if (!bl2) {
            Iterator<Relation> iterator = RelationToChildReference.getRelationToChildReferences(hashSet);
            iterator.removeIf(relationToChildReference -> relationToChildReference.getParent().isDeleted());
            if (!iterator.isEmpty()) {
                DeleteFromRelationConfirmationDialog deleteFromRelationConfirmationDialog = DeleteFromRelationConfirmationDialog.getInstance();
                deleteFromRelationConfirmationDialog.getModel().populate((Collection<RelationToChildReference>)((Object)iterator));
                deleteFromRelationConfirmationDialog.setVisible(true);
                if (deleteFromRelationConfirmationDialog.isCanceled()) {
                    return null;
                }
            }
        }
        for (Relation relation : OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(hashSet), Relation.class)) {
            osmPrimitive = new Relation(relation);
            ((Relation)osmPrimitive).removeMembersFor(hashSet);
            linkedList.add(new ChangeCommand(relation, osmPrimitive));
        }
        if (!hashSet.isEmpty()) {
            linkedList.add(osmDataLayer != null ? new DeleteCommand(osmDataLayer, hashSet) : new DeleteCommand(((OsmPrimitive)hashSet.iterator().next()).getDataSet(), hashSet));
        }
        return new SequenceCommand(I18n.tr("Delete", new Object[0]), linkedList);
    }

    public static Command deleteWaySegment(OsmDataLayer osmDataLayer, WaySegment waySegment) {
        if (waySegment.way.getNodesCount() < 3) {
            return DeleteCommand.delete(osmDataLayer, Collections.singleton(waySegment.way), false);
        }
        if (waySegment.way.isClosed()) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.addAll(waySegment.way.getNodes().subList(waySegment.lowerIndex + 1, waySegment.way.getNodesCount() - 1));
            arrayList.addAll(waySegment.way.getNodes().subList(0, waySegment.lowerIndex + 1));
            Way way = new Way(waySegment.way);
            way.setNodes(arrayList);
            return new ChangeCommand(waySegment.way, way);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList.addAll(waySegment.way.getNodes().subList(0, waySegment.lowerIndex + 1));
        arrayList2.addAll(waySegment.way.getNodes().subList(waySegment.lowerIndex + 1, waySegment.way.getNodesCount()));
        Way way = new Way(waySegment.way);
        if (arrayList.size() < 2) {
            way.setNodes(arrayList2);
            return new ChangeCommand(waySegment.way, way);
        }
        if (arrayList2.size() < 2) {
            way.setNodes(arrayList);
            return new ChangeCommand(waySegment.way, way);
        }
        SplitWayAction.SplitWayResult splitWayResult = SplitWayAction.splitWay(osmDataLayer, waySegment.way, Arrays.asList(arrayList, arrayList2), Collections.emptyList());
        return splitWayResult != null ? splitWayResult.getCommand() : null;
    }

    public static boolean checkAndConfirmOutlyingDelete(Collection<? extends OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) {
        return Command.checkAndConfirmOutlyingOperation("delete", I18n.tr("Delete confirmation", new Object[0]), I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to delete?", new Object[0]), I18n.tr("You are about to delete incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to delete?", new Object[0]), collection, collection2);
    }

    private static boolean confirmRelationDeletion(Collection<Relation> collection) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(new JMultilineLabel("<html>" + I18n.trn("You are about to delete {0} relation: {1}<br/>This step is rarely necessary and cannot be undone easily after being uploaded to the server.<br/>Do you really want to delete?", "You are about to delete {0} relations: {1}<br/>This step is rarely necessary and cannot be undone easily after being uploaded to the server.<br/>Do you really want to delete?", collection.size(), collection.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(collection, 20)) + "</html>"));
        return ConditionalOptionPaneUtil.showConfirmationDialog("delete_relations", Main.parent, jPanel, I18n.tr("Delete relation?", new Object[0]), 0, 3, 0);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toDelete, this.clonedPrimitives);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeleteCommand deleteCommand = (DeleteCommand)object;
        return Objects.equals(this.toDelete, deleteCommand.toDelete) && Objects.equals(this.clonedPrimitives, deleteCommand.clonedPrimitives);
    }

    private static final class DeleteChildCommand
    implements PseudoCommand {
        private final OsmPrimitive osm;

        private DeleteChildCommand(OsmPrimitive osmPrimitive) {
            this.osm = osmPrimitive;
        }

        @Override
        public String getDescriptionText() {
            return I18n.tr("Deleted ''{0}''", this.osm.getDisplayName(DefaultNameFormatter.getInstance()));
        }

        @Override
        public Icon getDescriptionIcon() {
            return ImageProvider.get(this.osm.getDisplayType());
        }

        @Override
        public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
            return Collections.singleton(this.osm);
        }

        public String toString() {
            return "DeleteChildCommand [osm=" + this.osm + "]";
        }
    }
}

