/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.Rendering;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractMapRenderer
implements Rendering {
    protected final Graphics2D g;
    protected final NavigatableComponent nc;
    protected final MapViewState mapState;
    protected boolean isInactiveMode;
    protected Color backgroundColor;
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color relationSelectedColor;
    protected Color nodeColor;
    protected Color highlightColor;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;

    public AbstractMapRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(graphics2D);
        CheckParameterUtil.ensureParameterNotNull(navigatableComponent);
        this.g = graphics2D;
        this.nc = navigatableComponent;
        this.mapState = navigatableComponent.getState();
        this.isInactiveMode = bl;
    }

    public abstract void drawNode(Node var1, Color var2, int var3, boolean var4);

    protected void drawOrderNumber(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, int n, Color color) {
        if (this.isSegmentVisible(mapViewPoint, mapViewPoint2) && AbstractMapRenderer.isLargeSegment(mapViewPoint, mapViewPoint2, this.segmentNumberSpace)) {
            String string = Integer.toString(n);
            int n2 = string.length();
            double d = (mapViewPoint.getInViewX() + mapViewPoint2.getInViewX()) / 2.0;
            double d2 = (mapViewPoint.getInViewY() + mapViewPoint2.getInViewY()) / 2.0;
            double d3 = d - (double)(4 * n2);
            double d4 = d2 + 4.0;
            if (this.virtualNodeSize != 0 && AbstractMapRenderer.isLargeSegment(mapViewPoint, mapViewPoint2, this.virtualNodeSpace)) {
                d4 = d2 - (double)this.virtualNodeSize - 3.0;
            }
            this.g.setColor(this.backgroundColor);
            this.g.fill(new Rectangle2D.Double(d3 - 1.0, d4 - 12.0, 8 * n2 + 1, 14.0));
            this.g.setColor(color);
            this.g.drawString(string, (int)d3, (int)d4);
        }
    }

    public void drawVirtualNodes(DataSet dataSet, BBox bBox) {
        if (this.virtualNodeSize == 0 || dataSet == null || bBox == null) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        for (Way comparable : dataSet.searchWays(bBox)) {
            if (!comparable.isUsable() || comparable.isDisabledAndHidden() || comparable.isDisabled()) continue;
            this.visitVirtual(generalPath, comparable);
        }
        this.g.setColor(this.nodeColor);
        this.g.draw(generalPath);
        try {
            generalPath = new GeneralPath();
            for (WaySegment waySegment : dataSet.getHighlightedVirtualNodes()) {
                if (!waySegment.way.isUsable() || waySegment.way.isDisabled()) continue;
                this.visitVirtual(generalPath, waySegment.toWay());
            }
            this.g.setColor(this.highlightColor);
            this.g.draw(generalPath);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Main.trace(arrayIndexOutOfBoundsException);
        }
    }

    public void getColors() {
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
    }

    protected void getSettings(boolean bl) {
        this.virtualNodeSize = bl ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
    }

    public static boolean isLargeSegment(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, int n) {
        return mapViewPoint.oneNormInView(mapViewPoint2) > (double)n;
    }

    protected boolean isSegmentVisible(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2) {
        MapViewState.MapViewRectangle mapViewRectangle = this.mapState.getViewArea();
        return (mapViewPoint.getOutsideRectangleFlags(mapViewRectangle) & mapViewPoint2.getOutsideRectangleFlags(mapViewRectangle)) == 0;
    }

    public void visitVirtual(Path2D path2D, Way way) {
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(iterator.next());
            while (iterator.hasNext()) {
                MapViewState.MapViewPoint mapViewPoint2 = this.mapState.getPointFor(iterator.next());
                if (this.isSegmentVisible(mapViewPoint, mapViewPoint2) && AbstractMapRenderer.isLargeSegment(mapViewPoint, mapViewPoint2, this.virtualNodeSpace)) {
                    double d = (mapViewPoint2.getInViewX() + mapViewPoint.getInViewX()) / 2.0;
                    double d2 = (mapViewPoint2.getInViewY() + mapViewPoint.getInViewY()) / 2.0;
                    path2D.moveTo(d - (double)this.virtualNodeSize, d2);
                    path2D.lineTo(d + (double)this.virtualNodeSize, d2);
                    path2D.moveTo(d, d2 - (double)this.virtualNodeSize);
                    path2D.lineTo(d, d2 + (double)this.virtualNodeSize);
                }
                mapViewPoint = mapViewPoint2;
            }
        }
    }
}

