/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl.internal;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SlowPathEvent;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.concurrent.Callable;

@NodeInfo(cost=NodeCost.NONE)
public abstract class SpecializationNode
extends Node {
    @Node.Child
    protected SpecializationNode next;
    private final int index;

    public SpecializationNode(int index) {
        this.index = index;
    }

    @Override
    public final NodeCost getCost() {
        return NodeCost.NONE;
    }

    public void reset() {
        SpecializationNode end;
        SpecializationNode start = this.findStart();
        if (start != (end = this.findEnd())) {
            start.replace(end, "reset specialization");
        }
    }

    public static Node updateRoot(Node node) {
        SpecializationNode.updateRootImpl(((SpecializedNode)((Object)node)).getSpecializationNode(), node);
        return node;
    }

    private static void updateRootImpl(SpecializationNode start, Node node) {
        start.setRoot(node);
        if (start.next != null) {
            SpecializationNode.updateRootImpl(start.next, node);
        }
    }

    protected final SpecializationNode polymorphicMerge(SpecializationNode newNode, SpecializationNode merged) {
        if (merged == newNode && this.count() <= 2) {
            return this.removeSame(new SlowPathEvent.SlowPathEvent0(this, "merged polymorphic to monomorphic", null));
        }
        return merged;
    }

    public final NodeCost getNodeCost() {
        switch (this.count()) {
            case 0: 
            case 1: {
                return NodeCost.UNINITIALIZED;
            }
            case 2: {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    protected abstract void setRoot(Node var1);

    protected abstract Node[] getSuppliedChildren();

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame) {
        if (this.isIdentical(newNode, frame)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame) : newNode;
    }

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame, Object o1) {
        if (this.isIdentical(newNode, frame, o1)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame, o1) : newNode;
    }

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame, Object o1, Object o2) {
        if (this.isIdentical(newNode, frame, o1, o2)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame, o1, o2) : newNode;
    }

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame, Object o1, Object o2, Object o3) {
        if (this.isIdentical(newNode, frame, o1, o2, o3)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame, o1, o2, o3) : newNode;
    }

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame, Object o1, Object o2, Object o3, Object o4) {
        if (this.isIdentical(newNode, frame, o1, o2, o3, o4)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame, o1, o2, o3, o4) : newNode;
    }

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        if (this.isIdentical(newNode, frame, o1, o2, o3, o4, o5)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame, o1, o2, o3, o4, o5) : newNode;
    }

    protected SpecializationNode merge(SpecializationNode newNode, Frame frame, Object ... args) {
        if (this.isIdentical(newNode, frame, args)) {
            return this;
        }
        return this.next != null ? this.next.merge(newNode, frame, args) : newNode;
    }

    protected boolean isSame(SpecializationNode other) {
        return this.getClass() == other.getClass();
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame) {
        return this.isSame(newNode);
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame, Object o1) {
        return this.isSame(newNode);
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame, Object o1, Object o2) {
        return this.isSame(newNode);
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame, Object o1, Object o2, Object o3) {
        return this.isSame(newNode);
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame, Object o1, Object o2, Object o3, Object o4) {
        return this.isSame(newNode);
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return this.isSame(newNode);
    }

    protected boolean isIdentical(SpecializationNode newNode, Frame frame, Object ... args) {
        return this.isSame(newNode);
    }

    protected final int countSame(SpecializationNode node) {
        return this.findStart().countSameImpl(node);
    }

    private int countSameImpl(SpecializationNode node) {
        if (this.next != null) {
            return this.next.countSameImpl(node) + (this.isSame(node) ? 1 : 0);
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SpecializationNode) {
            return ((SpecializationNode)obj).isSame(this);
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return this.index;
    }

    private int count() {
        return this.next != null ? this.next.count() + 1 : 1;
    }

    private SpecializationNode findEnd() {
        SpecializationNode node = this;
        while (node.next != null) {
            node = node.next;
        }
        return node;
    }

    protected final Object removeThis(CharSequence reason, Frame frame) {
        return this.removeThisImpl(reason).acceptAndExecute(frame);
    }

    protected final Object removeThis(CharSequence reason, Frame frame, Object o1) {
        return this.removeThisImpl(reason).acceptAndExecute(frame, o1);
    }

    protected final Object removeThis(CharSequence reason, Frame frame, Object o1, Object o2) {
        return this.removeThisImpl(reason).acceptAndExecute(frame, o1, o2);
    }

    protected final Object removeThis(CharSequence reason, Frame frame, Object o1, Object o2, Object o3) {
        return this.removeThisImpl(reason).acceptAndExecute(frame, o1, o2, o3);
    }

    protected final Object removeThis(CharSequence reason, Frame frame, Object o1, Object o2, Object o3, Object o4) {
        return this.removeThisImpl(reason).acceptAndExecute(frame, o1, o2, o3, o4);
    }

    protected final Object removeThis(CharSequence reason, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return this.removeThisImpl(reason).acceptAndExecute(frame, o1, o2, o3, o4, o5);
    }

    protected final Object removeThis(CharSequence reason, Frame frame, Object ... args) {
        return this.removeThisImpl(reason).acceptAndExecute(frame, args);
    }

    private SpecializationNode removeThisImpl(CharSequence reason) {
        this.replace(this.next, reason);
        return this.findEnd().findStart();
    }

    protected final SpecializationNode removeSame(CharSequence reason) {
        SpecializationNode start;
        SpecializationNode current = start = this.findStart();
        while (current != null) {
            if (current.isSame(this)) {
                NodeUtil.nonAtomicReplace(current, current.next, reason);
                if (current == start) {
                    start = start.next;
                }
            }
            current = current.next;
        }
        return this.findEnd().findStart();
    }

    private SpecializationNode findStart() {
        SpecializationNode node = this;
        Node parent = this.getParent();
        while (parent instanceof SpecializationNode) {
            SpecializationNode parentCast = (SpecializationNode)parent;
            if (parentCast.next != node) break;
            node = parentCast;
            parent = node.getParent();
        }
        return node;
    }

    private Node findRoot() {
        return this.findStart().getParent();
    }

    public Object acceptAndExecute(Frame frame) {
        throw new UnsupportedOperationException();
    }

    public Object acceptAndExecute(Frame frame, Object o1) {
        throw new UnsupportedOperationException();
    }

    public Object acceptAndExecute(Frame frame, Object o1, Object o2) {
        throw new UnsupportedOperationException();
    }

    public Object acceptAndExecute(Frame frame, Object o1, Object o2, Object o3) {
        throw new UnsupportedOperationException();
    }

    public Object acceptAndExecute(Frame frame, Object o1, Object o2, Object o3, Object o4) {
        throw new UnsupportedOperationException();
    }

    public Object acceptAndExecute(Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        throw new UnsupportedOperationException();
    }

    public Object acceptAndExecute(Frame frame, Object ... args) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createFallback() {
        return null;
    }

    protected SpecializationNode createPolymorphic() {
        return null;
    }

    protected SpecializationNode createNext(Frame frame) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createNext(Frame frame, Object o1) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createNext(Frame frame, Object o1, Object o2) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createNext(Frame frame, Object o1, Object o2, Object o3) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createNext(Frame frame, Object o1, Object o2, Object o3, Object o4) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createNext(Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        throw new UnsupportedOperationException();
    }

    protected SpecializationNode createNext(Frame frame, Object ... args) {
        throw new UnsupportedOperationException();
    }

    protected final Object uninitialized(Frame frame) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEvent0(this, "insert new specialization", frame));
        if (newNode == null) {
            return this.unsupported(frame);
        }
        return newNode.acceptAndExecute(frame);
    }

    protected final Object uninitialized(Frame frame, Object o1) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEvent1(this, "insert new specialization", frame, o1));
        if (newNode == null) {
            return this.unsupported(frame, o1);
        }
        return newNode.acceptAndExecute(frame, o1);
    }

    protected final Object uninitialized(Frame frame, Object o1, Object o2) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEvent2(this, "insert new specialization", frame, o1, o2));
        if (newNode == null) {
            return this.unsupported(frame, o1, o2);
        }
        return newNode.acceptAndExecute(frame, o1, o2);
    }

    protected final Object uninitialized(Frame frame, Object o1, Object o2, Object o3) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEvent3(this, "insert new specialization", frame, o1, o2, o3));
        if (newNode == null) {
            return this.unsupported(frame, o1, o2, o3);
        }
        return newNode.acceptAndExecute(frame, o1, o2, o3);
    }

    protected final Object uninitialized(Frame frame, Object o1, Object o2, Object o3, Object o4) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEvent4(this, "insert new specialization", frame, o1, o2, o3, o4));
        if (newNode == null) {
            return this.unsupported(frame, o1, o2, o3, o4);
        }
        return newNode.acceptAndExecute(frame, o1, o2, o3, o4);
    }

    protected final Object uninitialized(Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEvent5(this, "insert new specialization", frame, o1, o2, o3, o4, o5));
        if (newNode == null) {
            return this.unsupported(frame, o1, o2, o3, o4, o5);
        }
        return newNode.acceptAndExecute(frame, o1, o2, o3, o4, o5);
    }

    protected final Object uninitialized(Frame frame, Object ... args) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        SpecializationNode newNode = this.atomic(new InsertionEventN(this, "insert new specialization", frame, args));
        if (newNode == null) {
            return this.unsupported(frame, args);
        }
        return newNode.acceptAndExecute(frame, args);
    }

    protected final Object remove(String reason, Frame frame) {
        return this.atomic(new RemoveEvent0(this, reason, frame)).acceptAndExecute(frame);
    }

    protected final Object remove(String reason, Frame frame, Object o1) {
        return this.atomic(new RemoveEvent1(this, reason, frame, o1)).acceptAndExecute(frame, o1);
    }

    protected final Object remove(String reason, Frame frame, Object o1, Object o2) {
        return this.atomic(new RemoveEvent2(this, reason, frame, o1, o2)).acceptAndExecute(frame, o1, o2);
    }

    protected final Object remove(String reason, Frame frame, Object o1, Object o2, Object o3) {
        return this.atomic(new RemoveEvent3(this, reason, frame, o1, o2, o3)).acceptAndExecute(frame, o1, o2, o3);
    }

    protected final Object remove(String reason, Frame frame, Object o1, Object o2, Object o3, Object o4) {
        return this.atomic(new RemoveEvent4(this, reason, frame, o1, o2, o3, o4)).acceptAndExecute(frame, o1, o2, o3, o4);
    }

    protected final Object remove(String reason, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return this.atomic(new RemoveEvent5(this, reason, frame, o1, o2, o3, o4, o5)).acceptAndExecute(frame, o1, o2, o3, o4, o5);
    }

    protected final Object remove(String reason, Frame frame, Object ... args) {
        return this.atomic(new RemoveEventN(this, reason, frame, args)).acceptAndExecute(frame, args);
    }

    protected Object unsupported(Frame frame) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), new Object[0]);
    }

    protected Object unsupported(Frame frame, Object o1) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), o1);
    }

    protected Object unsupported(Frame frame, Object o1, Object o2) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), o1, o2);
    }

    protected Object unsupported(Frame frame, Object o1, Object o2, Object o3) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), o1, o2, o3);
    }

    protected Object unsupported(Frame frame, Object o1, Object o2, Object o3, Object o4) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), o1, o2, o3, o4);
    }

    protected Object unsupported(Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), o1, o2, o3, o4, o5);
    }

    protected Object unsupported(Frame frame, Object ... args) {
        throw new UnsupportedSpecializationException(this.findRoot(), this.getSuppliedChildren(), args);
    }

    static SpecializationNode insertSorted(SpecializationNode start, SpecializationNode generated, CharSequence message, SpecializationNode merged) {
        if (merged == generated) {
            SpecializationNode polymorphic;
            if (start.count() == 2 && (polymorphic = start.createPolymorphic()) != null) {
                SpecializationNode.insertAt(start, polymorphic, "insert polymorphic");
            }
            SpecializationNode current = start;
            while (current != null && current.index < generated.index) {
                current = current.next;
            }
            if (current != null) {
                return SpecializationNode.insertAt(current, generated, message);
            }
            return start;
        }
        return start;
    }

    static <T> SpecializationNode insertAt(SpecializationNode node, SpecializationNode insertBefore, CharSequence reason) {
        insertBefore.next = node;
        return NodeUtil.nonAtomicReplace(node, insertBefore, reason);
    }

    @Override
    public final String toString() {
        Class<?> clazz = this.getClass();
        StringBuilder b = new StringBuilder();
        b.append(clazz.getSimpleName());
        this.appendFields(b, clazz);
        if (this.next != null) {
            b.append("\n -> ").append(this.next.toString());
        }
        return b.toString();
    }

    private void appendFields(StringBuilder b, Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length == 0) {
            return;
        }
        b.append("(");
        String sep = "";
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            b.append(sep);
            String name = field.getName();
            if (name.equals("root")) continue;
            b.append(field.getName());
            b.append(" = ");
            try {
                field.setAccessible(true);
                Object value = field.get(this);
                if (value instanceof Object[]) {
                    b.append(Arrays.toString((Object[])field.get(this)));
                } else {
                    b.append(field.get(this));
                }
            }
            catch (IllegalArgumentException e) {
                b.append(e.toString());
            }
            catch (IllegalAccessException e) {
                b.append(e.toString());
            }
            sep = ", ";
        }
        b.append(")");
    }

    protected static void check(Assumption assumption) throws InvalidAssumptionException {
        if (assumption != null) {
            assumption.check();
        }
    }

    @ExplodeLoop
    protected static void check(Assumption[] assumptions) throws InvalidAssumptionException {
        if (assumptions != null) {
            CompilerAsserts.compilationConstant(assumptions.length);
            for (Assumption assumption : assumptions) {
                SpecializationNode.check(assumption);
            }
        }
    }

    protected static boolean isValid(Assumption assumption) {
        if (assumption != null) {
            return assumption.isValid();
        }
        return true;
    }

    protected static boolean isValid(Assumption[] assumptions) {
        if (assumptions != null) {
            for (Assumption assumption : assumptions) {
                if (SpecializationNode.isValid(assumption)) continue;
                return false;
            }
        }
        return true;
    }

    private static final class RemoveEventN
    extends SlowPathEvent.SlowPathEventN
    implements Callable<SpecializationNode> {
        RemoveEventN(SpecializationNode source, String reason, Frame frame, Object[] args) {
            super(source, reason, frame, args);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class RemoveEvent5
    extends SlowPathEvent.SlowPathEvent5
    implements Callable<SpecializationNode> {
        RemoveEvent5(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
            super(source, reason, frame, o1, o2, o3, o4, o5);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class RemoveEvent4
    extends SlowPathEvent.SlowPathEvent4
    implements Callable<SpecializationNode> {
        RemoveEvent4(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3, Object o4) {
            super(source, reason, frame, o1, o2, o3, o4);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class RemoveEvent3
    extends SlowPathEvent.SlowPathEvent3
    implements Callable<SpecializationNode> {
        RemoveEvent3(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3) {
            super(source, reason, frame, o1, o2, o3);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class RemoveEvent2
    extends SlowPathEvent.SlowPathEvent2
    implements Callable<SpecializationNode> {
        RemoveEvent2(SpecializationNode source, String reason, Frame frame, Object o1, Object o2) {
            super(source, reason, frame, o1, o2);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class RemoveEvent1
    extends SlowPathEvent.SlowPathEvent1
    implements Callable<SpecializationNode> {
        RemoveEvent1(SpecializationNode source, String reason, Frame frame, Object o1) {
            super(source, reason, frame, o1);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class RemoveEvent0
    extends SlowPathEvent.SlowPathEvent0
    implements Callable<SpecializationNode> {
        RemoveEvent0(SpecializationNode source, String reason, Frame frame) {
            super(source, reason, frame);
        }

        @Override
        public SpecializationNode call() throws Exception {
            return this.source.removeSame(this);
        }
    }

    private static final class InsertionEventN
    extends SlowPathEvent.SlowPathEventN
    implements Callable<SpecializationNode> {
        InsertionEventN(SpecializationNode source, String reason, Frame frame, Object[] args) {
            super(source, reason, frame, args);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame, this.args);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame, this.args));
        }
    }

    private static final class InsertionEvent5
    extends SlowPathEvent.SlowPathEvent5
    implements Callable<SpecializationNode> {
        InsertionEvent5(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
            super(source, reason, frame, o1, o2, o3, o4, o5);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame, this.o1, this.o2, this.o3, this.o4, this.o5);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame, this.o1, this.o2, this.o3, this.o4, this.o5));
        }
    }

    private static final class InsertionEvent4
    extends SlowPathEvent.SlowPathEvent4
    implements Callable<SpecializationNode> {
        InsertionEvent4(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3, Object o4) {
            super(source, reason, frame, o1, o2, o3, o4);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame, this.o1, this.o2, this.o3, this.o4);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame, this.o1, this.o2, this.o3, this.o4));
        }
    }

    private static final class InsertionEvent3
    extends SlowPathEvent.SlowPathEvent3
    implements Callable<SpecializationNode> {
        InsertionEvent3(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3) {
            super(source, reason, frame, o1, o2, o3);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame, this.o1, this.o2, this.o3);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame, this.o1, this.o2, this.o3));
        }
    }

    private static final class InsertionEvent2
    extends SlowPathEvent.SlowPathEvent2
    implements Callable<SpecializationNode> {
        InsertionEvent2(SpecializationNode source, String reason, Frame frame, Object o1, Object o2) {
            super(source, reason, frame, o1, o2);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame, this.o1, this.o2);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame, this.o1, this.o2));
        }
    }

    private static final class InsertionEvent1
    extends SlowPathEvent.SlowPathEvent1
    implements Callable<SpecializationNode> {
        InsertionEvent1(SpecializationNode source, String reason, Frame frame, Object o1) {
            super(source, reason, frame, o1);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame, this.o1);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame, this.o1));
        }
    }

    private static final class InsertionEvent0
    extends SlowPathEvent.SlowPathEvent0
    implements Callable<SpecializationNode> {
        InsertionEvent0(SpecializationNode source, String reason, Frame frame) {
            super(source, reason, frame);
        }

        @Override
        public SpecializationNode call() throws Exception {
            SpecializationNode next = this.source.createNext(this.frame);
            if (next == null) {
                next = this.source.createFallback();
            }
            if (next == null) {
                return null;
            }
            SpecializationNode start = this.source.findStart();
            if (start.index == Integer.MAX_VALUE) {
                return SpecializationNode.insertAt(start, next, this);
            }
            return SpecializationNode.insertSorted(start, next, this, start.merge(next, this.frame));
        }
    }
}

