/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.io.IOException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.platform.UnsafeGroup;

@CoreClass(value="Truffle::Kernel")
public abstract class TruffleKernelNodes {

    @CoreMethod(names={"load"}, isModuleFunction=true, required=1, optional=1, unsafe={UnsafeGroup.LOAD})
    @NodeChildren(value={@NodeChild(value="file", type=RubyNode.class), @NodeChild(value="wrap", type=RubyNode.class)})
    public static abstract class LoadNode
    extends CoreMethodNode {
        @CreateCast(value={"wrap"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(false, inherit);
        }

        @Specialization(guards={"isRubyString(file)"})
        public boolean load(VirtualFrame frame, DynamicObject file, boolean wrap, @Cached(value="create()") IndirectCallNode callNode, @Cached(value="create()") BranchProfile errorProfile) {
            if (wrap) {
                throw new UnsupportedOperationException();
            }
            try {
                RubyRootNode rootNode = this.getContext().getCodeLoader().parse(this.getContext().getSourceCache().getSource(StringOperations.getString(file)), (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, null, true, this);
                CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.getContext().getCoreLibrary().getMainObject());
                deferredCall.call(frame, callNode);
            }
            catch (IOException e) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().loadErrorCannotLoad(file.toString(), this));
            }
            return true;
        }
    }

    @CoreMethod(names={"at_exit"}, isModuleFunction=true, needsBlock=true, required=1, unsafe={UnsafeGroup.AT_EXIT})
    public static abstract class AtExitSystemNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object atExit(boolean always, DynamicObject block) {
            this.getContext().getAtExitManager().add(block, always);
            return this.nil();
        }
    }
}

