/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.exceptions.RescueNode;

public class RescueSplatNode
extends RescueNode {
    @Node.Child
    private RubyNode handlingClassesArray;

    public RescueSplatNode(RubyContext context, SourceSection sourceSection, RubyNode handlingClassesArray, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassesArray = handlingClassesArray;
    }

    @Override
    public boolean canHandle(VirtualFrame frame, DynamicObject exception) {
        DynamicObject handlingClasses = (DynamicObject)this.handlingClassesArray.execute(frame);
        for (Object handlingClass : ArrayOperations.toIterable(handlingClasses)) {
            if (!this.getIsANode().executeIsA(exception, (DynamicObject)handlingClass)) continue;
            return true;
        }
        return false;
    }
}

