/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.cast.ArrayCastNode;
import org.jruby.truffle.core.cast.ArrayCastNodeGen;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ShouldDestructureNode;
import org.jruby.truffle.language.control.AndNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.NotNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.CatchForLambdaNode;
import org.jruby.truffle.language.methods.CatchForMethodNode;
import org.jruby.truffle.language.methods.CatchForProcNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.MethodDefinitionNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.supercall.ReadSuperArgumentsNode;
import org.jruby.truffle.language.supercall.ReadZSuperArgumentsNode;
import org.jruby.truffle.language.supercall.SuperCallNode;
import org.jruby.truffle.language.supercall.ZSuperOutsideMethodNode;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.LoadArgumentsTranslator;
import org.jruby.truffle.parser.ParameterCollector;
import org.jruby.truffle.parser.ReloadArgumentsTranslator;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.KeywordArgParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.SuperParseNode;
import org.jruby.truffle.parser.ast.UnnamedRestArgParseNode;
import org.jruby.truffle.parser.ast.ZSuperParseNode;
import org.jruby.truffle.tools.ChaosNodeGen;

public class MethodTranslator
extends BodyTranslator {
    private final ArgsParseNode argsNode;
    private boolean isBlock;

    public MethodTranslator(Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ArgsParseNode argsNode) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockDefinitionNode compileBlockNode(RubySourceSection sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo, ProcType type, String[] variables) {
        Object frameOnStackMarkerSlot;
        RubyNode body;
        RubyNode preludeProc;
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        this.declareArguments();
        Arity arity = MethodTranslator.getArity(this.argsNode);
        Arity arityForCheck = this.argsNode.getRestArgNode() instanceof UnnamedRestArgParseNode && !((UnnamedRestArgParseNode)this.argsNode.getRestArgNode()).isStar() ? arity.withRest(false) : arity;
        boolean isProc = type == ProcType.PROC;
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
        RubyNode loadArguments = this.argsNode.accept(loadArgumentsTranslator);
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            ProfileArgumentNode readArrayNode = new ProfileArgumentNode(new ReadPreArgumentNode(0, MissingArgumentBehavior.RUNTIME_ERROR));
            ArrayCastNode castArrayNode = ArrayCastNodeGen.create(this.context, fullSourceSection, readArrayNode);
            FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
            String[] writeArrayNode = WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, arraySlot, (RubyNode)castArrayNode);
            LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
            destructureArgumentsTranslator.pushArraySlot(arraySlot);
            RubyNode newDestructureArguments = this.argsNode.accept(destructureArgumentsTranslator);
            ShouldDestructureNode shouldDestructure = new ShouldDestructureNode(readArrayNode);
            RubyNode arrayWasNotNil = MethodTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(writeArrayNode, new NotNode(new IsNilNode(this.context, fullSourceSection, new ReadLocalVariableNode(this.context, fullSourceSection, LocalVariableType.FRAME_LOCAL, arraySlot)))));
            AndNode shouldDestructureAndArrayWasNotNil = new AndNode(shouldDestructure, arrayWasNotNil);
            preludeProc = new IfElseNode(shouldDestructureAndArrayWasNotNil, newDestructureArguments, loadArguments);
        } else {
            preludeProc = loadArguments;
        }
        RubyNode checkArity = MethodTranslator.createCheckArityNode(this.context, this.source, sourceSection, arityForCheck);
        RubyNode preludeLambda = MethodTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(checkArity, NodeUtil.cloneNode(loadArguments)));
        this.parentSourceSection.push(sourceSection);
        try {
            if (!this.translatingForStatement) {
                for (String var : variables) {
                    this.environment.declareVar(var);
                }
            }
            body = this.translateNodeOrNil(sourceSection, bodyNode);
            if (this.context.getOptions().CHAOS) {
                body = ChaosNodeGen.create(body);
            }
        }
        finally {
            this.parentSourceSection.pop();
        }
        CatchForProcNode bodyProc = new CatchForProcNode(this.context, this.translateSourceSection(this.source, MethodTranslator.enclosing(sourceSection, body)), this.composeBody(sourceSection, preludeProc, NodeUtil.cloneNode(body)));
        RubyRootNode newRootNodeForProcs = new RubyRootNode(this.context, this.translateSourceSection(this.source, this.considerExtendingMethodToCoverEnd(sourceSection)), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyProc, this.environment.needsDeclarationFrame());
        RubyNode composed = this.composeBody(sourceSection, preludeLambda, body);
        CatchForLambdaNode bodyLambda = new CatchForLambdaNode(this.context, sourceSection.toSourceSection(this.source), this.environment.getReturnID(), composed);
        RubyRootNode newRootNodeForLambdas = new RubyRootNode(this.context, this.translateSourceSection(this.source, this.considerExtendingMethodToCoverEnd(sourceSection)), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyLambda, this.environment.needsDeclarationFrame());
        RootCallTarget callTargetAsLambda = Truffle.getRuntime().createCallTarget(newRootNodeForLambdas);
        RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget(newRootNodeForProcs);
        if (this.frameOnStackMarkerSlotStack.isEmpty()) {
            frameOnStackMarkerSlot = null;
        } else {
            frameOnStackMarkerSlot = this.frameOnStackMarkerSlotStack.peek();
            if (frameOnStackMarkerSlot == BAD_FRAME_SLOT) {
                frameOnStackMarkerSlot = null;
            }
        }
        return new BlockDefinitionNode(this.context, newRootNodeForProcs.getSourceSection(), type, this.environment.getSharedMethodInfo(), callTargetAsProc, callTargetAsLambda, this.environment.getBreakID(), frameOnStackMarkerSlot);
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (arity.hasKeywordsRest()) {
            return true;
        }
        if (!arity.hasRest() && arity.getOptional() == 0 && arity.getRequired() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }

    private RubyNode composeBody(RubySourceSection preludeSourceSection, RubyNode prelude, RubyNode body) {
        RubySourceSection sourceSection = MethodTranslator.enclosing(preludeSourceSection, body);
        body = MethodTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(prelude, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        return body;
    }

    public RubyNode compileMethodBody(RubySourceSection sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo) {
        return this.doCompileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode doCompileMethodBody(RubySourceSection sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode prelude;
        RubyNode body;
        this.declareArguments();
        Arity arity = MethodTranslator.getArity(this.argsNode);
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, false, this);
        RubyNode loadArguments = this.argsNode.accept(loadArgumentsTranslator);
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        if (this.usesRubiniusPrimitive) {
            prelude = loadArguments;
        } else {
            RubyNode checkArity = MethodTranslator.createCheckArityNode(this.context, this.source, sourceSection, arity);
            prelude = MethodTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(checkArity, loadArguments));
        }
        body = MethodTranslator.sequence(this.context, this.source, body.getRubySourceSection(), Arrays.asList(prelude, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(this.context, this.source, body.getRubySourceSection(), Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        body = new CatchForMethodNode(this.context, this.translateSourceSection(this.source, body.getRubySourceSection()), this.environment.getReturnID(), body);
        body = new ExceptionTranslatingNode(this.context, this.translateSourceSection(this.source, body.getRubySourceSection()), body, UnsupportedOperationBehavior.TYPE_ERROR);
        if (this.context.getOptions().CHAOS) {
            body = ChaosNodeGen.create(body);
        }
        return body;
    }

    public MethodDefinitionNode compileMethodNode(RubySourceSection sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body = this.compileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
        SourceSection extendedBodySourceSection = body.getRubySourceSection() == null ? sourceSection.toSourceSection(this.source) : this.translateSourceSection(this.source, this.considerExtendingMethodToCoverEnd(body.getRubySourceSection()));
        RubyRootNode rootNode = new RubyRootNode(this.context, extendedBodySourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
        return new MethodDefinitionNode(this.context, this.translateSourceSection(this.source, body.getRubySourceSection()), methodName, this.environment.getSharedMethodInfo(), callTarget);
    }

    private void declareArguments() {
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept(parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
    }

    public static Arity getArity(ArgsParseNode argsNode) {
        String[] keywordArguments;
        if (argsNode.hasKwargs() && argsNode.getKeywordCount() > 0) {
            ParseNode[] keywordNodes = argsNode.getKeywords().children();
            int keywordsCount = keywordNodes.length;
            keywordArguments = new String[keywordsCount];
            for (int i = 0; i < keywordsCount; ++i) {
                KeywordArgParseNode kwarg = (KeywordArgParseNode)keywordNodes[i];
                AssignableParseNode assignableNode = kwarg.getAssignable();
                if (assignableNode instanceof LocalAsgnParseNode) {
                    keywordArguments[i] = ((LocalAsgnParseNode)assignableNode).getName();
                    continue;
                }
                if (assignableNode instanceof DAsgnParseNode) {
                    keywordArguments[i] = ((DAsgnParseNode)assignableNode).getName();
                    continue;
                }
                throw new UnsupportedOperationException("unsupported keyword arg " + kwarg);
            }
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
        }
        return new Arity(argsNode.getPreCount(), argsNode.getOptionalArgsCount(), argsNode.hasRestArg(), argsNode.getPostCount(), keywordArguments, argsNode.hasKeyRest());
    }

    @Override
    public RubyNode visitSuperNode(SuperParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), this.environment.getNamedMethodName());
        ReadSuperArgumentsNode arguments = new ReadSuperArgumentsNode(this.context, fullSourceSection, argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
        RubyNode block = this.executeOrInheritBlock(argumentsAndBlock.getBlock());
        return new SuperCallNode(this.context, fullSourceSection, arguments, block);
    }

    @Override
    public RubyNode visitZSuperNode(ZSuperParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        this.currentCallMethodName = this.environment.getNamedMethodName();
        RubyNode blockNode = node.getIterNode() != null ? node.getIterNode().accept(this) : null;
        boolean insideDefineMethod = false;
        MethodTranslator methodArgumentsTranslator = this;
        while (methodArgumentsTranslator.isBlock) {
            if (!(methodArgumentsTranslator.parent instanceof MethodTranslator)) {
                return new ZSuperOutsideMethodNode(this.context, fullSourceSection, insideDefineMethod);
            }
            if (methodArgumentsTranslator.currentCallMethodName.equals("define_method")) {
                insideDefineMethod = true;
            }
            methodArgumentsTranslator = (MethodTranslator)methodArgumentsTranslator.parent;
        }
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.currentNode, this.context, this.source, this);
        ArgsParseNode argsNode = methodArgumentsTranslator.argsNode;
        SequenceNode reloadSequence = (SequenceNode)reloadTranslator.visitArgsNode(argsNode);
        ReadZSuperArgumentsNode arguments = new ReadZSuperArgumentsNode(this.context, fullSourceSection, reloadTranslator.isSplatted(), reloadSequence.getSequence());
        RubyNode block = this.executeOrInheritBlock(blockNode);
        return new SuperCallNode(this.context, fullSourceSection, arguments, block);
    }

    private RubyNode executeOrInheritBlock(RubyNode blockNode) {
        if (blockNode != null) {
            return blockNode;
        }
        return new ReadBlockNode(this.context.getCoreLibrary().getNilObject());
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(RubySourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }

    private RubySourceSection considerExtendingMethodToCoverEnd(RubySourceSection sourceSection) {
        if (sourceSection == null) {
            return sourceSection;
        }
        if (sourceSection.getEndLine() + 1 >= this.source.getLineCount()) {
            return sourceSection;
        }
        String indentationOnFirstLine = MethodTranslator.indentation(this.source.getCode(sourceSection.getStartLine()));
        int lineAfter = sourceSection.getEndLine() + 1;
        do {
            String lineAfterString;
            if (!(lineAfterString = this.source.getCode(lineAfter).replaceAll("\\s+$", "")).equals(indentationOnFirstLine + "end") && !lineAfterString.equals(indentationOnFirstLine + "}")) continue;
            return new RubySourceSection(sourceSection.getStartLine(), sourceSection.getEndLine() + 1);
        } while (++lineAfter < this.source.getLineCount());
        return sourceSection;
    }

    private static String indentation(String line) {
        for (int n = 0; n < line.length(); ++n) {
            if (Character.isWhitespace(line.charAt(n))) continue;
            return line.substring(0, n);
        }
        return "";
    }
}

