/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.XComponentContext;
import org.openoffice.da.comp.w2lcommon.filter.OptionsDialogBase;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.writer2latex.W2LRegistration;

public class LaTeXOptionsDialog
extends OptionsDialogBase {
    private static final String[] BACKEND_VALUES = new String[]{"generic", "pdftex", "dvips", "xetex", "unspecified"};
    private static final String[] INPUTENCODING_VALUES = new String[]{"ascii", "latin1", "latin2", "iso-8859-7", "cp1250", "cp1251", "koi8-r", "utf8"};
    private static final String[] NOTES_VALUES = new String[]{"ignore", "comment", "marginpar", "pdfannotation"};
    private static final String[] FLOATOPTIONS_VALUES = new String[]{"", "tp", "bp", "htp", "hbp"};
    public static String __serviceName = "org.openoffice.da.writer2latex.LaTeXOptionsDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2latex.LaTeXOptionsDialog";

    @Override
    public String getDialogLibraryName() {
        return "W2LDialogs";
    }

    public LaTeXOptionsDialog(XComponentContext xContext) {
        super(xContext);
        this.xMSF = W2LRegistration.xMultiServiceFactory;
    }

    @Override
    public String getDialogName() {
        return "LaTeXOptions";
    }

    @Override
    public String getRegistryPath() {
        return "/org.openoffice.da.Writer2LaTeX.Options/LaTeXOptions";
    }

    @Override
    protected void loadSettings(XPropertySet xProps) {
        this.loadConfig(xProps);
        this.loadListBoxOption(xProps, "Backend");
        this.loadListBoxOption(xProps, "Inputencoding");
        this.loadCheckBoxOption(xProps, "Multilingual");
        this.loadCheckBoxOption(xProps, "GreekMath");
        this.loadCheckBoxOption(xProps, "AdditionalSymbols");
        this.loadCheckBoxOption(xProps, "UseBibtex");
        this.loadComboBoxOption(xProps, "BibtexStyle");
        this.loadCheckBoxOption(xProps, "WrapLines");
        this.loadNumericOption(xProps, "WrapLinesAfter");
        this.loadCheckBoxOption(xProps, "SplitLinkedSections");
        this.loadCheckBoxOption(xProps, "SplitToplevelSections");
        this.loadCheckBoxOption(xProps, "SaveImagesInSubdir");
        this.loadListBoxOption(xProps, "Notes");
        this.loadCheckBoxOption(xProps, "Metadata");
        this.loadCheckBoxOption(xProps, "DisplayHiddenText");
        this.loadCheckBoxOption(xProps, "OriginalImageSize");
        this.loadCheckBoxOption(xProps, "OptimizeSimpleTables");
        this.loadNumericOption(xProps, "SimpleTableLimit");
        this.loadCheckBoxOption(xProps, "FloatTables");
        this.loadCheckBoxOption(xProps, "FloatFigures");
        this.loadListBoxOption(xProps, "FloatOptions");
        this.loadCheckBoxOption(xProps, "IgnoreHardPageBreaks");
        this.loadCheckBoxOption(xProps, "IgnoreHardLineBreaks");
        this.loadCheckBoxOption(xProps, "IgnoreEmptyParagraphs");
        this.loadCheckBoxOption(xProps, "IgnoreDoubleSpaces");
        this.updateLockedOptions();
        this.enableControls();
    }

    @Override
    protected void saveSettings(XPropertySet xProps, PropertyHelper filterData) {
        short nConfig = this.saveConfig(xProps, filterData);
        switch (nConfig) {
            case 0: {
                filterData.put("ConfigURL", "*ultraclean.xml");
                break;
            }
            case 1: {
                filterData.put("ConfigURL", "*clean.xml");
                break;
            }
            case 2: {
                filterData.put("ConfigURL", "*default.xml");
                break;
            }
            case 3: {
                filterData.put("ConfigURL", "*pdfprint.xml");
                break;
            }
            case 4: {
                filterData.put("ConfigURL", "*pdfscreen.xml");
                break;
            }
            case 5: {
                filterData.put("ConfigURL", "$(user)/writer2latex.xml");
                filterData.put("AutoCreate", "true");
            }
        }
        this.saveListBoxOption(xProps, filterData, "Backend", "backend", BACKEND_VALUES);
        if (this.getListBoxSelectedItem("Config") == 4) {
            filterData.put("backend", "pdftex");
        }
        this.saveListBoxOption(xProps, filterData, "Inputencoding", "inputencoding", INPUTENCODING_VALUES);
        this.saveCheckBoxOption(xProps, filterData, "Multilingual", "multilingual");
        this.saveCheckBoxOption(xProps, filterData, "GreekMath", "greek_math");
        this.saveCheckBoxOption(xProps, filterData, "AdditionalSymbols", "use_pifont");
        this.saveCheckBoxOption(xProps, filterData, "AdditionalSymbols", "use_ifsym");
        this.saveCheckBoxOption(xProps, filterData, "AdditionalSymbols", "use_wasysym");
        this.saveCheckBoxOption(xProps, filterData, "AdditionalSymbols", "use_eurosym");
        this.saveCheckBoxOption(xProps, filterData, "AdditionalSymbols", "use_tipa");
        this.saveCheckBoxOption(xProps, filterData, "UseBibtex", "use_bibtex");
        this.saveComboBoxOption(xProps, filterData, "BibtexStyle", "bibtex_style");
        boolean bWrapLines = this.saveCheckBoxOption(xProps, "WrapLines");
        int nWrapLinesAfter = this.saveNumericOption(xProps, "WrapLinesAfter");
        if (!this.isLocked("wrap_lines_after")) {
            if (bWrapLines) {
                filterData.put("wrap_lines_after", Integer.toString(nWrapLinesAfter));
            } else {
                filterData.put("wrap_lines_after", "0");
            }
        }
        this.saveCheckBoxOption(xProps, filterData, "SplitLinkedSections", "split_linked_sections");
        this.saveCheckBoxOption(xProps, filterData, "SplitToplevelSections", "split_toplevel_sections");
        this.saveCheckBoxOption(xProps, filterData, "SaveImagesInSubdir", "save_images_in_subdir");
        this.saveListBoxOption(xProps, filterData, "Notes", "notes", NOTES_VALUES);
        this.saveCheckBoxOption(xProps, filterData, "Metadata", "metadata");
        this.saveCheckBoxOption(xProps, filterData, "DisplayHiddenText", "display_hidden_text");
        this.saveCheckBoxOption(xProps, filterData, "OriginalImageSize", "original_image_size");
        boolean bOptimizeSimpleTables = this.saveCheckBoxOption(xProps, "OptimizeSimpleTables");
        int nSimpleTableLimit = this.saveNumericOption(xProps, "SimpleTableLimit");
        if (!this.isLocked("simple_table_limit")) {
            if (bOptimizeSimpleTables) {
                filterData.put("simple_table_limit", Integer.toString(nSimpleTableLimit));
            } else {
                filterData.put("simple_table_limit", "0");
            }
        }
        this.saveCheckBoxOption(xProps, filterData, "FloatTables", "float_tables");
        this.saveCheckBoxOption(xProps, filterData, "FloatFigures", "float_figures");
        this.saveListBoxOption(xProps, filterData, "FloatOptions", "float_options", FLOATOPTIONS_VALUES);
        this.saveCheckBoxOption(xProps, filterData, "IgnoreHardPageBreaks", "ignore_hard_page_breaks");
        this.saveCheckBoxOption(xProps, filterData, "IgnoreHardLineBreaks", "ignore_hard_line_breaks");
        this.saveCheckBoxOption(xProps, filterData, "IgnoreEmptyParagraphs", "ignore_empty_paragraphs");
        this.saveCheckBoxOption(xProps, filterData, "IgnoreDoubleSpaces", "ignore_double_spaces");
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("ConfigChange") || sMethod.equals("BackendChange")) {
            this.updateLockedOptions();
            this.enableControls();
        } else if (sMethod.equals("UseBibtexChange")) {
            this.enableBibtexStyle();
        } else if (sMethod.equals("WrapLinesChange")) {
            this.enableWrapLinesAfter();
        } else if (sMethod.equals("OptimizeSimpleTablesChange")) {
            this.enableSimpleTableLimit();
        } else if (sMethod.equals("FloatTablesChange")) {
            this.enableFloatOptions();
        } else if (sMethod.equals("FloatFiguresChange")) {
            this.enableFloatOptions();
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"ConfigChange", "UseBibtexChange", "WrapLinesChange", "OptimizeSimpleTablesChange", "FloatTablesChange", "FloatFiguresChange"};
        return sNames;
    }

    @Override
    protected boolean isLocked(String sOptionName) {
        if ("backend".equals(sOptionName)) {
            return this.getListBoxSelectedItem("Config") == 4 || super.isLocked(sOptionName);
        }
        if ("inputencoding".equals(sOptionName)) {
            return this.getListBoxSelectedItem("Backend") == 3 || super.isLocked(sOptionName);
        }
        if ("greek_math".equals(sOptionName)) {
            return this.getListBoxSelectedItem("Backend") == 3 || super.isLocked(sOptionName);
        }
        if ("additional_symbols".equals(sOptionName)) {
            return this.getListBoxSelectedItem("Backend") == 3 || this.getListBoxSelectedItem("Config") == 5 || super.isLocked(sOptionName);
        }
        if ("use_pifont".equals(sOptionName)) {
            return this.isLocked("additional_symbols");
        }
        if ("use_ifsym".equals(sOptionName)) {
            return this.isLocked("additional_symbols");
        }
        if ("use_wasysym".equals(sOptionName)) {
            return this.isLocked("additional_symbols");
        }
        if ("use_eurosym".equals(sOptionName)) {
            return this.isLocked("additional_symbols");
        }
        if ("use_tipa".equals(sOptionName)) {
            return this.isLocked("additional_symbols");
        }
        return super.isLocked(sOptionName);
    }

    private void enableControls() {
        this.setControlEnabled("BackendLabel", !this.isLocked("backend"));
        this.setControlEnabled("Backend", !this.isLocked("backend"));
        this.setControlEnabled("InputencodingLabel", !this.isLocked("inputencoding"));
        this.setControlEnabled("Inputencoding", !this.isLocked("inputencoding"));
        this.setControlEnabled("Multilingual", !this.isLocked("multilingual"));
        this.setControlEnabled("GreekMath", !this.isLocked("greek_math"));
        this.setControlEnabled("AdditionalSymbols", !this.isLocked("additional_symbols"));
        this.setControlEnabled("UseBibtex", !this.isLocked("use_bibtex"));
        boolean bUseBibtex = this.getCheckBoxStateAsBoolean("UseBibtex");
        this.setControlEnabled("BibtexStyleLabel", !this.isLocked("bibtex_style") && bUseBibtex);
        this.setControlEnabled("BibtexStyle", !this.isLocked("bibtex_style") && bUseBibtex);
        this.setControlEnabled("WrapLines", !this.isLocked("wrap_lines_after"));
        boolean bWrapLines = this.getCheckBoxStateAsBoolean("WrapLines");
        this.setControlEnabled("WrapLinesAfterLabel", !this.isLocked("wrap_lines_after") && bWrapLines);
        this.setControlEnabled("WrapLinesAfter", !this.isLocked("wrap_lines_after") && bWrapLines);
        this.setControlEnabled("SplitLinkedSections", !this.isLocked("split_linked_sections"));
        this.setControlEnabled("SplitToplevelSections", !this.isLocked("split_toplevel_sections"));
        this.setControlEnabled("SaveImagesInSubdir", !this.isLocked("save_images_in_subdir"));
        this.setControlEnabled("NotesLabel", !this.isLocked("notes"));
        this.setControlEnabled("Notes", !this.isLocked("notes"));
        this.setControlEnabled("Metadata", !this.isLocked("metadata"));
        this.setControlEnabled("DisplayHiddenText", !this.isLocked("display_hidden_text"));
        this.setControlEnabled("OriginalImageSize", !this.isLocked("original_image_size"));
        this.setControlEnabled("OptimizeSimpleTables", !this.isLocked("simple_table_limit"));
        boolean bOptimizeSimpleTables = this.getCheckBoxStateAsBoolean("OptimizeSimpleTables");
        this.setControlEnabled("SimpleTableLimitLabel", !this.isLocked("simple_table_limit") && bOptimizeSimpleTables);
        this.setControlEnabled("SimpleTableLimit", !this.isLocked("simple_table_limit") && bOptimizeSimpleTables);
        this.setControlEnabled("FloatTables", !this.isLocked("float_tables"));
        this.setControlEnabled("FloatFigures", !this.isLocked("float_figures"));
        boolean bFloat = this.getCheckBoxStateAsBoolean("FloatFigures") || this.getCheckBoxStateAsBoolean("FloatTables");
        this.setControlEnabled("FloatOptionsLabel", !this.isLocked("float_options") && bFloat);
        this.setControlEnabled("FloatOptions", !this.isLocked("float_options") && bFloat);
        this.setControlEnabled("IgnoreHardPageBreaks", !this.isLocked("ignore_hard_page_breaks"));
        this.setControlEnabled("IgnoreHardLineBreaks", !this.isLocked("ignore_hard_line_breaks"));
        this.setControlEnabled("IgnoreEmptyParagraphs", !this.isLocked("ignore_empty_paragraphs"));
        this.setControlEnabled("IgnoreDoubleSpaces", !this.isLocked("ignore_double_spaces"));
    }

    private void enableBibtexStyle() {
        if (!this.isLocked("bibtex_style")) {
            boolean bState = this.getCheckBoxStateAsBoolean("UseBibtex");
            this.setControlEnabled("BibtexStyleLabel", bState);
            this.setControlEnabled("BibtexStyle", bState);
        }
    }

    private void enableWrapLinesAfter() {
        if (!this.isLocked("wrap_lines_after")) {
            boolean bState = this.getCheckBoxStateAsBoolean("WrapLines");
            this.setControlEnabled("WrapLinesAfterLabel", bState);
            this.setControlEnabled("WrapLinesAfter", bState);
        }
    }

    private void enableSimpleTableLimit() {
        if (!this.isLocked("simple_table_limit")) {
            boolean bState = this.getCheckBoxStateAsBoolean("OptimizeSimpleTables");
            this.setControlEnabled("SimpleTableLimitLabel", bState);
            this.setControlEnabled("SimpleTableLimit", bState);
        }
    }

    private void enableFloatOptions() {
        if (!this.isLocked("float_options")) {
            boolean bState = this.getCheckBoxStateAsBoolean("FloatFigures") || this.getCheckBoxStateAsBoolean("FloatTables");
            this.setControlEnabled("FloatOptionsLabel", bState);
            this.setControlEnabled("FloatOptions", bState);
        }
    }
}

