type token =
  | TCommentSpace of (Ast_js.tok)
  | TCommentNewline of (Ast_js.tok)
  | TComment of (Ast_js.tok)
  | T_NUMBER of (string * Ast_js.tok)
  | T_IDENTIFIER of (string * Ast_js.tok)
  | T_STRING of (string * Ast_js.tok)
  | T_ENCAPSED_STRING of (string * Ast_js.tok)
  | T_REGEX of (string * Ast_js.tok)
  | T_FUNCTION of (Ast_js.tok)
  | T_IF of (Ast_js.tok)
  | T_IN of (Ast_js.tok)
  | T_INSTANCEOF of (Ast_js.tok)
  | T_RETURN of (Ast_js.tok)
  | T_SWITCH of (Ast_js.tok)
  | T_THIS of (Ast_js.tok)
  | T_THROW of (Ast_js.tok)
  | T_TRY of (Ast_js.tok)
  | T_VAR of (Ast_js.tok)
  | T_WHILE of (Ast_js.tok)
  | T_WITH of (Ast_js.tok)
  | T_CONST of (Ast_js.tok)
  | T_NULL of (Ast_js.tok)
  | T_FALSE of (Ast_js.tok)
  | T_TRUE of (Ast_js.tok)
  | T_BREAK of (Ast_js.tok)
  | T_CASE of (Ast_js.tok)
  | T_CATCH of (Ast_js.tok)
  | T_CONTINUE of (Ast_js.tok)
  | T_DEFAULT of (Ast_js.tok)
  | T_DO of (Ast_js.tok)
  | T_FINALLY of (Ast_js.tok)
  | T_FOR of (Ast_js.tok)
  | T_CLASS of (Ast_js.tok)
  | T_EXTENDS of (Ast_js.tok)
  | T_STATIC of (Ast_js.tok)
  | T_INTERFACE of (Ast_js.tok)
  | T_ELSE of (Ast_js.tok)
  | T_NEW of (Ast_js.tok)
  | T_LCURLY of (Ast_js.tok)
  | T_RCURLY of (Ast_js.tok)
  | T_LPAREN of (Ast_js.tok)
  | T_RPAREN of (Ast_js.tok)
  | T_LBRACKET of (Ast_js.tok)
  | T_RBRACKET of (Ast_js.tok)
  | T_SEMICOLON of (Ast_js.tok)
  | T_COMMA of (Ast_js.tok)
  | T_PERIOD of (Ast_js.tok)
  | T_ARROW of (Ast_js.tok)
  | T_DOTS of (Ast_js.tok)
  | T_BACKQUOTE of (Ast_js.tok)
  | T_DOLLARCURLY of (Ast_js.tok)
  | T_RSHIFT3_ASSIGN of (Ast_js.tok)
  | T_RSHIFT_ASSIGN of (Ast_js.tok)
  | T_LSHIFT_ASSIGN of (Ast_js.tok)
  | T_BIT_XOR_ASSIGN of (Ast_js.tok)
  | T_BIT_OR_ASSIGN of (Ast_js.tok)
  | T_BIT_AND_ASSIGN of (Ast_js.tok)
  | T_MOD_ASSIGN of (Ast_js.tok)
  | T_DIV_ASSIGN of (Ast_js.tok)
  | T_MULT_ASSIGN of (Ast_js.tok)
  | T_MINUS_ASSIGN of (Ast_js.tok)
  | T_PLUS_ASSIGN of (Ast_js.tok)
  | T_ASSIGN of (Ast_js.tok)
  | T_PLING of (Ast_js.tok)
  | T_COLON of (Ast_js.tok)
  | T_OR of (Ast_js.tok)
  | T_AND of (Ast_js.tok)
  | T_BIT_OR of (Ast_js.tok)
  | T_BIT_XOR of (Ast_js.tok)
  | T_BIT_AND of (Ast_js.tok)
  | T_EQUAL of (Ast_js.tok)
  | T_NOT_EQUAL of (Ast_js.tok)
  | T_STRICT_EQUAL of (Ast_js.tok)
  | T_STRICT_NOT_EQUAL of (Ast_js.tok)
  | T_LESS_THAN_EQUAL of (Ast_js.tok)
  | T_GREATER_THAN_EQUAL of (Ast_js.tok)
  | T_LESS_THAN of (Ast_js.tok)
  | T_GREATER_THAN of (Ast_js.tok)
  | T_LSHIFT of (Ast_js.tok)
  | T_RSHIFT of (Ast_js.tok)
  | T_RSHIFT3 of (Ast_js.tok)
  | T_PLUS of (Ast_js.tok)
  | T_MINUS of (Ast_js.tok)
  | T_DIV of (Ast_js.tok)
  | T_MULT of (Ast_js.tok)
  | T_MOD of (Ast_js.tok)
  | T_NOT of (Ast_js.tok)
  | T_BIT_NOT of (Ast_js.tok)
  | T_INCR of (Ast_js.tok)
  | T_DECR of (Ast_js.tok)
  | T_DELETE of (Ast_js.tok)
  | T_TYPEOF of (Ast_js.tok)
  | T_VOID of (Ast_js.tok)
  | T_XHP_OPEN_TAG of (string * Parse_info.info)
  | T_XHP_CLOSE_TAG of (string option * Parse_info.info)
  | T_XHP_GT of (Parse_info.info)
  | T_XHP_SLASH_GT of (Parse_info.info)
  | T_XHP_ATTR of (string * Parse_info.info)
  | T_XHP_TEXT of (string * Parse_info.info)
  | T_VIRTUAL_SEMICOLON of (Ast_js.tok)
  | TUnknown of (Ast_js.tok)
  | EOF of (Ast_js.tok)

val main :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_js.toplevel list
