/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class MethodInvocationMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        MethodInvocationMarker.incrementInvocationCount(programMethod);
    }

    private static void incrementInvocationCount(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.incrementInvocationCount();
        }
    }

    public static int getInvocationCount(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null ? methodOptimizationInfo.getInvocationCount() : Integer.MAX_VALUE;
    }
}

